/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class Ndef
extends BasicTagTechnology {
    private static final String TAG = "NFC";
    public static final int NDEF_MODE_READ_ONLY = 1;
    public static final int NDEF_MODE_READ_WRITE = 2;
    public static final int NDEF_MODE_UNKNOWN = 3;
    public static final String EXTRA_NDEF_MSG = "ndefmsg";
    public static final String EXTRA_NDEF_MAXLENGTH = "ndefmaxlength";
    public static final String EXTRA_NDEF_CARDSTATE = "ndefcardstate";
    public static final String EXTRA_NDEF_TYPE = "ndeftype";
    public static final int TYPE_OTHER = -1;
    public static final int TYPE_1 = 1;
    public static final int TYPE_2 = 2;
    public static final int TYPE_3 = 3;
    public static final int TYPE_4 = 4;
    public static final int TYPE_MIFARE_CLASSIC = 101;
    public static final int TYPE_ICODE_SLI = 102;
    public static final String UNKNOWN = "android.ndef.unknown";
    public static final String NFC_FORUM_TYPE_1 = "org.nfcforum.ndef.type1";
    public static final String NFC_FORUM_TYPE_2 = "org.nfcforum.ndef.type2";
    public static final String NFC_FORUM_TYPE_3 = "org.nfcforum.ndef.type3";
    public static final String NFC_FORUM_TYPE_4 = "org.nfcforum.ndef.type4";
    public static final String MIFARE_CLASSIC = "com.nxp.ndef.mifareclassic";
    public static final String ICODE_SLI = "com.nxp.ndef.icodesli";
    private final int mMaxNdefSize;
    private final int mCardState;
    private final NdefMessage mNdefMsg;
    private final int mNdefType;

    public static Ndef get(Tag tag) {
        if (!tag.hasTech(6)) {
            return null;
        }
        try {
            return new Ndef(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public Ndef(Tag tag) throws RemoteException {
        super(tag, 6);
        Bundle extras = tag.getTechExtras(6);
        if (extras == null) {
            throw new NullPointerException("NDEF tech extras are null.");
        }
        this.mMaxNdefSize = extras.getInt(EXTRA_NDEF_MAXLENGTH);
        this.mCardState = extras.getInt(EXTRA_NDEF_CARDSTATE);
        this.mNdefMsg = extras.getParcelable(EXTRA_NDEF_MSG, NdefMessage.class);
        this.mNdefType = extras.getInt(EXTRA_NDEF_TYPE);
    }

    public NdefMessage getCachedNdefMessage() {
        return this.mNdefMsg;
    }

    public String getType() {
        switch (this.mNdefType) {
            case 1: {
                return NFC_FORUM_TYPE_1;
            }
            case 2: {
                return NFC_FORUM_TYPE_2;
            }
            case 3: {
                return NFC_FORUM_TYPE_3;
            }
            case 4: {
                return NFC_FORUM_TYPE_4;
            }
            case 101: {
                return MIFARE_CLASSIC;
            }
            case 102: {
                return ICODE_SLI;
            }
        }
        return UNKNOWN;
    }

    public int getMaxSize() {
        return this.mMaxNdefSize;
    }

    public boolean isWritable() {
        return this.mCardState == 2;
    }

    public NdefMessage getNdefMessage() throws IOException, FormatException {
        this.checkConnected();
        try {
            INfcTag tagService = this.mTag.getTagService();
            if (tagService == null) {
                throw new IOException("Mock tags don't support this operation.");
            }
            int serviceHandle = this.mTag.getServiceHandle();
            if (tagService.isNdef(serviceHandle)) {
                NdefMessage msg = tagService.ndefRead(serviceHandle);
                if (msg == null && !tagService.isPresent(serviceHandle)) {
                    throw new TagLostException();
                }
                return msg;
            }
            if (!tagService.isPresent(serviceHandle)) {
                throw new TagLostException();
            }
            return null;
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return null;
        }
    }

    public void writeNdefMessage(NdefMessage msg) throws IOException, FormatException {
        block9: {
            this.checkConnected();
            try {
                INfcTag tagService = this.mTag.getTagService();
                if (tagService == null) {
                    throw new IOException("Mock tags don't support this operation.");
                }
                int serviceHandle = this.mTag.getServiceHandle();
                if (tagService.isNdef(serviceHandle)) {
                    int errorCode = tagService.ndefWrite(serviceHandle, msg);
                    switch (errorCode) {
                        case 0: {
                            break;
                        }
                        case -1: {
                            throw new IOException();
                        }
                        case -8: {
                            throw new FormatException();
                        }
                        default: {
                            throw new IOException();
                        }
                    }
                    break block9;
                }
                throw new IOException("Tag is not ndef");
            }
            catch (RemoteException e) {
                Log.e(TAG, "NFC service dead", e);
            }
        }
    }

    public boolean canMakeReadOnly() {
        INfcTag tagService = this.mTag.getTagService();
        if (tagService == null) {
            return false;
        }
        try {
            return tagService.canMakeReadOnly(this.mNdefType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return false;
        }
    }

    public boolean makeReadOnly() throws IOException {
        this.checkConnected();
        try {
            INfcTag tagService = this.mTag.getTagService();
            if (tagService == null) {
                return false;
            }
            if (tagService.isNdef(this.mTag.getServiceHandle())) {
                int errorCode = tagService.ndefMakeReadOnly(this.mTag.getServiceHandle());
                switch (errorCode) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        throw new IOException();
                    }
                    case -8: {
                        return false;
                    }
                }
                throw new IOException();
            }
            throw new IOException("Tag is not ndef");
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return false;
        }
    }
}

