/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.nfc.NfcAdapter;
import android.nfc.T4tNdefNfceeCcFileInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@FlaggedApi(value="android.nfc.nfc_oem_extension")
public class T4tNdefNfcee {
    private static final String TAG = "NdefNfcee";
    static T4tNdefNfcee sNdefNfcee;
    public static final int WRITE_DATA_SUCCESS = 0;
    public static final int WRITE_DATA_ERROR_INTERNAL = -1;
    public static final int WRITE_DATA_ERROR_RF_ACTIVATED = -2;
    public static final int WRITE_DATA_ERROR_NFC_NOT_ON = -3;
    public static final int WRITE_DATA_ERROR_INVALID_FILE_ID = -4;
    public static final int WRITE_DATA_ERROR_INVALID_LENGTH = -5;
    public static final int WRITE_DATA_ERROR_CONNECTION_FAILED = -6;
    public static final int WRITE_DATA_ERROR_EMPTY_PAYLOAD = -7;
    public static final int WRITE_DATA_ERROR_NDEF_VALIDATION_FAILED = -8;
    public static final int WRITE_DATA_ERROR_DEVICE_BUSY = -9;
    public static final int CLEAR_DATA_SUCCESS = 1;
    public static final int CLEAR_DATA_FAILED_INTERNAL = 0;
    public static final int CLEAR_DATA_FAILED_DEVICE_BUSY = -1;

    private T4tNdefNfcee() {
    }

    @NonNull
    public static T4tNdefNfcee getInstance() {
        if (sNdefNfcee == null) {
            sNdefNfcee = new T4tNdefNfcee();
        }
        return sNdefNfcee;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int writeData(int fileId, @NonNull byte[] data) {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().writeData(fileId, data), -1);
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public byte[] readData(int fileId) {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().readData(fileId), null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int clearData() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().clearNdefData(), 0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isOperationOngoing() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().isNdefOperationOngoing(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isSupported() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().isNdefNfceeEmulationSupported(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @Nullable
    public T4tNdefNfceeCcFileInfo readCcfile() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.getNdefNfceeService().readCcfile(), null);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClearDataStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteDataStatus {
    }
}

