/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INfcVendorNciCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.nfc.INfcVendorNciCallback";

    public void onVendorResponseReceived(int var1, int var2, byte[] var3) throws RemoteException;

    public void onVendorNotificationReceived(int var1, int var2, byte[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcVendorNciCallback {
        static final int TRANSACTION_onVendorResponseReceived = 1;
        static final int TRANSACTION_onVendorNotificationReceived = 2;

        public Stub() {
            this.attachInterface(this, INfcVendorNciCallback.DESCRIPTOR);
        }

        public static INfcVendorNciCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INfcVendorNciCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INfcVendorNciCallback) {
                return (INfcVendorNciCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onVendorResponseReceived";
                }
                case 2: {
                    return "onVendorNotificationReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INfcVendorNciCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onVendorResponseReceived(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onVendorNotificationReceived(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements INfcVendorNciCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INfcVendorNciCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVendorResponseReceived(int gid, int oid, byte[] payload) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcVendorNciCallback.DESCRIPTOR);
                    _data.writeInt(gid);
                    _data.writeInt(oid);
                    _data.writeByteArray(payload);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVendorNotificationReceived(int gid, int oid, byte[] payload) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcVendorNciCallback.DESCRIPTOR);
                    _data.writeInt(gid);
                    _data.writeInt(oid);
                    _data.writeByteArray(payload);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INfcVendorNciCallback {
        @Override
        public void onVendorResponseReceived(int gid, int oid, byte[] payload) throws RemoteException {
        }

        @Override
        public void onVendorNotificationReceived(int gid, int oid, byte[] payload) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

