/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.content.ComponentName;
import android.nfc.INfcEventCallback;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.ApduServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INfcCardEmulation
extends IInterface {
    public boolean isDefaultServiceForCategory(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean isDefaultServiceForAid(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean setDefaultServiceForCategory(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean setDefaultForNextTap(int var1, ComponentName var2) throws RemoteException;

    public boolean setShouldDefaultToObserveModeForService(int var1, ComponentName var2, boolean var3) throws RemoteException;

    public void setRequireDeviceScreenOnForService(int var1, ComponentName var2, boolean var3) throws RemoteException;

    public boolean isDeviceScreenOnRequiredForService(int var1, ComponentName var2) throws RemoteException;

    public void setRequireDeviceUnlockForService(int var1, ComponentName var2, boolean var3) throws RemoteException;

    public boolean isDeviceUnlockRequiredForService(int var1, ComponentName var2) throws RemoteException;

    public boolean registerAidGroupForService(int var1, ComponentName var2, AidGroup var3) throws RemoteException;

    public boolean registerPollingLoopFilterForService(int var1, ComponentName var2, String var3, boolean var4) throws RemoteException;

    public boolean registerPollingLoopPatternFilterForService(int var1, ComponentName var2, String var3, boolean var4) throws RemoteException;

    public boolean setOffHostForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean unsetOffHostForService(int var1, ComponentName var2) throws RemoteException;

    public AidGroup getAidGroupForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean removeAidGroupForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean removePollingLoopFilterForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean removePollingLoopPatternFilterForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public List<String> getPollingLoopFiltersForService(int var1, ComponentName var2) throws RemoteException;

    public List<String> getPollingLoopPatternFiltersForService(int var1, ComponentName var2) throws RemoteException;

    public List<ApduServiceInfo> getServices(int var1, String var2) throws RemoteException;

    public boolean setPreferredService(ComponentName var1) throws RemoteException;

    public boolean unsetPreferredService() throws RemoteException;

    public boolean supportsAidPrefixRegistration() throws RemoteException;

    public ApduServiceInfo getPreferredPaymentService(int var1) throws RemoteException;

    public int setServiceEnabledForCategoryOther(int var1, ComponentName var2, boolean var3) throws RemoteException;

    public boolean isDefaultPaymentRegistered() throws RemoteException;

    public void overrideRoutingTable(int var1, String var2, String var3, String var4) throws RemoteException;

    public void recoverRoutingTable(int var1) throws RemoteException;

    public boolean isEuiccSupported() throws RemoteException;

    public int getDefaultNfcSubscriptionId(String var1) throws RemoteException;

    public int setDefaultNfcSubscriptionId(int var1, String var2) throws RemoteException;

    public void setAutoChangeStatus(boolean var1) throws RemoteException;

    public boolean isAutoChangeEnabled() throws RemoteException;

    public List<String> getRoutingStatus() throws RemoteException;

    public void overwriteRoutingTable(int var1, String var2, String var3, String var4, String var5) throws RemoteException;

    public void registerNfcEventCallback(INfcEventCallback var1) throws RemoteException;

    public void unregisterNfcEventCallback(INfcEventCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcCardEmulation {
        public static final String DESCRIPTOR = "android.nfc.INfcCardEmulation";
        static final int TRANSACTION_isDefaultServiceForCategory = 1;
        static final int TRANSACTION_isDefaultServiceForAid = 2;
        static final int TRANSACTION_setDefaultServiceForCategory = 3;
        static final int TRANSACTION_setDefaultForNextTap = 4;
        static final int TRANSACTION_setShouldDefaultToObserveModeForService = 5;
        static final int TRANSACTION_setRequireDeviceScreenOnForService = 6;
        static final int TRANSACTION_isDeviceScreenOnRequiredForService = 7;
        static final int TRANSACTION_setRequireDeviceUnlockForService = 8;
        static final int TRANSACTION_isDeviceUnlockRequiredForService = 9;
        static final int TRANSACTION_registerAidGroupForService = 10;
        static final int TRANSACTION_registerPollingLoopFilterForService = 11;
        static final int TRANSACTION_registerPollingLoopPatternFilterForService = 12;
        static final int TRANSACTION_setOffHostForService = 13;
        static final int TRANSACTION_unsetOffHostForService = 14;
        static final int TRANSACTION_getAidGroupForService = 15;
        static final int TRANSACTION_removeAidGroupForService = 16;
        static final int TRANSACTION_removePollingLoopFilterForService = 17;
        static final int TRANSACTION_removePollingLoopPatternFilterForService = 18;
        static final int TRANSACTION_getPollingLoopFiltersForService = 19;
        static final int TRANSACTION_getPollingLoopPatternFiltersForService = 20;
        static final int TRANSACTION_getServices = 21;
        static final int TRANSACTION_setPreferredService = 22;
        static final int TRANSACTION_unsetPreferredService = 23;
        static final int TRANSACTION_supportsAidPrefixRegistration = 24;
        static final int TRANSACTION_getPreferredPaymentService = 25;
        static final int TRANSACTION_setServiceEnabledForCategoryOther = 26;
        static final int TRANSACTION_isDefaultPaymentRegistered = 27;
        static final int TRANSACTION_overrideRoutingTable = 28;
        static final int TRANSACTION_recoverRoutingTable = 29;
        static final int TRANSACTION_isEuiccSupported = 30;
        static final int TRANSACTION_getDefaultNfcSubscriptionId = 31;
        static final int TRANSACTION_setDefaultNfcSubscriptionId = 32;
        static final int TRANSACTION_setAutoChangeStatus = 33;
        static final int TRANSACTION_isAutoChangeEnabled = 34;
        static final int TRANSACTION_getRoutingStatus = 35;
        static final int TRANSACTION_overwriteRoutingTable = 36;
        static final int TRANSACTION_registerNfcEventCallback = 37;
        static final int TRANSACTION_unregisterNfcEventCallback = 38;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INfcCardEmulation asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INfcCardEmulation) {
                return (INfcCardEmulation)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isDefaultServiceForCategory";
                }
                case 2: {
                    return "isDefaultServiceForAid";
                }
                case 3: {
                    return "setDefaultServiceForCategory";
                }
                case 4: {
                    return "setDefaultForNextTap";
                }
                case 5: {
                    return "setShouldDefaultToObserveModeForService";
                }
                case 6: {
                    return "setRequireDeviceScreenOnForService";
                }
                case 7: {
                    return "isDeviceScreenOnRequiredForService";
                }
                case 8: {
                    return "setRequireDeviceUnlockForService";
                }
                case 9: {
                    return "isDeviceUnlockRequiredForService";
                }
                case 10: {
                    return "registerAidGroupForService";
                }
                case 11: {
                    return "registerPollingLoopFilterForService";
                }
                case 12: {
                    return "registerPollingLoopPatternFilterForService";
                }
                case 13: {
                    return "setOffHostForService";
                }
                case 14: {
                    return "unsetOffHostForService";
                }
                case 15: {
                    return "getAidGroupForService";
                }
                case 16: {
                    return "removeAidGroupForService";
                }
                case 17: {
                    return "removePollingLoopFilterForService";
                }
                case 18: {
                    return "removePollingLoopPatternFilterForService";
                }
                case 19: {
                    return "getPollingLoopFiltersForService";
                }
                case 20: {
                    return "getPollingLoopPatternFiltersForService";
                }
                case 21: {
                    return "getServices";
                }
                case 22: {
                    return "setPreferredService";
                }
                case 23: {
                    return "unsetPreferredService";
                }
                case 24: {
                    return "supportsAidPrefixRegistration";
                }
                case 25: {
                    return "getPreferredPaymentService";
                }
                case 26: {
                    return "setServiceEnabledForCategoryOther";
                }
                case 27: {
                    return "isDefaultPaymentRegistered";
                }
                case 28: {
                    return "overrideRoutingTable";
                }
                case 29: {
                    return "recoverRoutingTable";
                }
                case 30: {
                    return "isEuiccSupported";
                }
                case 31: {
                    return "getDefaultNfcSubscriptionId";
                }
                case 32: {
                    return "setDefaultNfcSubscriptionId";
                }
                case 33: {
                    return "setAutoChangeStatus";
                }
                case 34: {
                    return "isAutoChangeEnabled";
                }
                case 35: {
                    return "getRoutingStatus";
                }
                case 36: {
                    return "overwriteRoutingTable";
                }
                case 37: {
                    return "registerNfcEventCallback";
                }
                case 38: {
                    return "unregisterNfcEventCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDefaultServiceForCategory(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDefaultServiceForAid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDefaultServiceForCategory(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setDefaultForNextTap(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setShouldDefaultToObserveModeForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRequireDeviceScreenOnForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceScreenOnRequiredForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRequireDeviceUnlockForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceUnlockRequiredForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    AidGroup _arg2 = data.readTypedObject(AidGroup.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.registerAidGroupForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerPollingLoopFilterForService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerPollingLoopPatternFilterForService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setOffHostForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.unsetOffHostForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    AidGroup _result = this.getAidGroupForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeAidGroupForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.removePollingLoopFilterForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.removePollingLoopPatternFilterForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    List<String> _result = this.getPollingLoopFiltersForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    List<String> _result = this.getPollingLoopPatternFiltersForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<ApduServiceInfo> _result = this.getServices(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 22: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setPreferredService(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    boolean _result = this.unsetPreferredService();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    boolean _result = this.supportsAidPrefixRegistration();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ApduServiceInfo _result = this.getPreferredPaymentService(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setServiceEnabledForCategoryOther(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    boolean _result = this.isDefaultPaymentRegistered();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.overrideRoutingTable(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.recoverRoutingTable(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    boolean _result = this.isEuiccSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getDefaultNfcSubscriptionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.setDefaultNfcSubscriptionId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutoChangeStatus(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    boolean _result = this.isAutoChangeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    List<String> _result = this.getRoutingStatus();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.overwriteRoutingTable(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    INfcEventCallback _arg0 = INfcEventCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerNfcEventCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    INfcEventCallback _arg0 = INfcEventCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterNfcEventCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 37;
        }

        private static class Proxy
        implements INfcCardEmulation {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultServiceForCategory(int userHandle, ComponentName service, String category) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultServiceForAid(int userHandle, ComponentName service, String aid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(aid);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultServiceForCategory(int userHandle, ComponentName service, String category) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultForNextTap(int userHandle, ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setShouldDefaultToObserveModeForService(int userId, ComponentName service, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(service, 0);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRequireDeviceScreenOnForService(int userId, ComponentName service, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(service, 0);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceScreenOnRequiredForService(int userId, ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRequireDeviceUnlockForService(int userId, ComponentName service, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(service, 0);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceUnlockRequiredForService(int userId, ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerAidGroupForService(int userHandle, ComponentName service, AidGroup aidGroup) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeTypedObject(aidGroup, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerPollingLoopFilterForService(int userHandle, ComponentName service, String pollingLoopFilter, boolean autoTransact) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(pollingLoopFilter);
                    _data.writeBoolean(autoTransact);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerPollingLoopPatternFilterForService(int userHandle, ComponentName service, String pollingLoopPatternFilter, boolean autoTransact) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(pollingLoopPatternFilter);
                    _data.writeBoolean(autoTransact);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setOffHostForService(int userHandle, ComponentName service, String offHostSecureElement) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(offHostSecureElement);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unsetOffHostForService(int userHandle, ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AidGroup getAidGroupForService(int userHandle, ComponentName service, String category) throws RemoteException {
                AidGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AidGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeAidGroupForService(int userHandle, ComponentName service, String category) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removePollingLoopFilterForService(int userHandle, ComponentName service, String pollingLoopFilter) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(pollingLoopFilter);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removePollingLoopPatternFilterForService(int userHandle, ComponentName service, String pollingLoopPatternFilter) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(pollingLoopPatternFilter);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPollingLoopFiltersForService(int userHandle, ComponentName service) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPollingLoopPatternFiltersForService(int userHandle, ComponentName service) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ApduServiceInfo> getServices(int userHandle, String category) throws RemoteException {
                ArrayList<ApduServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ApduServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPreferredService(ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unsetPreferredService() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsAidPrefixRegistration() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ApduServiceInfo getPreferredPaymentService(int userHandle) throws RemoteException {
                ApduServiceInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ApduServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setServiceEnabledForCategoryOther(int userHandle, ComponentName app, boolean status) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(app, 0);
                    _data.writeBoolean(status);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultPaymentRegistered() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideRoutingTable(int userHandle, String protocol, String technology, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeString(protocol);
                    _data.writeString(technology);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverRoutingTable(int userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEuiccSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultNfcSubscriptionId(String pkg) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDefaultNfcSubscriptionId(int subscriptionId, String pkg) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoChangeStatus(boolean state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(state);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoChangeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getRoutingStatus() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overwriteRoutingTable(int userHandle, String emptyAid, String protocol, String tech, String sc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeString(emptyAid);
                    _data.writeString(protocol);
                    _data.writeString(tech);
                    _data.writeString(sc);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNfcEventCallback(INfcEventCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNfcEventCallback(INfcEventCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INfcCardEmulation {
        @Override
        public boolean isDefaultServiceForCategory(int userHandle, ComponentName service, String category) throws RemoteException {
            return false;
        }

        @Override
        public boolean isDefaultServiceForAid(int userHandle, ComponentName service, String aid) throws RemoteException {
            return false;
        }

        @Override
        public boolean setDefaultServiceForCategory(int userHandle, ComponentName service, String category) throws RemoteException {
            return false;
        }

        @Override
        public boolean setDefaultForNextTap(int userHandle, ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public boolean setShouldDefaultToObserveModeForService(int userId, ComponentName service, boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public void setRequireDeviceScreenOnForService(int userId, ComponentName service, boolean enable) throws RemoteException {
        }

        @Override
        public boolean isDeviceScreenOnRequiredForService(int userId, ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public void setRequireDeviceUnlockForService(int userId, ComponentName service, boolean enable) throws RemoteException {
        }

        @Override
        public boolean isDeviceUnlockRequiredForService(int userId, ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerAidGroupForService(int userHandle, ComponentName service, AidGroup aidGroup) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerPollingLoopFilterForService(int userHandle, ComponentName service, String pollingLoopFilter, boolean autoTransact) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerPollingLoopPatternFilterForService(int userHandle, ComponentName service, String pollingLoopPatternFilter, boolean autoTransact) throws RemoteException {
            return false;
        }

        @Override
        public boolean setOffHostForService(int userHandle, ComponentName service, String offHostSecureElement) throws RemoteException {
            return false;
        }

        @Override
        public boolean unsetOffHostForService(int userHandle, ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public AidGroup getAidGroupForService(int userHandle, ComponentName service, String category) throws RemoteException {
            return null;
        }

        @Override
        public boolean removeAidGroupForService(int userHandle, ComponentName service, String category) throws RemoteException {
            return false;
        }

        @Override
        public boolean removePollingLoopFilterForService(int userHandle, ComponentName service, String pollingLoopFilter) throws RemoteException {
            return false;
        }

        @Override
        public boolean removePollingLoopPatternFilterForService(int userHandle, ComponentName service, String pollingLoopPatternFilter) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getPollingLoopFiltersForService(int userHandle, ComponentName service) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getPollingLoopPatternFiltersForService(int userHandle, ComponentName service) throws RemoteException {
            return null;
        }

        @Override
        public List<ApduServiceInfo> getServices(int userHandle, String category) throws RemoteException {
            return null;
        }

        @Override
        public boolean setPreferredService(ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public boolean unsetPreferredService() throws RemoteException {
            return false;
        }

        @Override
        public boolean supportsAidPrefixRegistration() throws RemoteException {
            return false;
        }

        @Override
        public ApduServiceInfo getPreferredPaymentService(int userHandle) throws RemoteException {
            return null;
        }

        @Override
        public int setServiceEnabledForCategoryOther(int userHandle, ComponentName app, boolean status) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isDefaultPaymentRegistered() throws RemoteException {
            return false;
        }

        @Override
        public void overrideRoutingTable(int userHandle, String protocol, String technology, String pkg) throws RemoteException {
        }

        @Override
        public void recoverRoutingTable(int userHandle) throws RemoteException {
        }

        @Override
        public boolean isEuiccSupported() throws RemoteException {
            return false;
        }

        @Override
        public int getDefaultNfcSubscriptionId(String pkg) throws RemoteException {
            return 0;
        }

        @Override
        public int setDefaultNfcSubscriptionId(int subscriptionId, String pkg) throws RemoteException {
            return 0;
        }

        @Override
        public void setAutoChangeStatus(boolean state) throws RemoteException {
        }

        @Override
        public boolean isAutoChangeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public List<String> getRoutingStatus() throws RemoteException {
            return null;
        }

        @Override
        public void overwriteRoutingTable(int userHandle, String emptyAid, String protocol, String tech, String sc) throws RemoteException {
        }

        @Override
        public void registerNfcEventCallback(INfcEventCallback listener) throws RemoteException {
        }

        @Override
        public void unregisterNfcEventCallback(INfcEventCallback listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

