/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.WifiNetworkSpecifier;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareUtils;
import android.net.wifi.usd.Config;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.net.wifi.flags.usd")
public class SubscribeConfig
extends Config
implements Parcelable {
    private final int mSubscribeType;
    private final int mQueryPeriodMillis;
    private final int[] mRecommendedFrequencies;
    @NonNull
    public static final Parcelable.Creator<SubscribeConfig> CREATOR = new Parcelable.Creator<SubscribeConfig>(){

        @Override
        public SubscribeConfig createFromParcel(Parcel in) {
            return new SubscribeConfig(in);
        }

        public SubscribeConfig[] newArray(int size) {
            return new SubscribeConfig[size];
        }
    };

    private SubscribeConfig(Builder builder) {
        super(builder.mServiceName, builder.mTtlSeconds, builder.mServiceProtoType, builder.mTxMatchFilterTlv, builder.mRxMatchFilterTlv, builder.mServiceSpecificInfo, builder.mOperatingFrequencies);
        this.mSubscribeType = builder.mSubscribeType;
        this.mQueryPeriodMillis = builder.mQueryPeriodMillis;
        this.mRecommendedFrequencies = builder.mRecommendedFrequencies;
    }

    private SubscribeConfig(Parcel in) {
        super(in.createByteArray(), in.readInt(), in.readInt(), in.createByteArray(), in.createByteArray(), in.createByteArray(), in.createIntArray());
        this.mSubscribeType = in.readInt();
        this.mQueryPeriodMillis = in.readInt();
        this.mRecommendedFrequencies = in.createIntArray();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByteArray(this.getServiceName());
        dest.writeInt(this.getTtlSeconds());
        dest.writeInt(this.getServiceProtoType());
        dest.writeByteArray(this.getTxMatchFilterTlv());
        dest.writeByteArray(this.getRxMatchFilterTlv());
        dest.writeByteArray(this.getServiceSpecificInfo());
        dest.writeIntArray(this.getOperatingFrequenciesMhz());
        dest.writeInt(this.mSubscribeType);
        dest.writeInt(this.mQueryPeriodMillis);
        dest.writeIntArray(this.mRecommendedFrequencies);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getSubscribeType() {
        return this.mSubscribeType;
    }

    public int getQueryPeriodMillis() {
        return this.mQueryPeriodMillis;
    }

    @Nullable
    public int[] getRecommendedOperatingFrequenciesMhz() {
        return this.mRecommendedFrequencies;
    }

    @Override
    public String toString() {
        return super.toString() + " SubscribeConfig{mSubscribeType=" + this.mSubscribeType + ", mQueryPeriodMillis=" + this.mQueryPeriodMillis + ", mRecommendedFrequencies=" + Arrays.toString(this.mRecommendedFrequencies) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribeConfig)) {
            return false;
        }
        SubscribeConfig that = (SubscribeConfig)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.mSubscribeType == that.mSubscribeType && this.mQueryPeriodMillis == that.mQueryPeriodMillis && Arrays.equals(this.mRecommendedFrequencies, that.mRecommendedFrequencies);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.mSubscribeType, this.mQueryPeriodMillis);
        result = 31 * result + Arrays.hashCode(this.mRecommendedFrequencies);
        return result;
    }

    @FlaggedApi(value="android.net.wifi.flags.usd")
    public static class Builder {
        private int mSubscribeType = 1;
        private int mQueryPeriodMillis = 100;
        private int[] mRecommendedFrequencies = null;
        private final byte[] mServiceName;
        private int mTtlSeconds = 3000;
        private int mServiceProtoType = 0;
        private byte[] mTxMatchFilterTlv = null;
        private byte[] mRxMatchFilterTlv = null;
        private byte[] mServiceSpecificInfo = null;
        private int[] mOperatingFrequencies = null;

        public Builder(@NonNull String serviceName) {
            Objects.requireNonNull(serviceName, "serviceName must not be null");
            this.mServiceName = serviceName.getBytes(StandardCharsets.UTF_8);
            WifiAwareUtils.validateServiceName(this.mServiceName);
        }

        @NonNull
        public Builder setTtlSeconds(int ttlSeconds) {
            if (ttlSeconds < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSeconds = ttlSeconds;
            return this;
        }

        @NonNull
        public Builder setServiceProtoType(int serviceProtoType) {
            if (serviceProtoType < 0 || serviceProtoType > 1) {
                throw new IllegalArgumentException("Invalid serviceProtoType - " + serviceProtoType);
            }
            this.mServiceProtoType = serviceProtoType;
            return this;
        }

        @NonNull
        public Builder setTxMatchFilter(@NonNull List<byte[]> txMatchFilter) {
            Objects.requireNonNull(txMatchFilter, "txMatchFilter must not be null");
            this.mTxMatchFilterTlv = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(txMatchFilter).getArray();
            if (!TlvBufferUtils.isValid(this.mTxMatchFilterTlv, 0, 1)) {
                throw new IllegalArgumentException("Invalid txMatchFilter configuration - LV fields do not match up to length");
            }
            return this;
        }

        @NonNull
        public Builder setRxMatchFilter(@NonNull List<byte[]> rxMatchFilter) {
            Objects.requireNonNull(rxMatchFilter, "rxMatchFilter must not be null");
            this.mRxMatchFilterTlv = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(rxMatchFilter).getArray();
            if (!TlvBufferUtils.isValid(this.mRxMatchFilterTlv, 0, 1)) {
                throw new IllegalArgumentException("Invalid rxMatchFilter configuration - LV fields do not match up to length");
            }
            return this;
        }

        @NonNull
        public Builder setSubscribeType(int subscribeType) {
            if (subscribeType < 0 || subscribeType > 1) {
                throw new IllegalArgumentException("Invalid subscribeType - " + subscribeType);
            }
            this.mSubscribeType = subscribeType;
            return this;
        }

        @NonNull
        public Builder setQueryPeriodMillis(int queryPeriodMillis) {
            if (queryPeriodMillis < 0) {
                throw new IllegalArgumentException("Invalid queryPeriodMillis - must be non-negative");
            }
            this.mQueryPeriodMillis = queryPeriodMillis;
            return this;
        }

        @NonNull
        public Builder setRecommendedOperatingFrequenciesMhz(@NonNull int[] recommendedFrequencies) {
            Objects.requireNonNull(recommendedFrequencies, "recommendedFrequencies must not be null");
            if (recommendedFrequencies.length > 32 || !WifiNetworkSpecifier.validateChannelFrequencyInMhz(recommendedFrequencies)) {
                throw new IllegalArgumentException("Invalid recommendedFrequencies");
            }
            this.mRecommendedFrequencies = (int[])recommendedFrequencies.clone();
            return this;
        }

        @NonNull
        public Builder setServiceSpecificInfo(@NonNull byte[] serviceSpecificInfo) {
            Objects.requireNonNull(serviceSpecificInfo, "serviceSpecificInfo must not be null");
            this.mServiceSpecificInfo = (byte[])serviceSpecificInfo.clone();
            return this;
        }

        @NonNull
        public Builder setOperatingFrequenciesMhz(@NonNull int[] operatingFrequencies) {
            Objects.requireNonNull(operatingFrequencies, "operatingFrequencies must not be null");
            if (operatingFrequencies.length > 32 || !WifiNetworkSpecifier.validateChannelFrequencyInMhz(operatingFrequencies)) {
                throw new IllegalArgumentException("Invalid operatingFrequencies");
            }
            this.mOperatingFrequencies = (int[])operatingFrequencies.clone();
            return this;
        }

        @NonNull
        public SubscribeConfig build() {
            return new SubscribeConfig(this);
        }
    }
}

