/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.twt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class TwtRequest
implements Parcelable {
    private final int mMinWakeDurationMicros;
    private final int mMaxWakeDurationMicros;
    private final long mMinWakeIntervalMicros;
    private final long mMaxWakeIntervalMicros;
    private final int mLinkId;
    @NonNull
    public static final Parcelable.Creator<TwtRequest> CREATOR = new Parcelable.Creator<TwtRequest>(){

        @Override
        public TwtRequest createFromParcel(Parcel in) {
            Builder builder = new Builder(in.readInt(), in.readInt(), in.readLong(), in.readLong());
            int mloLinkId = in.readInt();
            if (mloLinkId >= 0 && mloLinkId <= 15) {
                builder.setLinkId(mloLinkId);
            }
            return builder.build();
        }

        public TwtRequest[] newArray(int size) {
            return new TwtRequest[size];
        }
    };

    private TwtRequest(Builder builder) {
        this.mMinWakeDurationMicros = builder.mMinWakeDurationMicros;
        this.mMaxWakeDurationMicros = builder.mMaxWakeDurationMicros;
        this.mMinWakeIntervalMicros = builder.mMinWakeIntervalMicros;
        this.mMaxWakeIntervalMicros = builder.mMaxWakeIntervalMicros;
        this.mLinkId = builder.mLinkId;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMinWakeDurationMicros() {
        return this.mMinWakeDurationMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMaxWakeDurationMicros() {
        return this.mMaxWakeDurationMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getMinWakeIntervalMicros() {
        return this.mMinWakeIntervalMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getMaxWakeIntervalMicros() {
        return this.mMaxWakeIntervalMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getLinkId() {
        return this.mLinkId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mMinWakeDurationMicros);
        dest.writeInt(this.mMaxWakeDurationMicros);
        dest.writeLong(this.mMinWakeIntervalMicros);
        dest.writeLong(this.mMinWakeIntervalMicros);
        dest.writeInt(this.mLinkId);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private final int mMinWakeDurationMicros;
        private final int mMaxWakeDurationMicros;
        private final long mMinWakeIntervalMicros;
        private final long mMaxWakeIntervalMicros;
        private int mLinkId = -1;

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setLinkId(int linkId) {
            if (linkId < 0 || linkId > 15) {
                throw new IllegalArgumentException("linkId is out of range");
            }
            this.mLinkId = linkId;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public Builder(int minWakeDurationMicros, int maxWakeDurationMicros, long minWakeIntervalMicros, long maxWakeIntervalMicros) {
            this.mMinWakeDurationMicros = minWakeDurationMicros;
            this.mMaxWakeDurationMicros = maxWakeDurationMicros;
            this.mMinWakeIntervalMicros = minWakeIntervalMicros;
            this.mMaxWakeIntervalMicros = maxWakeIntervalMicros;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public TwtRequest build() {
            return new TwtRequest(this);
        }
    }
}

