/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.service;

import android.net.wifi.sharedconnectivity.app.HotspotNetwork;
import android.net.wifi.sharedconnectivity.app.HotspotNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.KnownNetwork;
import android.net.wifi.sharedconnectivity.app.KnownNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.SharedConnectivitySettingsState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISharedConnectivityCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.sharedconnectivity.service.ISharedConnectivityCallback";

    public void onHotspotNetworksUpdated(List<HotspotNetwork> var1) throws RemoteException;

    public void onHotspotNetworkConnectionStatusChanged(HotspotNetworkConnectionStatus var1) throws RemoteException;

    public void onKnownNetworksUpdated(List<KnownNetwork> var1) throws RemoteException;

    public void onKnownNetworkConnectionStatusChanged(KnownNetworkConnectionStatus var1) throws RemoteException;

    public void onSharedConnectivitySettingsChanged(SharedConnectivitySettingsState var1) throws RemoteException;

    public void onServiceConnected() throws RemoteException;

    public void onServiceDisconnected() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISharedConnectivityCallback {
        static final int TRANSACTION_onHotspotNetworksUpdated = 1;
        static final int TRANSACTION_onHotspotNetworkConnectionStatusChanged = 2;
        static final int TRANSACTION_onKnownNetworksUpdated = 3;
        static final int TRANSACTION_onKnownNetworkConnectionStatusChanged = 4;
        static final int TRANSACTION_onSharedConnectivitySettingsChanged = 5;
        static final int TRANSACTION_onServiceConnected = 6;
        static final int TRANSACTION_onServiceDisconnected = 7;

        public Stub() {
            this.attachInterface(this, ISharedConnectivityCallback.DESCRIPTOR);
        }

        public static ISharedConnectivityCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISharedConnectivityCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISharedConnectivityCallback) {
                return (ISharedConnectivityCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onHotspotNetworksUpdated";
                }
                case 2: {
                    return "onHotspotNetworkConnectionStatusChanged";
                }
                case 3: {
                    return "onKnownNetworksUpdated";
                }
                case 4: {
                    return "onKnownNetworkConnectionStatusChanged";
                }
                case 5: {
                    return "onSharedConnectivitySettingsChanged";
                }
                case 6: {
                    return "onServiceConnected";
                }
                case 7: {
                    return "onServiceDisconnected";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISharedConnectivityCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<HotspotNetwork> _arg0 = data.createTypedArrayList(HotspotNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHotspotNetworksUpdated(_arg0);
                    break;
                }
                case 2: {
                    HotspotNetworkConnectionStatus _arg0 = data.readTypedObject(HotspotNetworkConnectionStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHotspotNetworkConnectionStatusChanged(_arg0);
                    break;
                }
                case 3: {
                    ArrayList<KnownNetwork> _arg0 = data.createTypedArrayList(KnownNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.onKnownNetworksUpdated(_arg0);
                    break;
                }
                case 4: {
                    KnownNetworkConnectionStatus _arg0 = data.readTypedObject(KnownNetworkConnectionStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onKnownNetworkConnectionStatusChanged(_arg0);
                    break;
                }
                case 5: {
                    SharedConnectivitySettingsState _arg0 = data.readTypedObject(SharedConnectivitySettingsState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSharedConnectivitySettingsChanged(_arg0);
                    break;
                }
                case 6: {
                    this.onServiceConnected();
                    break;
                }
                case 7: {
                    this.onServiceDisconnected();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements ISharedConnectivityCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISharedConnectivityCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotspotNetworksUpdated(List<HotspotNetwork> networks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    _data.writeTypedList(networks, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotspotNetworkConnectionStatusChanged(HotspotNetworkConnectionStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKnownNetworksUpdated(List<KnownNetwork> networks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    _data.writeTypedList(networks, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKnownNetworkConnectionStatusChanged(KnownNetworkConnectionStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSharedConnectivitySettingsChanged(SharedConnectivitySettingsState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onServiceConnected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onServiceDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISharedConnectivityCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISharedConnectivityCallback {
        @Override
        public void onHotspotNetworksUpdated(List<HotspotNetwork> networks) throws RemoteException {
        }

        @Override
        public void onHotspotNetworkConnectionStatusChanged(HotspotNetworkConnectionStatus status) throws RemoteException {
        }

        @Override
        public void onKnownNetworksUpdated(List<KnownNetwork> networks) throws RemoteException {
        }

        @Override
        public void onKnownNetworkConnectionStatusChanged(KnownNetworkConnectionStatus status) throws RemoteException {
        }

        @Override
        public void onSharedConnectivitySettingsChanged(SharedConnectivitySettingsState state) throws RemoteException {
        }

        @Override
        public void onServiceConnected() throws RemoteException {
        }

        @Override
        public void onServiceDisconnected() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

