/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.wifi.sharedconnectivity.app.KnownNetwork;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class KnownNetworkConnectionStatus
implements Parcelable {
    public static final int CONNECTION_STATUS_UNKNOWN = 0;
    public static final int CONNECTION_STATUS_SAVED = 1;
    public static final int CONNECTION_STATUS_SAVE_FAILED = 2;
    private final int mStatus;
    private final KnownNetwork mKnownNetwork;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<KnownNetworkConnectionStatus> CREATOR = new Parcelable.Creator<KnownNetworkConnectionStatus>(){

        @Override
        public KnownNetworkConnectionStatus createFromParcel(Parcel in) {
            return KnownNetworkConnectionStatus.readFromParcel(in);
        }

        public KnownNetworkConnectionStatus[] newArray(int size) {
            return new KnownNetworkConnectionStatus[size];
        }
    };

    private static void validate(int status) {
        if (status != 0 && status != 1 && status != 2) {
            throw new IllegalArgumentException("Illegal connection status");
        }
    }

    private KnownNetworkConnectionStatus(int status, KnownNetwork knownNetwork, @NonNull Bundle extras) {
        KnownNetworkConnectionStatus.validate(status);
        this.mStatus = status;
        this.mKnownNetwork = knownNetwork;
        this.mExtras = extras;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @NonNull
    public KnownNetwork getKnownNetwork() {
        return this.mKnownNetwork;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KnownNetworkConnectionStatus)) {
            return false;
        }
        KnownNetworkConnectionStatus other = (KnownNetworkConnectionStatus)obj;
        return this.mStatus == other.getStatus() && Objects.equals(this.mKnownNetwork, other.getKnownNetwork());
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mKnownNetwork);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        this.mKnownNetwork.writeToParcel(dest, flags);
        dest.writeBundle(this.mExtras);
    }

    @NonNull
    public static KnownNetworkConnectionStatus readFromParcel(@NonNull Parcel in) {
        return new KnownNetworkConnectionStatus(in.readInt(), KnownNetwork.readFromParcel(in), in.readBundle());
    }

    public String toString() {
        return "KnownNetworkConnectionStatus[" + "status=" + this.mStatus + "known network=" + this.mKnownNetwork.toString() + "extras=" + this.mExtras.toString() + "]";
    }

    public static class Builder {
        private int mStatus;
        private KnownNetwork mKnownNetwork;
        private Bundle mExtras = Bundle.EMPTY;

        @NonNull
        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        public Builder setKnownNetwork(@NonNull KnownNetwork knownNetwork) {
            this.mKnownNetwork = knownNetwork;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public KnownNetworkConnectionStatus build() {
            return new KnownNetworkConnectionStatus(this.mStatus, this.mKnownNetwork, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionStatus {
    }
}

