/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.sharedconnectivity.app.NetworkProviderInfo;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class HotspotNetwork
implements Parcelable {
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_CELLULAR = 1;
    public static final int NETWORK_TYPE_WIFI = 2;
    public static final int NETWORK_TYPE_ETHERNET = 3;
    private final long mDeviceId;
    private final NetworkProviderInfo mNetworkProviderInfo;
    private final int mNetworkType;
    private final String mNetworkName;
    @Nullable
    private final String mHotspotSsid;
    @Nullable
    private final String mHotspotBssid;
    @Nullable
    private final ArraySet<Integer> mHotspotSecurityTypes;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<HotspotNetwork> CREATOR = new Parcelable.Creator<HotspotNetwork>(){

        @Override
        public HotspotNetwork createFromParcel(Parcel in) {
            return HotspotNetwork.readFromParcel(in);
        }

        public HotspotNetwork[] newArray(int size) {
            return new HotspotNetwork[size];
        }
    };

    private static void validate(long deviceId, int networkType, String networkName, NetworkProviderInfo networkProviderInfo) {
        if (deviceId < 0L) {
            throw new IllegalArgumentException("DeviceId must be set");
        }
        if (Objects.isNull(networkProviderInfo)) {
            throw new IllegalArgumentException("NetworkProviderInfo must be set");
        }
        if (networkType != 1 && networkType != 2 && networkType != 3 && networkType != 0) {
            throw new IllegalArgumentException("Illegal network type");
        }
        if (Objects.isNull(networkName)) {
            throw new IllegalArgumentException("NetworkName must be set");
        }
    }

    private HotspotNetwork(long deviceId, NetworkProviderInfo networkProviderInfo, int networkType, @NonNull String networkName, @Nullable String hotspotSsid, @Nullable String hotspotBssid, @Nullable ArraySet<Integer> hotspotSecurityTypes, @NonNull Bundle extras) {
        HotspotNetwork.validate(deviceId, networkType, networkName, networkProviderInfo);
        this.mDeviceId = deviceId;
        this.mNetworkProviderInfo = networkProviderInfo;
        this.mNetworkType = networkType;
        this.mNetworkName = networkName;
        this.mHotspotSsid = hotspotSsid;
        this.mHotspotBssid = hotspotBssid;
        this.mHotspotSecurityTypes = new ArraySet<Integer>(hotspotSecurityTypes);
        this.mExtras = extras;
    }

    public long getDeviceId() {
        return this.mDeviceId;
    }

    @NonNull
    public NetworkProviderInfo getNetworkProviderInfo() {
        return this.mNetworkProviderInfo;
    }

    public int getHostNetworkType() {
        return this.mNetworkType;
    }

    @NonNull
    public String getNetworkName() {
        return this.mNetworkName;
    }

    @Nullable
    public String getHotspotSsid() {
        return this.mHotspotSsid;
    }

    @Nullable
    public String getHotspotBssid() {
        return this.mHotspotBssid;
    }

    @NonNull
    public Set<Integer> getHotspotSecurityTypes() {
        return this.mHotspotSecurityTypes;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HotspotNetwork)) {
            return false;
        }
        HotspotNetwork other = (HotspotNetwork)obj;
        return this.mDeviceId == other.getDeviceId() && Objects.equals(this.mNetworkProviderInfo, other.getNetworkProviderInfo()) && this.mNetworkType == other.getHostNetworkType() && Objects.equals(this.mNetworkName, other.getNetworkName()) && Objects.equals(this.mHotspotSsid, other.getHotspotSsid()) && Objects.equals(this.mHotspotBssid, other.getHotspotBssid()) && Objects.equals(this.mHotspotSecurityTypes, other.getHotspotSecurityTypes());
    }

    public int hashCode() {
        return Objects.hash(this.mDeviceId, this.mNetworkProviderInfo, this.mNetworkName, this.mHotspotSsid, this.mHotspotBssid, this.mHotspotSecurityTypes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mDeviceId);
        this.mNetworkProviderInfo.writeToParcel(dest, flags);
        dest.writeInt(this.mNetworkType);
        dest.writeString(this.mNetworkName);
        dest.writeString(this.mHotspotSsid);
        dest.writeString(this.mHotspotBssid);
        dest.writeArraySet(this.mHotspotSecurityTypes);
        dest.writeBundle(this.mExtras);
    }

    @NonNull
    public static HotspotNetwork readFromParcel(@NonNull Parcel in) {
        return new HotspotNetwork(in.readLong(), NetworkProviderInfo.readFromParcel(in), in.readInt(), in.readString(), in.readString(), in.readString(), in.readArraySet(null), in.readBundle());
    }

    public String toString() {
        return "HotspotNetwork[" + "deviceId=" + this.mDeviceId + ", networkType=" + this.mNetworkType + ", networkProviderInfo=" + this.mNetworkProviderInfo.toString() + ", networkName=" + this.mNetworkName + ", hotspotSsid=" + this.mHotspotSsid + ", hotspotBssid=" + this.mHotspotBssid + ", hotspotSecurityTypes=" + this.mHotspotSecurityTypes.toString() + ", extras=" + this.mExtras.toString() + "]";
    }

    public static class Builder {
        private long mDeviceId = -1L;
        private NetworkProviderInfo mNetworkProviderInfo;
        private int mNetworkType;
        private String mNetworkName;
        @Nullable
        private String mHotspotSsid;
        @Nullable
        private String mHotspotBssid;
        @Nullable
        private final ArraySet<Integer> mHotspotSecurityTypes = new ArraySet();
        private Bundle mExtras = Bundle.EMPTY;

        @NonNull
        public Builder setDeviceId(long deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        @NonNull
        public Builder setNetworkProviderInfo(@NonNull NetworkProviderInfo networkProviderInfo) {
            this.mNetworkProviderInfo = networkProviderInfo;
            return this;
        }

        @NonNull
        public Builder setHostNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        @NonNull
        public Builder setNetworkName(@NonNull String networkName) {
            this.mNetworkName = networkName;
            return this;
        }

        @NonNull
        public Builder setHotspotSsid(@NonNull String hotspotSsid) {
            this.mHotspotSsid = hotspotSsid;
            return this;
        }

        @NonNull
        public Builder setHotspotBssid(@NonNull String hotspotBssid) {
            this.mHotspotBssid = hotspotBssid;
            return this;
        }

        @NonNull
        public Builder addHotspotSecurityType(int hotspotSecurityType) {
            this.mHotspotSecurityTypes.add(hotspotSecurityType);
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public HotspotNetwork build() {
            return new HotspotNetwork(this.mDeviceId, this.mNetworkProviderInfo, this.mNetworkType, this.mNetworkName, this.mHotspotSsid, this.mHotspotBssid, this.mHotspotSecurityTypes, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkType {
    }
}

