/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=36)
@FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
public class WifiP2pPairingBootstrappingConfig
implements Parcelable {
    public static final int PAIRING_BOOTSTRAPPING_METHOD_OPPORTUNISTIC = 1;
    public static final int PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PINCODE = 2;
    public static final int PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PASSPHRASE = 4;
    public static final int PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PINCODE = 8;
    public static final int PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PASSPHRASE = 16;
    public static final int PAIRING_BOOTSTRAPPING_METHOD_OUT_OF_BAND = 32;
    private int mPairingBootstrappingMethod;
    @Nullable
    private String mPassword;
    @NonNull
    public static final Parcelable.Creator<WifiP2pPairingBootstrappingConfig> CREATOR = new Parcelable.Creator<WifiP2pPairingBootstrappingConfig>(){

        @Override
        public WifiP2pPairingBootstrappingConfig createFromParcel(Parcel in) {
            int pairingBootstrappingMethod = in.readInt();
            String password = in.readString();
            WifiP2pPairingBootstrappingConfig config = new WifiP2pPairingBootstrappingConfig(pairingBootstrappingMethod, password);
            return config;
        }

        public WifiP2pPairingBootstrappingConfig[] newArray(int size) {
            return new WifiP2pPairingBootstrappingConfig[size];
        }
    };

    private static boolean isValidPairingBootstrappingMethod(int method) {
        switch (method) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public int getPairingBootstrappingMethod() {
        return this.mPairingBootstrappingMethod;
    }

    public String getPairingBootstrappingPassword() {
        return this.mPassword;
    }

    public void setPairingBootstrappingPassword(@NonNull String password) {
        this.mPassword = password;
    }

    public WifiP2pPairingBootstrappingConfig(int method, @Nullable String password) {
        if (!WifiP2pPairingBootstrappingConfig.isValidPairingBootstrappingMethod(method)) {
            throw new IllegalArgumentException("Invalid PairingBootstrappingMethod =" + method);
        }
        this.mPairingBootstrappingMethod = method;
        if (!(TextUtils.isEmpty(password) || method != 1 && method != 8 && method != 16)) {
            throw new IllegalArgumentException("Password is not required for =" + method);
        }
        this.mPassword = password;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("WifiP2pPairingBootstrappingConfig:");
        sbuf.append("\n BootstrappingMethod: ").append(this.mPairingBootstrappingMethod);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pPairingBootstrappingConfig(@NonNull WifiP2pPairingBootstrappingConfig source) {
        if (source != null) {
            this.mPairingBootstrappingMethod = source.mPairingBootstrappingMethod;
            this.mPassword = source.mPassword;
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPairingBootstrappingMethod);
        dest.writeString(this.mPassword);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PairingBootstrappingMethod {
    }
}

