/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.aware.AwarePairingConfig;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareUtils;
import android.net.wifi.rtt.RangingRequest;
import android.net.wifi.rtt.ResponderConfig;
import android.net.wifi.util.HexEncoding;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SubscribeConfig
implements Parcelable {
    public static final int SUBSCRIBE_TYPE_PASSIVE = 0;
    public static final int SUBSCRIBE_TYPE_ACTIVE = 1;
    private static final int AWARE_BAND_2_DISCOVERY_CHANNEL = 2437;
    private static final int MIN_RTT_BURST_SIZE = RangingRequest.getMinRttBurstSize();
    private static final int MAX_RTT_BURST_SIZE = RangingRequest.getMaxRttBurstSize();
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_NONE = 0;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_128TU = 128;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_256TU = 256;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_512TU = 512;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_1024TU = 1024;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_2048TU = 2048;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_4096TU = 4096;
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public static final int PERIODIC_RANGING_INTERVAL_8192TU = 8192;
    public final byte[] mServiceName;
    public final byte[] mServiceSpecificInfo;
    public final byte[] mMatchFilter;
    public final int mSubscribeType;
    public final int mTtlSec;
    public final boolean mEnableTerminateNotification;
    public final boolean mMinDistanceMmSet;
    public final int mMinDistanceMm;
    public final boolean mMaxDistanceMmSet;
    public final int mMaxDistanceMm;
    private final boolean mEnableInstantMode;
    private final int mBand;
    private final AwarePairingConfig mPairingConfig;
    private final boolean mIsSuspendable;
    private final List<OuiKeyedData> mVendorData;
    public final int mPeriodicRangingInterval;
    public final boolean mPeriodicRangingEnabled;
    public final int mRttBurstSize;
    public final int mFrequencyMhz;
    public final int mCenterFrequency0Mhz;
    public final int mCenterFrequency1Mhz;
    public final int mPreamble;
    public final int mChannelWidth;
    @NonNull
    public static final Parcelable.Creator<SubscribeConfig> CREATOR = new Parcelable.Creator<SubscribeConfig>(){

        public SubscribeConfig[] newArray(int size) {
            return new SubscribeConfig[size];
        }

        @Override
        public SubscribeConfig createFromParcel(Parcel in) {
            byte[] serviceName = in.createByteArray();
            byte[] ssi = in.createByteArray();
            byte[] matchFilter = in.createByteArray();
            int subscribeType = in.readInt();
            int ttlSec = in.readInt();
            boolean enableTerminateNotification = in.readInt() != 0;
            int minDistanceMm = in.readInt();
            boolean minDistanceMmSet = in.readInt() != 0;
            int maxDistanceMm = in.readInt();
            boolean maxDistanceMmSet = in.readInt() != 0;
            boolean enableInstantMode = in.readBoolean();
            int band = in.readInt();
            AwarePairingConfig pairingConfig = (AwarePairingConfig)in.readParcelable(AwarePairingConfig.class.getClassLoader());
            boolean isSuspendable = in.readBoolean();
            List<OuiKeyedData> vendorData = ParcelUtil.readOuiKeyedDataList(in);
            int rangingInterval = in.readInt();
            boolean enablePeriodicRanging = in.readBoolean();
            int burstSize = in.readInt();
            int frequencyMhz = in.readInt();
            int centerFrequency0Mhz = in.readInt();
            int centerFrequency1Mhz = in.readInt();
            int preamble = in.readInt();
            int channelWidth = in.readInt();
            return new SubscribeConfig(serviceName, ssi, matchFilter, subscribeType, ttlSec, enableTerminateNotification, minDistanceMmSet, minDistanceMm, maxDistanceMmSet, maxDistanceMm, enableInstantMode, band, pairingConfig, isSuspendable, vendorData, rangingInterval, enablePeriodicRanging, burstSize, frequencyMhz, centerFrequency0Mhz, centerFrequency1Mhz, preamble, channelWidth);
        }
    };

    public SubscribeConfig(byte[] serviceName, byte[] serviceSpecificInfo, byte[] matchFilter, int subscribeType, int ttlSec, boolean enableTerminateNotification, boolean minDistanceMmSet, int minDistanceMm, boolean maxDistanceMmSet, int maxDistanceMm, boolean enableInstantMode, int band, AwarePairingConfig pairingConfig, boolean isSuspendable, @NonNull List<OuiKeyedData> vendorData, int rangingInterval, boolean enablePeriodicRanging, int rttBurstSize, int frequencyMhz, int centerFrequency0Mhz, int centerFrequency1Mhz, int preamble, int channelWidth) {
        this.mServiceName = serviceName;
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mMatchFilter = matchFilter;
        this.mSubscribeType = subscribeType;
        this.mTtlSec = ttlSec;
        this.mEnableTerminateNotification = enableTerminateNotification;
        this.mMinDistanceMm = minDistanceMm;
        this.mMinDistanceMmSet = minDistanceMmSet;
        this.mMaxDistanceMm = maxDistanceMm;
        this.mMaxDistanceMmSet = maxDistanceMmSet;
        this.mEnableInstantMode = enableInstantMode;
        this.mBand = band;
        this.mPairingConfig = pairingConfig;
        this.mIsSuspendable = isSuspendable;
        this.mVendorData = vendorData;
        this.mPeriodicRangingInterval = rangingInterval;
        this.mPeriodicRangingEnabled = enablePeriodicRanging;
        this.mRttBurstSize = rttBurstSize;
        this.mFrequencyMhz = frequencyMhz;
        this.mCenterFrequency0Mhz = centerFrequency0Mhz;
        this.mCenterFrequency1Mhz = centerFrequency1Mhz;
        this.mPreamble = preamble;
        this.mChannelWidth = channelWidth;
    }

    public String toString() {
        return "SubscribeConfig [mServiceName='" + (this.mServiceName == null ? "<null>" : String.valueOf(HexEncoding.encode(this.mServiceName))) + ", mServiceName.length=" + (this.mServiceName == null ? 0 : this.mServiceName.length) + ", mServiceSpecificInfo='" + (this.mServiceSpecificInfo == null ? "<null>" : String.valueOf(HexEncoding.encode(this.mServiceSpecificInfo))) + ", mServiceSpecificInfo.length=" + (this.mServiceSpecificInfo == null ? 0 : this.mServiceSpecificInfo.length) + ", mMatchFilter=" + new TlvBufferUtils.TlvIterable(0, 1, this.mMatchFilter).toString() + ", mMatchFilter.length=" + (this.mMatchFilter == null ? 0 : this.mMatchFilter.length) + ", mSubscribeType=" + this.mSubscribeType + ", mTtlSec=" + this.mTtlSec + ", mEnableTerminateNotification=" + this.mEnableTerminateNotification + ", mMinDistanceMm=" + this.mMinDistanceMm + ", mMinDistanceMmSet=" + this.mMinDistanceMmSet + ", mMaxDistanceMm=" + this.mMaxDistanceMm + ", mMaxDistanceMmSet=" + this.mMaxDistanceMmSet + "], mEnableInstantMode=" + this.mEnableInstantMode + ", mBand=" + this.mBand + ", mPairingConfig" + this.mPairingConfig + ", mIsSuspendable=" + this.mIsSuspendable + ", mVendorData=" + this.mVendorData + "], mPeriodicRangingInterval" + this.mPeriodicRangingInterval + ", mPeriodicRangingEnabled" + this.mPeriodicRangingEnabled + ", mRttBurstSize" + this.mRttBurstSize + ", mFrequencyMhz" + this.mFrequencyMhz + ", mCenterFrequency0Mhz" + this.mCenterFrequency0Mhz + ", mCenterFrequency1Mhz" + this.mCenterFrequency1Mhz + ", mPreamble" + this.mPreamble + ", mChannelWidth" + this.mChannelWidth;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mServiceName);
        dest.writeByteArray(this.mServiceSpecificInfo);
        dest.writeByteArray(this.mMatchFilter);
        dest.writeInt(this.mSubscribeType);
        dest.writeInt(this.mTtlSec);
        dest.writeInt(this.mEnableTerminateNotification ? 1 : 0);
        dest.writeInt(this.mMinDistanceMm);
        dest.writeInt(this.mMinDistanceMmSet ? 1 : 0);
        dest.writeInt(this.mMaxDistanceMm);
        dest.writeInt(this.mMaxDistanceMmSet ? 1 : 0);
        dest.writeBoolean(this.mEnableInstantMode);
        dest.writeInt(this.mBand);
        dest.writeParcelable(this.mPairingConfig, flags);
        dest.writeBoolean(this.mIsSuspendable);
        dest.writeList(this.mVendorData);
        dest.writeInt(this.mPeriodicRangingInterval);
        dest.writeBoolean(this.mPeriodicRangingEnabled);
        dest.writeInt(this.mRttBurstSize);
        dest.writeInt(this.mFrequencyMhz);
        dest.writeInt(this.mCenterFrequency0Mhz);
        dest.writeInt(this.mCenterFrequency1Mhz);
        dest.writeInt(this.mPreamble);
        dest.writeInt(this.mChannelWidth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribeConfig)) {
            return false;
        }
        SubscribeConfig lhs = (SubscribeConfig)o;
        if (!(Arrays.equals(this.mServiceName, lhs.mServiceName) && Arrays.equals(this.mServiceSpecificInfo, lhs.mServiceSpecificInfo) && Arrays.equals(this.mMatchFilter, lhs.mMatchFilter) && this.mSubscribeType == lhs.mSubscribeType && this.mTtlSec == lhs.mTtlSec && this.mEnableTerminateNotification == lhs.mEnableTerminateNotification && this.mMinDistanceMmSet == lhs.mMinDistanceMmSet && this.mMaxDistanceMmSet == lhs.mMaxDistanceMmSet && this.mEnableInstantMode == lhs.mEnableInstantMode && this.mBand == lhs.mBand && this.mIsSuspendable == lhs.mIsSuspendable && Objects.equals(this.mVendorData, lhs.mVendorData) && this.mPeriodicRangingEnabled == lhs.mPeriodicRangingEnabled && this.mRttBurstSize == lhs.mRttBurstSize && this.mFrequencyMhz == lhs.mFrequencyMhz && this.mCenterFrequency0Mhz == lhs.mCenterFrequency0Mhz && this.mCenterFrequency1Mhz == lhs.mCenterFrequency1Mhz && this.mPreamble == lhs.mPreamble && this.mChannelWidth == lhs.mChannelWidth)) {
            return false;
        }
        if (this.mMinDistanceMmSet && this.mMinDistanceMm != lhs.mMinDistanceMm) {
            return false;
        }
        if (this.mMaxDistanceMmSet && this.mMaxDistanceMm != lhs.mMaxDistanceMm) {
            return false;
        }
        return !this.mPeriodicRangingEnabled || this.mPeriodicRangingInterval == lhs.mPeriodicRangingInterval;
    }

    public int hashCode() {
        int result = Objects.hash(Arrays.hashCode(this.mServiceName), Arrays.hashCode(this.mServiceSpecificInfo), Arrays.hashCode(this.mMatchFilter), this.mSubscribeType, this.mTtlSec, this.mEnableTerminateNotification, this.mMinDistanceMmSet, this.mMaxDistanceMmSet, this.mEnableInstantMode, this.mBand, this.mIsSuspendable, this.mVendorData, this.mPeriodicRangingEnabled, this.mRttBurstSize, this.mFrequencyMhz, this.mCenterFrequency0Mhz, this.mCenterFrequency1Mhz, this.mPreamble, this.mChannelWidth);
        if (this.mMinDistanceMmSet) {
            result = Objects.hash(result, this.mMinDistanceMm);
        }
        if (this.mMaxDistanceMmSet) {
            result = Objects.hash(result, this.mMaxDistanceMm);
        }
        if (this.mPeriodicRangingEnabled) {
            result = Objects.hash(result, this.mPeriodicRangingInterval);
        }
        return result;
    }

    public void assertValid(Characteristics characteristics, boolean rttSupported) throws IllegalArgumentException {
        WifiAwareUtils.validateServiceName(this.mServiceName);
        if (!TlvBufferUtils.isValid(this.mMatchFilter, 0, 1)) {
            throw new IllegalArgumentException("Invalid matchFilter configuration - LV fields do not match up to length");
        }
        if (this.mSubscribeType < 0 || this.mSubscribeType > 1) {
            throw new IllegalArgumentException("Invalid subscribeType - " + this.mSubscribeType);
        }
        if (this.mTtlSec < 0) {
            throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
        }
        if (characteristics != null) {
            int maxServiceNameLength = characteristics.getMaxServiceNameLength();
            if (maxServiceNameLength != 0 && this.mServiceName.length > maxServiceNameLength) {
                throw new IllegalArgumentException("Service name longer than supported by device characteristics");
            }
            int maxServiceSpecificInfoLength = characteristics.getMaxServiceSpecificInfoLength();
            if (maxServiceSpecificInfoLength != 0 && this.mServiceSpecificInfo != null && this.mServiceSpecificInfo.length > maxServiceSpecificInfoLength) {
                throw new IllegalArgumentException("Service specific info longer than supported by device characteristics");
            }
            int maxMatchFilterLength = characteristics.getMaxMatchFilterLength();
            if (maxMatchFilterLength != 0 && this.mMatchFilter != null && this.mMatchFilter.length > maxMatchFilterLength) {
                throw new IllegalArgumentException("Match filter longer than supported by device characteristics");
            }
            if (!(!this.mEnableInstantMode || SdkLevel.isAtLeastT() && characteristics.isInstantCommunicationModeSupported())) {
                throw new IllegalArgumentException("instant mode is not supported");
            }
            if (this.mIsSuspendable && !characteristics.isSuspensionSupported()) {
                throw new IllegalArgumentException("Aware Suspension is not supported");
            }
            if (this.mPairingConfig != null && !characteristics.isAwarePairingSupported()) {
                throw new IllegalArgumentException("Aware Pairing is not supported");
            }
        }
        if (this.mMinDistanceMmSet && this.mMinDistanceMm < 0) {
            throw new IllegalArgumentException("Minimum distance must be non-negative");
        }
        if (this.mMaxDistanceMmSet && this.mMaxDistanceMm < 0) {
            throw new IllegalArgumentException("Maximum distance must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && (this.mMinDistanceMmSet || this.mMaxDistanceMmSet)) {
            throw new IllegalArgumentException("Either Periodic Ranging or Min/Max distance is allowed. Not both.");
        }
        if (!rttSupported && (this.mMinDistanceMmSet || this.mMaxDistanceMmSet)) {
            throw new IllegalArgumentException("Ranging is not supported");
        }
        if (!(rttSupported && characteristics.isPeriodicRangingSupported() || !this.mPeriodicRangingEnabled)) {
            throw new IllegalArgumentException("Periodic ranging is not supported");
        }
        if (this.mPeriodicRangingEnabled && this.mPeriodicRangingInterval < 0) {
            throw new IllegalArgumentException("Periodic ranging interval must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mRttBurstSize < 0) {
            throw new IllegalArgumentException("Rtt Burst size must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mFrequencyMhz < 0) {
            throw new IllegalArgumentException(" Frequency must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mCenterFrequency0Mhz < 0) {
            throw new IllegalArgumentException("Center Frequency0 must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mCenterFrequency1Mhz < 0) {
            throw new IllegalArgumentException("Center Frequency1 must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mPreamble < 0) {
            throw new IllegalArgumentException("Preamble must be non-negative");
        }
        if (this.mPeriodicRangingEnabled && this.mChannelWidth < 0) {
            throw new IllegalArgumentException("Channel width must be non-negative");
        }
    }

    public boolean isInstantCommunicationModeEnabled() {
        return this.mEnableInstantMode;
    }

    public int getInstantCommunicationBand() {
        return this.mBand;
    }

    @Nullable
    public AwarePairingConfig getPairingConfig() {
        return this.mPairingConfig;
    }

    @SystemApi
    @RequiresApi(value=34)
    public boolean isSuspendable() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        return this.mIsSuspendable;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData != null ? this.mVendorData : Collections.emptyList();
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public boolean isPeriodicRangingEnabled() {
        return this.mPeriodicRangingEnabled;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getPeriodicRangingInterval() {
        return this.mPeriodicRangingInterval;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getRttBurstSize() {
        return this.mRttBurstSize;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getFrequencyMhz() {
        return this.mFrequencyMhz;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getCenterFreq0Mhz() {
        return this.mCenterFrequency0Mhz;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getCenterFreq1Mhz() {
        return this.mCenterFrequency1Mhz;
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getPreamble() {
        return ResponderConfig.translateFromLocalToScanResultPreamble(this.mPreamble);
    }

    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
    public int getChannelWidth() {
        return ResponderConfig.translateFromLocalToScanResultChannelWidth(this.mChannelWidth);
    }

    public static class Builder {
        private byte[] mServiceName;
        private byte[] mServiceSpecificInfo;
        private byte[] mMatchFilter;
        private int mSubscribeType = 0;
        private int mTtlSec = 0;
        private boolean mEnableTerminateNotification = true;
        private boolean mMinDistanceMmSet = false;
        private int mMinDistanceMm;
        private boolean mMaxDistanceMmSet = false;
        private int mMaxDistanceMm;
        private boolean mEnableInstantMode;
        private int mBand = 1;
        private AwarePairingConfig mPairingConfig;
        private boolean mIsSuspendable = false;
        @NonNull
        private List<OuiKeyedData> mVendorData = Collections.emptyList();
        private boolean mPeriodicRangingEnabled = false;
        private int mPeriodicRangingInterval = 512;
        private int mRttBurstSize = RangingRequest.getDefaultRttBurstSize();
        private int mFrequencyMhz = 2437;
        private int mCenterFrequency0Mhz = 0;
        private int mCenterFrequency1Mhz = 0;
        private int mPreamble = 1;
        private int mChannelWidth = 0;

        public Builder setServiceName(@NonNull String serviceName) {
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid service name - must be non-null");
            }
            this.mServiceName = serviceName.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder setServiceSpecificInfo(@Nullable byte[] serviceSpecificInfo) {
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        public Builder setMatchFilter(@Nullable List<byte[]> matchFilter) {
            this.mMatchFilter = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(matchFilter).getArray();
            return this;
        }

        public Builder setSubscribeType(int subscribeType) {
            if (subscribeType < 0 || subscribeType > 1) {
                throw new IllegalArgumentException("Invalid subscribeType - " + subscribeType);
            }
            this.mSubscribeType = subscribeType;
            return this;
        }

        public Builder setTtlSec(int ttlSec) {
            if (ttlSec < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSec = ttlSec;
            return this;
        }

        public Builder setTerminateNotificationEnabled(boolean enable) {
            this.mEnableTerminateNotification = enable;
            return this;
        }

        public Builder setMinDistanceMm(int minDistanceMm) {
            this.mMinDistanceMm = minDistanceMm;
            this.mMinDistanceMmSet = true;
            return this;
        }

        public Builder setMaxDistanceMm(int maxDistanceMm) {
            this.mMaxDistanceMm = maxDistanceMm;
            this.mMaxDistanceMmSet = true;
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder setInstantCommunicationModeEnabled(boolean enabled, int band) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            if (band != 1 && band != 2) {
                throw new IllegalArgumentException();
            }
            this.mBand = band;
            this.mEnableInstantMode = enabled;
            return this;
        }

        @RequiresApi(value=34)
        @NonNull
        public Builder setPairingConfig(@Nullable AwarePairingConfig config) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mPairingConfig = config;
            return this;
        }

        @SystemApi
        @RequiresApi(value=34)
        @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
        @NonNull
        public Builder setSuspendable(boolean isSuspendable) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mIsSuspendable = isSuspendable;
            return this;
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setPeriodicRangingInterval(int interval) {
            if (interval != 0 && interval != 128 && interval != 256 && interval != 512 && interval != 1024 && interval != 2048 && interval != 4096 && interval != 8192) {
                throw new IllegalArgumentException("Invalid Ranging interval - " + interval);
            }
            this.mPeriodicRangingInterval = interval;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setPeriodicRangingEnabled(boolean enable) {
            this.mPeriodicRangingEnabled = enable;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setRttBurstSize(int burstSize) {
            if (burstSize < MIN_RTT_BURST_SIZE || burstSize > MAX_RTT_BURST_SIZE) {
                throw new IllegalArgumentException("RTT burst size out of range.");
            }
            this.mRttBurstSize = burstSize;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setFrequencyMhz(int frequency) {
            this.mFrequencyMhz = frequency;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setCenterFreq0Mhz(int centerFreq0) {
            this.mCenterFrequency0Mhz = centerFreq0;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setCenterFreq1Mhz(int centerFreq1) {
            this.mCenterFrequency1Mhz = centerFreq1;
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setPreamble(int preamble) {
            this.mPreamble = ResponderConfig.translateFromScanResultToLocalPreamble(preamble);
            return this;
        }

        @SystemApi
        @NonNull
        @FlaggedApi(value="com.android.ranging.flags.ranging_rtt_enabled")
        public Builder setChannelWidth(int channelWidth) {
            this.mChannelWidth = ResponderConfig.translateFromScanResultToLocalChannelWidth(channelWidth);
            return this;
        }

        public SubscribeConfig build() {
            return new SubscribeConfig(this.mServiceName, this.mServiceSpecificInfo, this.mMatchFilter, this.mSubscribeType, this.mTtlSec, this.mEnableTerminateNotification, this.mMinDistanceMmSet, this.mMinDistanceMm, this.mMaxDistanceMmSet, this.mMaxDistanceMm, this.mEnableInstantMode, this.mBand, this.mPairingConfig, this.mIsSuspendable, this.mVendorData, this.mPeriodicRangingInterval, this.mPeriodicRangingEnabled, this.mRttBurstSize, this.mFrequencyMhz, this.mCenterFrequency0Mhz, this.mCenterFrequency1Mhz, this.mPreamble, this.mChannelWidth);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PeriodicRangingInterval {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscribeTypes {
    }
}

