/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.annotation.SystemApi;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.aware.AwarePairingConfig;
import android.net.wifi.aware.PeerHandle;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ServiceDiscoveryInfo {
    private final byte[] mServiceSpecificInfo;
    private final List<byte[]> mMatchFilters;
    private final int mPeerCipherSuite;
    private final byte[] mScid;
    private final PeerHandle mPeerHandle;
    private final String mPairingAlias;
    private final AwarePairingConfig mPairingConfig;
    private final List<OuiKeyedData> mVendorData;

    public ServiceDiscoveryInfo(PeerHandle peerHandle, int peerCipherSuite, @Nullable byte[] serviceSpecificInfo, @NonNull List<byte[]> matchFilter, @Nullable byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, @Nullable OuiKeyedData[] vendorData) {
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mMatchFilters = matchFilter;
        this.mPeerCipherSuite = peerCipherSuite;
        this.mScid = scid;
        this.mPeerHandle = peerHandle;
        this.mPairingAlias = pairingAlias;
        this.mPairingConfig = pairingConfig;
        this.mVendorData = vendorData != null ? Arrays.asList(vendorData) : Collections.emptyList();
    }

    @NonNull
    public PeerHandle getPeerHandle() {
        return this.mPeerHandle;
    }

    @NonNull
    public List<byte[]> getMatchFilters() {
        return this.mMatchFilters;
    }

    @Nullable
    public byte[] getServiceSpecificInfo() {
        return this.mServiceSpecificInfo;
    }

    @Nullable
    public byte[] getScid() {
        return this.mScid;
    }

    public int getPeerCipherSuite() {
        return this.mPeerCipherSuite;
    }

    @Nullable
    public String getPairedAlias() {
        return this.mPairingAlias;
    }

    @Nullable
    public AwarePairingConfig getPairingConfig() {
        return this.mPairingConfig;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData != null ? this.mVendorData : Collections.emptyList();
    }
}

