/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.NetworkSpecifier;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareUtils;
import android.util.CloseGuard;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class DiscoverySession
implements AutoCloseable {
    private static final String TAG = "DiscoverySession";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final int MAX_SEND_RETRY_COUNT = 5;
    protected WeakReference<WifiAwareManager> mMgr;
    protected final int mClientId;
    protected final int mSessionId;
    protected boolean mTerminated = false;
    private final CloseGuard mCloseGuard = new CloseGuard();

    public static int getMaxSendRetryCount() {
        return 5;
    }

    public DiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mClientId = clientId;
        this.mSessionId = sessionId;
        this.mCloseGuard.open("close");
    }

    @Override
    public void close() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.terminateSession(this.mClientId, this.mSessionId);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
        Reference.reachabilityFence(this);
    }

    public void setTerminated() {
        if (this.mTerminated) {
            Log.w(TAG, "terminate: already terminated.");
            return;
        }
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mTerminated) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    public int getClientId() {
        return this.mClientId;
    }

    @VisibleForTesting
    public int getSessionId() {
        return this.mSessionId;
    }

    public void sendMessage(@NonNull PeerHandle peerHandle, int messageId, @Nullable byte[] message, int retryCount) {
        if (this.mTerminated) {
            Log.w(TAG, "sendMessage: called on terminated session");
            return;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "sendMessage: called post GC on WifiAwareManager");
            return;
        }
        mgr.sendMessage(this.mClientId, this.mSessionId, peerHandle, message, messageId, retryCount);
    }

    public void sendMessage(@NonNull PeerHandle peerHandle, int messageId, @Nullable byte[] message) {
        this.sendMessage(peerHandle, messageId, message, 0);
    }

    @RequiresApi(value=34)
    public void initiatePairingRequest(@NonNull PeerHandle peerHandle, @NonNull String peerDeviceAlias, int cipherSuite, @Nullable String password) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "initiatePairingRequest: called post GC on WifiAwareManager");
            return;
        }
        mgr.initiateNanPairingSetupRequest(this.mClientId, this.mSessionId, peerHandle, password, peerDeviceAlias, cipherSuite);
    }

    @RequiresApi(value=34)
    public void acceptPairingRequest(int requestId, @NonNull PeerHandle peerHandle, @NonNull String peerDeviceAlias, int cipherSuite, @Nullable String password) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "initiatePairingRequest: called post GC on WifiAwareManager");
            return;
        }
        mgr.responseNanPairingSetupRequest(this.mClientId, this.mSessionId, peerHandle, requestId, password, peerDeviceAlias, true, cipherSuite);
    }

    @RequiresApi(value=34)
    public void rejectPairingRequest(int requestId, @NonNull PeerHandle peerHandle) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "initiatePairingRequest: called post GC on WifiAwareManager");
            return;
        }
        mgr.responseNanPairingSetupRequest(this.mClientId, this.mSessionId, peerHandle, requestId, null, null, false, 16);
    }

    @RequiresApi(value=34)
    public void initiateBootstrappingRequest(@NonNull PeerHandle peerHandle, int method) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "initiatePairingRequest: called post GC on WifiAwareManager");
            return;
        }
        mgr.initiateBootStrappingSetupRequest(this.mClientId, this.mSessionId, peerHandle, method);
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void suspend() {
        if (this.mTerminated) {
            throw new IllegalStateException("Suspend called on a terminated session.");
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            throw new IllegalStateException("Failed to get WifiAwareManager.");
        }
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        mgr.suspend(this.mClientId, this.mSessionId);
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void resume() {
        if (this.mTerminated) {
            throw new IllegalStateException("Resume called on a terminated session.");
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            throw new IllegalStateException("Failed to get WifiAwareManager.");
        }
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        mgr.resume(this.mClientId, this.mSessionId);
    }

    @Deprecated
    public NetworkSpecifier createNetworkSpecifierOpen(@NonNull PeerHandle peerHandle) {
        if (this.mTerminated) {
            Log.w(TAG, "createNetworkSpecifierOpen: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "createNetworkSpecifierOpen: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, null, null);
    }

    @Deprecated
    public NetworkSpecifier createNetworkSpecifierPassphrase(@NonNull PeerHandle peerHandle, @NonNull String passphrase) {
        if (!WifiAwareUtils.validatePassphrase(passphrase)) {
            throw new IllegalArgumentException("Passphrase must meet length requirements");
        }
        if (this.mTerminated) {
            Log.w(TAG, "createNetworkSpecifierPassphrase: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "createNetworkSpecifierPassphrase: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, null, passphrase);
    }

    @Deprecated
    @SystemApi
    public NetworkSpecifier createNetworkSpecifierPmk(@NonNull PeerHandle peerHandle, @NonNull byte[] pmk) {
        if (!WifiAwareUtils.validatePmk(pmk)) {
            throw new IllegalArgumentException("PMK must 32 bytes");
        }
        if (this.mTerminated) {
            Log.w(TAG, "createNetworkSpecifierPmk: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "createNetworkSpecifierPmk: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, pmk, null);
    }
}

