/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

@SystemApi
public class WifiUsabilityStatsEntry
implements Parcelable {
    private static final String TAG = "WifiUsabilityStatsEntry";
    public static final int LINK_STATE_UNKNOWN = 0;
    public static final int LINK_STATE_NOT_IN_USE = 1;
    public static final int LINK_STATE_IN_USE = 2;
    public static final int PROBE_STATUS_UNKNOWN = 0;
    public static final int PROBE_STATUS_NO_PROBE = 1;
    public static final int PROBE_STATUS_SUCCESS = 2;
    public static final int PROBE_STATUS_FAILURE = 3;
    private final long mTimeStampMillis;
    private final int mRssi;
    private final int mLinkSpeedMbps;
    private final long mTotalTxSuccess;
    private final long mTotalTxRetries;
    private final long mTotalTxBad;
    private final long mTotalRxSuccess;
    private final long mTotalRadioOnTimeMillis;
    private final long mTotalRadioTxTimeMillis;
    private final long mTotalRadioRxTimeMillis;
    private final long mTotalScanTimeMillis;
    private final long mTotalNanScanTimeMillis;
    private final long mTotalBackgroundScanTimeMillis;
    private final long mTotalRoamScanTimeMillis;
    private final long mTotalPnoScanTimeMillis;
    private final long mTotalHotspot2ScanTimeMillis;
    private final long mTotalCcaBusyFreqTimeMillis;
    private final long mTotalRadioOnFreqTimeMillis;
    private final long mTotalBeaconRx;
    private final int mProbeStatusSinceLastUpdate;
    private final int mProbeElapsedTimeSinceLastUpdateMillis;
    private final int mProbeMcsRateSinceLastUpdate;
    private final int mRxLinkSpeedMbps;
    private final int mTimeSliceDutyCycleInPercent;
    private final int mWifiLinkCount;
    private int mMloMode;
    private final long mTxTransmittedBytes;
    private final long mRxTransmittedBytes;
    private final int mLabelBadEventCount;
    private final int mWifiFrameworkState;
    private final int mIsNetworkCapabilitiesDownstreamSufficient;
    private final int mIsNetworkCapabilitiesUpstreamSufficient;
    private final int mIsThroughputPredictorDownstreamSufficient;
    private final int mIsThroughputPredictorUpstreamSufficient;
    private final boolean mIsBluetoothConnected;
    private final int mUwbAdapterState;
    private final boolean mIsLowLatencyActivated;
    private final int mMaxSupportedTxLinkSpeed;
    private final int mMaxSupportedRxLinkSpeed;
    private final int mVoipMode;
    private final int mThreadDeviceRole;
    private final int mStatusDataStall;
    public static final int WME_ACCESS_CATEGORY_BE = 0;
    public static final int WME_ACCESS_CATEGORY_BK = 1;
    public static final int WME_ACCESS_CATEGORY_VI = 2;
    public static final int WME_ACCESS_CATEGORY_VO = 3;
    public static final int NUM_WME_ACCESS_CATEGORIES = 4;
    private final ContentionTimeStats[] mContentionTimeStats;
    public static final int WIFI_PREAMBLE_OFDM = 0;
    public static final int WIFI_PREAMBLE_CCK = 1;
    public static final int WIFI_PREAMBLE_HT = 2;
    public static final int WIFI_PREAMBLE_VHT = 3;
    public static final int WIFI_PREAMBLE_HE = 5;
    public static final int WIFI_PREAMBLE_EHT = 6;
    public static final int WIFI_PREAMBLE_INVALID = -1;
    public static final int WIFI_SPATIAL_STREAMS_ONE = 1;
    public static final int WIFI_SPATIAL_STREAMS_TWO = 2;
    public static final int WIFI_SPATIAL_STREAMS_THREE = 3;
    public static final int WIFI_SPATIAL_STREAMS_FOUR = 4;
    public static final int WIFI_SPATIAL_STREAMS_INVALID = -1;
    public static final int WIFI_BANDWIDTH_20_MHZ = 0;
    public static final int WIFI_BANDWIDTH_40_MHZ = 1;
    public static final int WIFI_BANDWIDTH_80_MHZ = 2;
    public static final int WIFI_BANDWIDTH_160_MHZ = 3;
    public static final int WIFI_BANDWIDTH_80P80_MHZ = 4;
    public static final int WIFI_BANDWIDTH_5_MHZ = 5;
    public static final int WIFI_BANDWIDTH_10_MHZ = 6;
    public static final int WIFI_BANDWIDTH_320_MHZ = 7;
    public static final int WIFI_BANDWIDTH_INVALID = -1;
    private final RateStats[] mRateStats;
    private final RadioStats[] mRadioStats;
    private final int mChannelUtilizationRatio;
    private final boolean mIsThroughputSufficient;
    private final boolean mIsWifiScoringEnabled;
    private final boolean mIsCellularDataAvailable;
    private final int mCellularDataNetworkType;
    private final int mCellularSignalStrengthDbm;
    private final int mCellularSignalStrengthDb;
    private final boolean mIsSameRegisteredCell;
    private final SparseArray<LinkStats> mLinkStats;
    @NonNull
    public static final Parcelable.Creator<WifiUsabilityStatsEntry> CREATOR = new Parcelable.Creator<WifiUsabilityStatsEntry>(){

        @Override
        public WifiUsabilityStatsEntry createFromParcel(Parcel in) {
            return new WifiUsabilityStatsEntry(in.readLong(), in.readInt(), in.readInt(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.createTypedArray(ContentionTimeStats.CREATOR), in.createTypedArray(RateStats.CREATOR), in.createTypedArray(RadioStats.CREATOR), in.readInt(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readInt(), in.readInt(), in.readInt(), in.readBoolean(), in.readSparseArray(LinkStats.class.getClassLoader()), in.readInt(), in.readInt(), in.readLong(), in.readLong(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readBoolean(), in.readInt(), in.readBoolean(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }

        public WifiUsabilityStatsEntry[] newArray(int size) {
            return new WifiUsabilityStatsEntry[size];
        }
    };

    public static String getLinkStateString(int state) {
        switch (state) {
            case 1: {
                return "LINK_STATE_NOT_IN_USE";
            }
            case 2: {
                return "LINK_STATE_IN_USE";
            }
        }
        return "LINK_STATE_UNKNOWN";
    }

    public WifiUsabilityStatsEntry(long timeStampMillis, int rssi, int linkSpeedMbps, long totalTxSuccess, long totalTxRetries, long totalTxBad, long totalRxSuccess, long totalRadioOnTimeMillis, long totalRadioTxTimeMillis, long totalRadioRxTimeMillis, long totalScanTimeMillis, long totalNanScanTimeMillis, long totalBackgroundScanTimeMillis, long totalRoamScanTimeMillis, long totalPnoScanTimeMillis, long totalHotspot2ScanTimeMillis, long totalCcaBusyFreqTimeMillis, long totalRadioOnFreqTimeMillis, long totalBeaconRx, int probeStatusSinceLastUpdate, int probeElapsedTimeSinceLastUpdateMillis, int probeMcsRateSinceLastUpdate, int rxLinkSpeedMbps, int timeSliceDutyCycleInPercent, ContentionTimeStats[] contentionTimeStats, RateStats[] rateStats, RadioStats[] radiostats, int channelUtilizationRatio, boolean isThroughputSufficient, boolean isWifiScoringEnabled, boolean isCellularDataAvailable, int cellularDataNetworkType, int cellularSignalStrengthDbm, int cellularSignalStrengthDb, boolean isSameRegisteredCell, SparseArray<LinkStats> linkStats, int wifiLinkCount, int mloMode, long txTransmittedBytes, long rxTransmittedBytes, int labelBadEventCount, int wifiFrameworkState, int isNetworkCapabilitiesDownstreamSufficient, int isNetworkCapabilitiesUpstreamSufficient, int isThroughputPredictorDownstreamSufficient, int isThroughputPredictorUpstreamSufficient, boolean isBluetoothConnected, int uwbAdapterState, boolean isLowLatencyActivated, int maxSupportedTxLinkSpeed, int maxSupportedRxLinkSpeed, int voipMode, int threadDeviceRole, int statusDataStall) {
        this.mTimeStampMillis = timeStampMillis;
        this.mRssi = rssi;
        this.mLinkSpeedMbps = linkSpeedMbps;
        this.mTotalTxSuccess = totalTxSuccess;
        this.mTotalTxRetries = totalTxRetries;
        this.mTotalTxBad = totalTxBad;
        this.mTotalRxSuccess = totalRxSuccess;
        this.mTotalRadioOnTimeMillis = totalRadioOnTimeMillis;
        this.mTotalRadioTxTimeMillis = totalRadioTxTimeMillis;
        this.mTotalRadioRxTimeMillis = totalRadioRxTimeMillis;
        this.mTotalScanTimeMillis = totalScanTimeMillis;
        this.mTotalNanScanTimeMillis = totalNanScanTimeMillis;
        this.mTotalBackgroundScanTimeMillis = totalBackgroundScanTimeMillis;
        this.mTotalRoamScanTimeMillis = totalRoamScanTimeMillis;
        this.mTotalPnoScanTimeMillis = totalPnoScanTimeMillis;
        this.mTotalHotspot2ScanTimeMillis = totalHotspot2ScanTimeMillis;
        this.mTotalCcaBusyFreqTimeMillis = totalCcaBusyFreqTimeMillis;
        this.mTotalRadioOnFreqTimeMillis = totalRadioOnFreqTimeMillis;
        this.mTotalBeaconRx = totalBeaconRx;
        this.mProbeStatusSinceLastUpdate = probeStatusSinceLastUpdate;
        this.mProbeElapsedTimeSinceLastUpdateMillis = probeElapsedTimeSinceLastUpdateMillis;
        this.mProbeMcsRateSinceLastUpdate = probeMcsRateSinceLastUpdate;
        this.mRxLinkSpeedMbps = rxLinkSpeedMbps;
        this.mTimeSliceDutyCycleInPercent = timeSliceDutyCycleInPercent;
        this.mContentionTimeStats = contentionTimeStats;
        this.mRateStats = rateStats;
        this.mRadioStats = radiostats;
        this.mChannelUtilizationRatio = channelUtilizationRatio;
        this.mIsThroughputSufficient = isThroughputSufficient;
        this.mIsWifiScoringEnabled = isWifiScoringEnabled;
        this.mIsCellularDataAvailable = isCellularDataAvailable;
        this.mCellularDataNetworkType = cellularDataNetworkType;
        this.mCellularSignalStrengthDbm = cellularSignalStrengthDbm;
        this.mCellularSignalStrengthDb = cellularSignalStrengthDb;
        this.mIsSameRegisteredCell = isSameRegisteredCell;
        this.mLinkStats = linkStats;
        this.mWifiLinkCount = wifiLinkCount;
        this.mMloMode = mloMode;
        this.mTxTransmittedBytes = txTransmittedBytes;
        this.mRxTransmittedBytes = rxTransmittedBytes;
        this.mLabelBadEventCount = labelBadEventCount;
        this.mWifiFrameworkState = wifiFrameworkState;
        this.mIsNetworkCapabilitiesDownstreamSufficient = isNetworkCapabilitiesDownstreamSufficient;
        this.mIsNetworkCapabilitiesUpstreamSufficient = isNetworkCapabilitiesUpstreamSufficient;
        this.mIsThroughputPredictorDownstreamSufficient = isThroughputPredictorDownstreamSufficient;
        this.mIsThroughputPredictorUpstreamSufficient = isThroughputPredictorUpstreamSufficient;
        this.mIsBluetoothConnected = isBluetoothConnected;
        this.mUwbAdapterState = uwbAdapterState;
        this.mIsLowLatencyActivated = isLowLatencyActivated;
        this.mMaxSupportedTxLinkSpeed = maxSupportedTxLinkSpeed;
        this.mMaxSupportedRxLinkSpeed = maxSupportedRxLinkSpeed;
        this.mVoipMode = voipMode;
        this.mThreadDeviceRole = threadDeviceRole;
        this.mStatusDataStall = statusDataStall;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStampMillis);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeedMbps);
        dest.writeLong(this.mTotalTxSuccess);
        dest.writeLong(this.mTotalTxRetries);
        dest.writeLong(this.mTotalTxBad);
        dest.writeLong(this.mTotalRxSuccess);
        dest.writeLong(this.mTotalRadioOnTimeMillis);
        dest.writeLong(this.mTotalRadioTxTimeMillis);
        dest.writeLong(this.mTotalRadioRxTimeMillis);
        dest.writeLong(this.mTotalScanTimeMillis);
        dest.writeLong(this.mTotalNanScanTimeMillis);
        dest.writeLong(this.mTotalBackgroundScanTimeMillis);
        dest.writeLong(this.mTotalRoamScanTimeMillis);
        dest.writeLong(this.mTotalPnoScanTimeMillis);
        dest.writeLong(this.mTotalHotspot2ScanTimeMillis);
        dest.writeLong(this.mTotalCcaBusyFreqTimeMillis);
        dest.writeLong(this.mTotalRadioOnFreqTimeMillis);
        dest.writeLong(this.mTotalBeaconRx);
        dest.writeInt(this.mProbeStatusSinceLastUpdate);
        dest.writeInt(this.mProbeElapsedTimeSinceLastUpdateMillis);
        dest.writeInt(this.mProbeMcsRateSinceLastUpdate);
        dest.writeInt(this.mRxLinkSpeedMbps);
        dest.writeInt(this.mTimeSliceDutyCycleInPercent);
        dest.writeTypedArray(this.mContentionTimeStats, flags);
        dest.writeTypedArray(this.mRateStats, flags);
        dest.writeTypedArray(this.mRadioStats, flags);
        dest.writeInt(this.mChannelUtilizationRatio);
        dest.writeBoolean(this.mIsThroughputSufficient);
        dest.writeBoolean(this.mIsWifiScoringEnabled);
        dest.writeBoolean(this.mIsCellularDataAvailable);
        dest.writeInt(this.mCellularDataNetworkType);
        dest.writeInt(this.mCellularSignalStrengthDbm);
        dest.writeInt(this.mCellularSignalStrengthDb);
        dest.writeBoolean(this.mIsSameRegisteredCell);
        dest.writeSparseArray(this.mLinkStats);
        dest.writeInt(this.mWifiLinkCount);
        dest.writeInt(this.mMloMode);
        dest.writeLong(this.mTxTransmittedBytes);
        dest.writeLong(this.mRxTransmittedBytes);
        dest.writeInt(this.mLabelBadEventCount);
        dest.writeInt(this.mWifiFrameworkState);
        dest.writeInt(this.mIsNetworkCapabilitiesDownstreamSufficient);
        dest.writeInt(this.mIsNetworkCapabilitiesUpstreamSufficient);
        dest.writeInt(this.mIsThroughputPredictorDownstreamSufficient);
        dest.writeInt(this.mIsThroughputPredictorUpstreamSufficient);
        dest.writeBoolean(this.mIsBluetoothConnected);
        dest.writeInt(this.mUwbAdapterState);
        dest.writeBoolean(this.mIsLowLatencyActivated);
        dest.writeInt(this.mMaxSupportedTxLinkSpeed);
        dest.writeInt(this.mMaxSupportedRxLinkSpeed);
        dest.writeInt(this.mVoipMode);
        dest.writeInt(this.mThreadDeviceRole);
        dest.writeInt(this.mStatusDataStall);
    }

    @Nullable
    public int[] getLinkIds() {
        if (this.mLinkStats == null) {
            return null;
        }
        int[] result = new int[this.mLinkStats.size()];
        for (int i = 0; i < this.mLinkStats.size(); ++i) {
            result[i] = this.mLinkStats.keyAt(i);
        }
        return result;
    }

    public int getLinkState(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mState;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTimeStampMillis() {
        return this.mTimeStampMillis;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getRssi(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mRssi;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getRadioId(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mRadioId;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getFrequencyMhz(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mFrequencyMhz;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getRssiMgmt(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mRssiMgmt;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getChannelWidth(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mChannelWidth;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getCenterFreqFirstSegment(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mCenterFreqFirstSegment;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getCenterFreqSecondSegment(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mCenterFreqSecondSegment;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getLinkSpeedMbps() {
        return this.mLinkSpeedMbps;
    }

    public int getTxLinkSpeedMbps(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTxLinkSpeedMbps;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalTxSuccess() {
        return this.mTotalTxSuccess;
    }

    public long getTotalTxSuccess(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalTxSuccess;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalTxRetries() {
        return this.mTotalTxRetries;
    }

    public long getTotalTxRetries(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalTxRetries;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalTxBad() {
        return this.mTotalTxBad;
    }

    public long getTotalTxBad(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalTxBad;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalRxSuccess() {
        return this.mTotalRxSuccess;
    }

    public long getTotalRxSuccess(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalRxSuccess;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalRadioOnTimeMillis() {
        return this.mTotalRadioOnTimeMillis;
    }

    public long getTotalRadioTxTimeMillis() {
        return this.mTotalRadioTxTimeMillis;
    }

    public long getTotalRadioRxTimeMillis() {
        return this.mTotalRadioRxTimeMillis;
    }

    public long getTotalScanTimeMillis() {
        return this.mTotalScanTimeMillis;
    }

    public long getTotalNanScanTimeMillis() {
        return this.mTotalNanScanTimeMillis;
    }

    public long getTotalBackgroundScanTimeMillis() {
        return this.mTotalBackgroundScanTimeMillis;
    }

    public long getTotalRoamScanTimeMillis() {
        return this.mTotalRoamScanTimeMillis;
    }

    public long getTotalPnoScanTimeMillis() {
        return this.mTotalPnoScanTimeMillis;
    }

    public long getTotalHotspot2ScanTimeMillis() {
        return this.mTotalHotspot2ScanTimeMillis;
    }

    public long getTotalCcaBusyFreqTimeMillis() {
        return this.mTotalCcaBusyFreqTimeMillis;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getTotalCcaBusyFreqTimeMillis(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalCcaBusyFreqTimeMillis;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalRadioOnFreqTimeMillis() {
        return this.mTotalRadioOnFreqTimeMillis;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getTotalRadioOnFreqTimeMillis(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalRadioOnFreqTimeMillis;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public long getTotalBeaconRx() {
        return this.mTotalBeaconRx;
    }

    public long getTotalBeaconRx(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mTotalBeaconRx;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getProbeStatusSinceLastUpdate() {
        return this.mProbeStatusSinceLastUpdate;
    }

    public int getProbeElapsedTimeSinceLastUpdateMillis() {
        return this.mProbeElapsedTimeSinceLastUpdateMillis;
    }

    public int getProbeMcsRateSinceLastUpdate() {
        return this.mProbeMcsRateSinceLastUpdate;
    }

    public int getRxLinkSpeedMbps() {
        return this.mRxLinkSpeedMbps;
    }

    public int getRxLinkSpeedMbps(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            return this.mLinkStats.get((int)linkId).mRxLinkSpeedMbps;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    public int getTimeSliceDutyCycleInPercent() {
        if (this.mTimeSliceDutyCycleInPercent == -1) {
            throw new NoSuchElementException("Unknown value");
        }
        return this.mTimeSliceDutyCycleInPercent;
    }

    public int getTimeSliceDutyCycleInPercent(int linkId) {
        if (!this.mLinkStats.contains(linkId)) {
            throw new NoSuchElementException("linkId is invalid - " + linkId);
        }
        if (this.mLinkStats.get((int)linkId).mTimeSliceDutyCycleInPercent == -1) {
            throw new NoSuchElementException("Unknown value");
        }
        return this.mLinkStats.get((int)linkId).mTimeSliceDutyCycleInPercent;
    }

    @NonNull
    public ContentionTimeStats getContentionTimeStats(int ac) {
        if (this.mContentionTimeStats != null && this.mContentionTimeStats.length == 4) {
            return this.mContentionTimeStats[ac];
        }
        Log.e(TAG, "The ContentionTimeStats is not filled out correctly: " + Arrays.toString(this.mContentionTimeStats));
        return new ContentionTimeStats();
    }

    @NonNull
    public ContentionTimeStats getContentionTimeStats(int linkId, int ac) {
        if (!this.mLinkStats.contains(linkId)) {
            throw new NoSuchElementException("linkId is invalid - " + linkId);
        }
        ContentionTimeStats[] linkContentionTimeStats = this.mLinkStats.get((int)linkId).mContentionTimeStats;
        if (linkContentionTimeStats != null && linkContentionTimeStats.length == 4) {
            return linkContentionTimeStats[ac];
        }
        Log.e(TAG, "The ContentionTimeStats is not filled out correctly: " + Arrays.toString(this.mContentionTimeStats));
        return new ContentionTimeStats();
    }

    @NonNull
    public PacketStats getPacketStats(int linkId, int ac) {
        if (!this.mLinkStats.contains(linkId)) {
            throw new NoSuchElementException("linkId is invalid - " + linkId);
        }
        PacketStats[] linkPacketStats = this.mLinkStats.get((int)linkId).mPacketStats;
        if (linkPacketStats != null && linkPacketStats.length == 4) {
            return linkPacketStats[ac];
        }
        Log.e(TAG, "The PacketStats is not filled out correctly");
        return new PacketStats();
    }

    @NonNull
    public List<RateStats> getRateStats() {
        if (this.mRateStats != null) {
            return Arrays.asList(this.mRateStats);
        }
        return Collections.emptyList();
    }

    @NonNull
    public List<RateStats> getRateStats(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            RateStats[] rateStats = this.mLinkStats.get((int)linkId).mRateStats;
            if (rateStats != null) {
                return Arrays.asList(rateStats);
            }
            return Collections.emptyList();
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    @NonNull
    public List<RateStats> getRateStats(int linkId, int peerIndex) {
        if (this.mLinkStats.contains(linkId)) {
            RateStats[] rateStats;
            if (this.getPeerInfo(linkId).size() > 0 && peerIndex < this.getPeerInfo(linkId).size() && (rateStats = this.mLinkStats.get((int)linkId).mPeerInfo[peerIndex].mRateStats) != null) {
                return Arrays.asList(rateStats);
            }
            return Collections.emptyList();
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    @NonNull
    public List<PeerInfo> getPeerInfo(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            PeerInfo[] peerInfo = this.mLinkStats.get((int)linkId).mPeerInfo;
            if (peerInfo != null) {
                return Arrays.asList(peerInfo);
            }
            return Collections.emptyList();
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    @NonNull
    public ScanResultWithSameFreq[] getScanResultsWithSameFreq(int linkId) {
        if (this.mLinkStats.contains(linkId)) {
            ScanResultWithSameFreq[] scanResultsWithSameFreq = this.mLinkStats.get((int)linkId).mScanResultsWithSameFreq;
            return scanResultsWithSameFreq;
        }
        throw new NoSuchElementException("linkId is invalid - " + linkId);
    }

    @NonNull
    public List<RadioStats> getWifiLinkLayerRadioStats() {
        if (this.mRadioStats != null) {
            return Arrays.asList(this.mRadioStats);
        }
        return Collections.emptyList();
    }

    public int getChannelUtilizationRatio() {
        return this.mChannelUtilizationRatio;
    }

    public boolean isThroughputSufficient() {
        return this.mIsThroughputSufficient;
    }

    public boolean isWifiScoringEnabled() {
        return this.mIsWifiScoringEnabled;
    }

    public boolean isCellularDataAvailable() {
        return this.mIsCellularDataAvailable;
    }

    public int getCellularDataNetworkType() {
        return this.mCellularDataNetworkType;
    }

    public int getCellularSignalStrengthDbm() {
        return this.mCellularSignalStrengthDbm;
    }

    public int getCellularSignalStrengthDb() {
        return this.mCellularSignalStrengthDb;
    }

    public boolean isSameRegisteredCell() {
        return this.mIsSameRegisteredCell;
    }

    public int getWifiLinkCount() {
        return this.mWifiLinkCount;
    }

    public int getMloMode() {
        return this.mMloMode;
    }

    public long getTxTransmittedBytes() {
        return this.mTxTransmittedBytes;
    }

    public long getRxTransmittedBytes() {
        return this.mRxTransmittedBytes;
    }

    public long getLabelBadEventCount() {
        return this.mLabelBadEventCount;
    }

    public int getWifiFrameworkState() {
        return this.mWifiFrameworkState;
    }

    public int isNetworkCapabilitiesDownstreamSufficient() {
        return this.mIsNetworkCapabilitiesDownstreamSufficient;
    }

    public int isNetworkCapabilitiesUpstreamSufficient() {
        return this.mIsNetworkCapabilitiesUpstreamSufficient;
    }

    public int isThroughputPredictorDownstreamSufficient() {
        return this.mIsThroughputPredictorDownstreamSufficient;
    }

    public int isThroughputPredictorUpstreamSufficient() {
        return this.mIsThroughputPredictorUpstreamSufficient;
    }

    public boolean isBluetoothConnected() {
        return this.mIsBluetoothConnected;
    }

    public int getUwbAdapterState() {
        return this.mUwbAdapterState;
    }

    public boolean getLowLatencyModeState() {
        return this.mIsLowLatencyActivated;
    }

    public int getMaxSupportedTxLinkSpeed() {
        return this.mMaxSupportedTxLinkSpeed;
    }

    public int getMaxSupportedRxLinkSpeed() {
        return this.mMaxSupportedRxLinkSpeed;
    }

    public int getVoipMode() {
        return this.mVoipMode;
    }

    public int getThreadDeviceRole() {
        return this.mThreadDeviceRole;
    }

    public int getStatusDataStall() {
        return this.mStatusDataStall;
    }

    public static class ContentionTimeStats
    implements Parcelable {
        private long mContentionTimeMinMicros;
        private long mContentionTimeMaxMicros;
        private long mContentionTimeAvgMicros;
        private long mContentionNumSamples;
        @NonNull
        public static final Parcelable.Creator<ContentionTimeStats> CREATOR = new Parcelable.Creator<ContentionTimeStats>(){

            @Override
            public ContentionTimeStats createFromParcel(Parcel in) {
                ContentionTimeStats stats = new ContentionTimeStats();
                stats.mContentionTimeMinMicros = in.readLong();
                stats.mContentionTimeMaxMicros = in.readLong();
                stats.mContentionTimeAvgMicros = in.readLong();
                stats.mContentionNumSamples = in.readLong();
                return stats;
            }

            public ContentionTimeStats[] newArray(int size) {
                return new ContentionTimeStats[size];
            }
        };

        public ContentionTimeStats() {
        }

        public ContentionTimeStats(long timeMin, long timeMax, long timeAvg, long numSamples) {
            this.mContentionTimeMinMicros = timeMin;
            this.mContentionTimeMaxMicros = timeMax;
            this.mContentionTimeAvgMicros = timeAvg;
            this.mContentionNumSamples = numSamples;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeLong(this.mContentionTimeMinMicros);
            dest.writeLong(this.mContentionTimeMaxMicros);
            dest.writeLong(this.mContentionTimeAvgMicros);
            dest.writeLong(this.mContentionNumSamples);
        }

        public long getContentionTimeMinMicros() {
            return this.mContentionTimeMinMicros;
        }

        public long getContentionTimeMaxMicros() {
            return this.mContentionTimeMaxMicros;
        }

        public long getContentionTimeAvgMicros() {
            return this.mContentionTimeAvgMicros;
        }

        public long getContentionNumSamples() {
            return this.mContentionNumSamples;
        }
    }

    public static class RateStats
    implements Parcelable {
        private int mPreamble;
        private int mNss;
        private int mBw;
        private int mRateMcsIdx;
        private int mBitRateInKbps;
        private int mTxMpdu;
        private int mRxMpdu;
        private int mMpduLost;
        private int mRetries;
        @NonNull
        public static final Parcelable.Creator<RateStats> CREATOR = new Parcelable.Creator<RateStats>(){

            @Override
            public RateStats createFromParcel(Parcel in) {
                RateStats stats = new RateStats();
                stats.mPreamble = in.readInt();
                stats.mNss = in.readInt();
                stats.mBw = in.readInt();
                stats.mRateMcsIdx = in.readInt();
                stats.mBitRateInKbps = in.readInt();
                stats.mTxMpdu = in.readInt();
                stats.mRxMpdu = in.readInt();
                stats.mMpduLost = in.readInt();
                stats.mRetries = in.readInt();
                return stats;
            }

            public RateStats[] newArray(int size) {
                return new RateStats[size];
            }
        };

        public RateStats() {
        }

        public RateStats(int preamble, int nss, int bw, int rateMcsIdx, int bitRateInKbps, int txMpdu, int rxMpdu, int mpduLost, int retries) {
            this.mPreamble = preamble;
            this.mNss = nss;
            this.mBw = bw;
            this.mRateMcsIdx = rateMcsIdx;
            this.mBitRateInKbps = bitRateInKbps;
            this.mTxMpdu = txMpdu;
            this.mRxMpdu = rxMpdu;
            this.mMpduLost = mpduLost;
            this.mRetries = retries;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mPreamble);
            dest.writeInt(this.mNss);
            dest.writeInt(this.mBw);
            dest.writeInt(this.mRateMcsIdx);
            dest.writeInt(this.mBitRateInKbps);
            dest.writeInt(this.mTxMpdu);
            dest.writeInt(this.mRxMpdu);
            dest.writeInt(this.mMpduLost);
            dest.writeInt(this.mRetries);
        }

        public int getPreamble() {
            return this.mPreamble;
        }

        public int getNumberOfSpatialStreams() {
            return this.mNss;
        }

        public int getBandwidthInMhz() {
            return this.mBw;
        }

        public int getRateMcsIdx() {
            return this.mRateMcsIdx;
        }

        public int getBitRateInKbps() {
            return this.mBitRateInKbps;
        }

        public int getTxMpdu() {
            return this.mTxMpdu;
        }

        public int getRxMpdu() {
            return this.mRxMpdu;
        }

        public int getMpduLost() {
            return this.mMpduLost;
        }

        public int getRetries() {
            return this.mRetries;
        }
    }

    public static class RadioStats
    implements Parcelable {
        public static final int INVALID_RADIO_ID = -1;
        private int mRadioId;
        private long mTotalRadioOnTimeMillis;
        private long mTotalRadioTxTimeMillis;
        private long mTotalRadioRxTimeMillis;
        private long mTotalScanTimeMillis;
        private long mTotalNanScanTimeMillis;
        private long mTotalBackgroundScanTimeMillis;
        private long mTotalRoamScanTimeMillis;
        private long mTotalPnoScanTimeMillis;
        private long mTotalHotspot2ScanTimeMillis;
        private int[] mTxTimeMsPerLevel;
        @NonNull
        public static final Parcelable.Creator<RadioStats> CREATOR = new Parcelable.Creator<RadioStats>(){

            @Override
            public RadioStats createFromParcel(Parcel in) {
                RadioStats stats = new RadioStats();
                stats.mRadioId = in.readInt();
                stats.mTotalRadioOnTimeMillis = in.readLong();
                stats.mTotalRadioTxTimeMillis = in.readLong();
                stats.mTotalRadioRxTimeMillis = in.readLong();
                stats.mTotalScanTimeMillis = in.readLong();
                stats.mTotalNanScanTimeMillis = in.readLong();
                stats.mTotalBackgroundScanTimeMillis = in.readLong();
                stats.mTotalRoamScanTimeMillis = in.readLong();
                stats.mTotalPnoScanTimeMillis = in.readLong();
                stats.mTotalHotspot2ScanTimeMillis = in.readLong();
                stats.mTxTimeMsPerLevel = in.createIntArray();
                return stats;
            }

            public RadioStats[] newArray(int size) {
                return new RadioStats[size];
            }
        };

        public RadioStats() {
        }

        public RadioStats(int radioId, long onTime, long txTime, long rxTime, long onTimeScan, long onTimeNanScan, long onTimeBackgroundScan, long onTimeRoamScan, long onTimePnoScan, long onTimeHs20Scan) {
            this.mRadioId = radioId;
            this.mTotalRadioOnTimeMillis = onTime;
            this.mTotalRadioTxTimeMillis = txTime;
            this.mTotalRadioRxTimeMillis = rxTime;
            this.mTotalScanTimeMillis = onTimeScan;
            this.mTotalNanScanTimeMillis = onTimeNanScan;
            this.mTotalBackgroundScanTimeMillis = onTimeBackgroundScan;
            this.mTotalRoamScanTimeMillis = onTimeRoamScan;
            this.mTotalPnoScanTimeMillis = onTimePnoScan;
            this.mTotalHotspot2ScanTimeMillis = onTimeHs20Scan;
        }

        public RadioStats(int radioId, long onTime, long txTime, long rxTime, long onTimeScan, long onTimeNanScan, long onTimeBackgroundScan, long onTimeRoamScan, long onTimePnoScan, long onTimeHs20Scan, int[] txTimeMsPerLevel) {
            this.mRadioId = radioId;
            this.mTotalRadioOnTimeMillis = onTime;
            this.mTotalRadioTxTimeMillis = txTime;
            this.mTotalRadioRxTimeMillis = rxTime;
            this.mTotalScanTimeMillis = onTimeScan;
            this.mTotalNanScanTimeMillis = onTimeNanScan;
            this.mTotalBackgroundScanTimeMillis = onTimeBackgroundScan;
            this.mTotalRoamScanTimeMillis = onTimeRoamScan;
            this.mTotalPnoScanTimeMillis = onTimePnoScan;
            this.mTotalHotspot2ScanTimeMillis = onTimeHs20Scan;
            this.mTxTimeMsPerLevel = txTimeMsPerLevel;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mRadioId);
            dest.writeLong(this.mTotalRadioOnTimeMillis);
            dest.writeLong(this.mTotalRadioTxTimeMillis);
            dest.writeLong(this.mTotalRadioRxTimeMillis);
            dest.writeLong(this.mTotalScanTimeMillis);
            dest.writeLong(this.mTotalNanScanTimeMillis);
            dest.writeLong(this.mTotalBackgroundScanTimeMillis);
            dest.writeLong(this.mTotalRoamScanTimeMillis);
            dest.writeLong(this.mTotalPnoScanTimeMillis);
            dest.writeLong(this.mTotalHotspot2ScanTimeMillis);
            dest.writeIntArray(this.mTxTimeMsPerLevel);
        }

        public long getRadioId() {
            return this.mRadioId;
        }

        public long getTotalRadioOnTimeMillis() {
            return this.mTotalRadioOnTimeMillis;
        }

        public long getTotalRadioTxTimeMillis() {
            return this.mTotalRadioTxTimeMillis;
        }

        public long getTotalRadioRxTimeMillis() {
            return this.mTotalRadioRxTimeMillis;
        }

        public long getTotalScanTimeMillis() {
            return this.mTotalScanTimeMillis;
        }

        public long getTotalNanScanTimeMillis() {
            return this.mTotalNanScanTimeMillis;
        }

        public long getTotalBackgroundScanTimeMillis() {
            return this.mTotalBackgroundScanTimeMillis;
        }

        public long getTotalRoamScanTimeMillis() {
            return this.mTotalRoamScanTimeMillis;
        }

        public long getTotalPnoScanTimeMillis() {
            return this.mTotalPnoScanTimeMillis;
        }

        public long getTotalHotspot2ScanTimeMillis() {
            return this.mTotalHotspot2ScanTimeMillis;
        }

        public int[] getTxTimeMsPerLevel() {
            return this.mTxTimeMsPerLevel;
        }
    }

    public static class LinkStats
    implements Parcelable {
        private final int mLinkId;
        private final int mState;
        private final int mRadioId;
        private final int mRssi;
        private final int mFrequencyMhz;
        private final int mRssiMgmt;
        private int mChannelWidth;
        private final int mCenterFreqFirstSegment;
        private final int mCenterFreqSecondSegment;
        private final int mTxLinkSpeedMbps;
        private final int mRxLinkSpeedMbps;
        private final long mTotalTxSuccess;
        private final long mTotalTxRetries;
        private final long mTotalTxBad;
        private final long mTotalRxSuccess;
        private final long mTotalBeaconRx;
        private final int mTimeSliceDutyCycleInPercent;
        private final long mTotalCcaBusyFreqTimeMillis;
        private final long mTotalRadioOnFreqTimeMillis;
        private final ContentionTimeStats[] mContentionTimeStats;
        private final RateStats[] mRateStats;
        private final PacketStats[] mPacketStats;
        private final PeerInfo[] mPeerInfo;
        private final ScanResultWithSameFreq[] mScanResultsWithSameFreq;
        @NonNull
        public static final Parcelable.Creator<LinkStats> CREATOR = new Parcelable.Creator<LinkStats>(){

            @Override
            public LinkStats createFromParcel(Parcel in) {
                return new LinkStats(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readInt(), in.readLong(), in.readLong(), in.createTypedArray(ContentionTimeStats.CREATOR), in.createTypedArray(RateStats.CREATOR), in.createTypedArray(PacketStats.CREATOR), in.createTypedArray(PeerInfo.CREATOR), in.createTypedArray(ScanResultWithSameFreq.CREATOR));
            }

            public LinkStats[] newArray(int size) {
                return new LinkStats[size];
            }
        };

        public LinkStats() {
            this.mLinkId = -1;
            this.mState = 0;
            this.mRssi = -127;
            this.mRadioId = -1;
            this.mFrequencyMhz = 0;
            this.mRssiMgmt = 0;
            this.mChannelWidth = 0;
            this.mCenterFreqFirstSegment = 0;
            this.mCenterFreqSecondSegment = 0;
            this.mTxLinkSpeedMbps = -1;
            this.mRxLinkSpeedMbps = -1;
            this.mTotalTxSuccess = 0L;
            this.mTotalTxRetries = 0L;
            this.mTotalTxBad = 0L;
            this.mTotalRxSuccess = 0L;
            this.mTotalBeaconRx = 0L;
            this.mTimeSliceDutyCycleInPercent = 0;
            this.mTotalCcaBusyFreqTimeMillis = 0L;
            this.mTotalRadioOnFreqTimeMillis = 0L;
            this.mContentionTimeStats = null;
            this.mRateStats = null;
            this.mPacketStats = null;
            this.mPeerInfo = null;
            this.mScanResultsWithSameFreq = null;
        }

        public LinkStats(int linkId, int state, int radioId, int rssi, int frequencyMhz, int rssiMgmt, int channelWidth, int centerFreqFirstSegment, int centerFreqSecondSegment, int txLinkSpeedMpbs, int rxLinkSpeedMpbs, long totalTxSuccess, long totalTxRetries, long totalTxBad, long totalRxSuccess, long totalBeaconRx, int timeSliceDutyCycleInPercent, long totalCcaBusyFreqTimeMillis, long totalRadioOnFreqTimeMillis, ContentionTimeStats[] contentionTimeStats, RateStats[] rateStats, PacketStats[] packetStats, PeerInfo[] peerInfo, ScanResultWithSameFreq[] scanResultsWithSameFreq) {
            this.mLinkId = linkId;
            this.mState = state;
            this.mRadioId = radioId;
            this.mRssi = rssi;
            this.mFrequencyMhz = frequencyMhz;
            this.mRssiMgmt = rssiMgmt;
            this.mChannelWidth = channelWidth;
            this.mCenterFreqFirstSegment = centerFreqFirstSegment;
            this.mCenterFreqSecondSegment = centerFreqSecondSegment;
            this.mTxLinkSpeedMbps = txLinkSpeedMpbs;
            this.mRxLinkSpeedMbps = rxLinkSpeedMpbs;
            this.mTotalTxSuccess = totalTxSuccess;
            this.mTotalTxRetries = totalTxRetries;
            this.mTotalTxBad = totalTxBad;
            this.mTotalRxSuccess = totalRxSuccess;
            this.mTotalBeaconRx = totalBeaconRx;
            this.mTimeSliceDutyCycleInPercent = timeSliceDutyCycleInPercent;
            this.mTotalCcaBusyFreqTimeMillis = totalCcaBusyFreqTimeMillis;
            this.mTotalRadioOnFreqTimeMillis = totalRadioOnFreqTimeMillis;
            this.mContentionTimeStats = contentionTimeStats;
            this.mRateStats = rateStats;
            this.mPacketStats = packetStats;
            this.mPeerInfo = peerInfo;
            this.mScanResultsWithSameFreq = scanResultsWithSameFreq;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mLinkId);
            dest.writeInt(this.mState);
            dest.writeInt(this.mRadioId);
            dest.writeInt(this.mRssi);
            dest.writeInt(this.mFrequencyMhz);
            dest.writeInt(this.mRssiMgmt);
            dest.writeInt(this.mChannelWidth);
            dest.writeInt(this.mCenterFreqFirstSegment);
            dest.writeInt(this.mCenterFreqSecondSegment);
            dest.writeInt(this.mTxLinkSpeedMbps);
            dest.writeInt(this.mRxLinkSpeedMbps);
            dest.writeLong(this.mTotalTxSuccess);
            dest.writeLong(this.mTotalTxRetries);
            dest.writeLong(this.mTotalTxBad);
            dest.writeLong(this.mTotalRxSuccess);
            dest.writeLong(this.mTotalBeaconRx);
            dest.writeInt(this.mTimeSliceDutyCycleInPercent);
            dest.writeLong(this.mTotalCcaBusyFreqTimeMillis);
            dest.writeLong(this.mTotalRadioOnFreqTimeMillis);
            dest.writeTypedArray(this.mContentionTimeStats, flags);
            dest.writeTypedArray(this.mRateStats, flags);
            dest.writeTypedArray(this.mPacketStats, flags);
            dest.writeTypedArray(this.mPeerInfo, flags);
            dest.writeTypedArray(this.mScanResultsWithSameFreq, flags);
        }
    }

    public static class PacketStats
    implements Parcelable {
        private long mTxSuccess;
        private long mTxRetries;
        private long mTxBad;
        private long mRxSuccess;
        @NonNull
        public static final Parcelable.Creator<PacketStats> CREATOR = new Parcelable.Creator<PacketStats>(){

            @Override
            public PacketStats createFromParcel(Parcel in) {
                PacketStats stats = new PacketStats();
                stats.mTxSuccess = in.readLong();
                stats.mTxRetries = in.readLong();
                stats.mTxBad = in.readLong();
                stats.mRxSuccess = in.readLong();
                return stats;
            }

            public PacketStats[] newArray(int size) {
                return new PacketStats[size];
            }
        };

        public PacketStats() {
        }

        public PacketStats(long txSuccess, long txRetries, long txBad, long rxSuccess) {
            this.mTxSuccess = txSuccess;
            this.mTxRetries = txRetries;
            this.mTxBad = txBad;
            this.mRxSuccess = rxSuccess;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeLong(this.mTxSuccess);
            dest.writeLong(this.mTxRetries);
            dest.writeLong(this.mTxBad);
            dest.writeLong(this.mRxSuccess);
        }

        public long getTxSuccess() {
            return this.mTxSuccess;
        }

        public long getTxRetries() {
            return this.mTxRetries;
        }

        public long getTxBad() {
            return this.mTxBad;
        }

        public long getRxSuccess() {
            return this.mRxSuccess;
        }
    }

    public static class PeerInfo
    implements Parcelable {
        private int mStaCount;
        private int mChanUtil;
        private RateStats[] mRateStats;
        @NonNull
        public static final Parcelable.Creator<PeerInfo> CREATOR = new Parcelable.Creator<PeerInfo>(){

            @Override
            public PeerInfo createFromParcel(Parcel in) {
                PeerInfo stats = new PeerInfo();
                stats.mStaCount = in.readInt();
                stats.mChanUtil = in.readInt();
                stats.mRateStats = in.createTypedArray(RateStats.CREATOR);
                return stats;
            }

            public PeerInfo[] newArray(int size) {
                return new PeerInfo[size];
            }
        };

        public PeerInfo() {
        }

        public PeerInfo(int staCount, int chanUtil, RateStats[] rateStats) {
            this.mStaCount = staCount;
            this.mChanUtil = chanUtil;
            this.mRateStats = rateStats;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mStaCount);
            dest.writeInt(this.mChanUtil);
            dest.writeTypedArray(this.mRateStats, flags);
        }

        public int getStaCount() {
            return this.mStaCount;
        }

        public int getChanUtil() {
            return this.mChanUtil;
        }

        public List<RateStats> getRateStats() {
            if (this.mRateStats != null) {
                return Arrays.asList(this.mRateStats);
            }
            return Collections.emptyList();
        }
    }

    public static class ScanResultWithSameFreq
    implements Parcelable {
        private long mScanResultTimestampMicros;
        private int mRssi;
        private int mFrequencyMhz;
        @NonNull
        public static final Parcelable.Creator<ScanResultWithSameFreq> CREATOR = new Parcelable.Creator<ScanResultWithSameFreq>(){

            @Override
            public ScanResultWithSameFreq createFromParcel(Parcel in) {
                ScanResultWithSameFreq scanResultWithSameFreq = new ScanResultWithSameFreq();
                scanResultWithSameFreq.mScanResultTimestampMicros = in.readLong();
                scanResultWithSameFreq.mRssi = in.readInt();
                scanResultWithSameFreq.mFrequencyMhz = in.readInt();
                return scanResultWithSameFreq;
            }

            public ScanResultWithSameFreq[] newArray(int size) {
                return new ScanResultWithSameFreq[size];
            }
        };

        public ScanResultWithSameFreq() {
        }

        public ScanResultWithSameFreq(long scanResultTimestampMicros, int rssi, int frequencyMhz) {
            this.mScanResultTimestampMicros = scanResultTimestampMicros;
            this.mRssi = rssi;
            this.mFrequencyMhz = frequencyMhz;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeLong(this.mScanResultTimestampMicros);
            dest.writeInt(this.mRssi);
            dest.writeInt(this.mFrequencyMhz);
        }

        public long getScanResultTimestampMicros() {
            return this.mScanResultTimestampMicros;
        }

        public int getRssi() {
            return this.mRssi;
        }

        public int getFrequency() {
            return this.mFrequencyMhz;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiChannelBandwidth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiSpatialStreams {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiPreambleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WmeAccessCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProbeStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LinkState {
    }
}

