/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.Keep;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class SoftApCapability
implements Parcelable {
    private static final String TAG = "SoftApCapability";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long SOFTAP_FEATURE_ACS_OFFLOAD = 1L;
    public static final long SOFTAP_FEATURE_CLIENT_FORCE_DISCONNECT = 2L;
    public static final long SOFTAP_FEATURE_WPA3_SAE = 4L;
    public static final long SOFTAP_FEATURE_MAC_ADDRESS_CUSTOMIZATION = 8L;
    public static final long SOFTAP_FEATURE_IEEE80211_AX = 16L;
    public static final long SOFTAP_FEATURE_BAND_24G_SUPPORTED = 32L;
    public static final long SOFTAP_FEATURE_BAND_5G_SUPPORTED = 64L;
    public static final long SOFTAP_FEATURE_BAND_6G_SUPPORTED = 128L;
    public static final long SOFTAP_FEATURE_BAND_60G_SUPPORTED = 256L;
    public static final long SOFTAP_FEATURE_IEEE80211_BE = 512L;
    public static final long SOFTAP_FEATURE_WPA3_OWE_TRANSITION = 1024L;
    public static final long SOFTAP_FEATURE_WPA3_OWE = 2048L;
    @FlaggedApi(value="com.android.wifi.flags.mlo_sap")
    public static final long SOFTAP_FEATURE_MLO = 4096L;
    private long mSupportedFeatures = 0L;
    private int mMaximumSupportedClientNumber;
    private int[] mSupportedChannelListIn24g = EMPTY_INT_ARRAY;
    private int[] mSupportedChannelListIn5g = EMPTY_INT_ARRAY;
    private int[] mSupportedChannelListIn6g = EMPTY_INT_ARRAY;
    private int[] mSupportedChannelListIn60g = EMPTY_INT_ARRAY;
    private String mCountryCodeFromDriver;
    @NonNull
    public static final Parcelable.Creator<SoftApCapability> CREATOR = new Parcelable.Creator<SoftApCapability>(){

        @Override
        public SoftApCapability createFromParcel(Parcel in) {
            SoftApCapability capability = new SoftApCapability(in.readLong());
            capability.mMaximumSupportedClientNumber = in.readInt();
            capability.setSupportedChannelList(1, in.createIntArray());
            capability.setSupportedChannelList(2, in.createIntArray());
            capability.setSupportedChannelList(4, in.createIntArray());
            capability.setSupportedChannelList(8, in.createIntArray());
            capability.setCountryCode(in.readString());
            return capability;
        }

        public SoftApCapability[] newArray(int size) {
            return new SoftApCapability[size];
        }
    };

    public void setCountryCode(String countryCode) {
        this.mCountryCodeFromDriver = countryCode;
    }

    public String getCountryCode() {
        return this.mCountryCodeFromDriver;
    }

    public int getMaxSupportedClients() {
        return this.mMaximumSupportedClientNumber;
    }

    public void setMaxSupportedClients(int maxClient) {
        this.mMaximumSupportedClientNumber = maxClient;
    }

    public boolean areFeaturesSupported(long features) {
        return (this.mSupportedFeatures & features) == features;
    }

    public void setSupportedFeatures(boolean value, long features) {
        this.mSupportedFeatures = value ? (this.mSupportedFeatures |= features) : (this.mSupportedFeatures &= features ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Keep
    public boolean setSupportedChannelList(int band, @Nullable int[] supportedChannelList) {
        if (supportedChannelList == null) {
            return false;
        }
        switch (band) {
            case 1: {
                this.mSupportedChannelListIn24g = supportedChannelList;
                break;
            }
            case 2: {
                this.mSupportedChannelListIn5g = supportedChannelList;
                break;
            }
            case 4: {
                this.mSupportedChannelListIn6g = supportedChannelList;
                break;
            }
            case 8: {
                this.mSupportedChannelListIn60g = supportedChannelList;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid band: " + band);
            }
        }
        return true;
    }

    @NonNull
    public int[] getSupportedChannelList(int band) {
        switch (band) {
            case 1: {
                return this.mSupportedChannelListIn24g;
            }
            case 2: {
                return this.mSupportedChannelListIn5g;
            }
            case 4: {
                return this.mSupportedChannelListIn6g;
            }
            case 8: {
                return this.mSupportedChannelListIn60g;
            }
        }
        throw new IllegalArgumentException("Invalid band: " + band);
    }

    public SoftApCapability(@Nullable SoftApCapability source) {
        if (source != null) {
            this.mSupportedFeatures = source.mSupportedFeatures;
            this.mMaximumSupportedClientNumber = source.mMaximumSupportedClientNumber;
            this.mSupportedChannelListIn24g = source.mSupportedChannelListIn24g;
            this.mSupportedChannelListIn5g = source.mSupportedChannelListIn5g;
            this.mSupportedChannelListIn6g = source.mSupportedChannelListIn6g;
            this.mSupportedChannelListIn60g = source.mSupportedChannelListIn60g;
            this.mCountryCodeFromDriver = source.mCountryCodeFromDriver;
        }
    }

    public SoftApCapability(long features) {
        this.mSupportedFeatures = features;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mSupportedFeatures);
        dest.writeInt(this.mMaximumSupportedClientNumber);
        dest.writeIntArray(this.mSupportedChannelListIn24g);
        dest.writeIntArray(this.mSupportedChannelListIn5g);
        dest.writeIntArray(this.mSupportedChannelListIn6g);
        dest.writeIntArray(this.mSupportedChannelListIn60g);
        dest.writeString(this.mCountryCodeFromDriver);
    }

    @NonNull
    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("SupportedFeatures=").append(this.mSupportedFeatures);
        sbuf.append(" MaximumSupportedClientNumber=").append(this.mMaximumSupportedClientNumber);
        sbuf.append(" SupportedChannelListIn24g").append(Arrays.toString(this.mSupportedChannelListIn24g));
        sbuf.append(" SupportedChannelListIn5g").append(Arrays.toString(this.mSupportedChannelListIn5g));
        sbuf.append(" SupportedChannelListIn6g").append(Arrays.toString(this.mSupportedChannelListIn6g));
        sbuf.append(" SupportedChannelListIn60g").append(Arrays.toString(this.mSupportedChannelListIn60g));
        sbuf.append(" mCountryCodeFromDriver").append(this.mCountryCodeFromDriver);
        return sbuf.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApCapability)) {
            return false;
        }
        SoftApCapability capability = (SoftApCapability)o;
        return this.mSupportedFeatures == capability.mSupportedFeatures && this.mMaximumSupportedClientNumber == capability.mMaximumSupportedClientNumber && Arrays.equals(this.mSupportedChannelListIn24g, capability.mSupportedChannelListIn24g) && Arrays.equals(this.mSupportedChannelListIn5g, capability.mSupportedChannelListIn5g) && Arrays.equals(this.mSupportedChannelListIn6g, capability.mSupportedChannelListIn6g) && Arrays.equals(this.mSupportedChannelListIn60g, capability.mSupportedChannelListIn60g) && Objects.equals(this.mCountryCodeFromDriver, capability.mCountryCodeFromDriver);
    }

    public int hashCode() {
        return Objects.hash(this.mSupportedFeatures, this.mMaximumSupportedClientNumber, Arrays.hashCode(this.mSupportedChannelListIn24g), Arrays.hashCode(this.mSupportedChannelListIn5g), Arrays.hashCode(this.mSupportedChannelListIn6g), Arrays.hashCode(this.mSupportedChannelListIn60g), this.mCountryCodeFromDriver);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HotspotFeatures {
    }
}

