/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.wifi.AnqpInformationElement;
import android.net.wifi.MloLink;
import android.net.wifi.SecurityParams;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiSsid;
import android.net.wifi.util.ScanResultUtil;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.Keep;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ScanResult
implements Parcelable {
    private static final String TAG = "ScanResult";
    @Deprecated
    public String SSID;
    @Deprecated
    @UnsupportedAppUsage(publicAlternatives="{@link #getWifiSsid()}")
    public WifiSsid wifiSsid;
    public String BSSID;
    private MacAddress mApMldMacAddress;
    private int mApMloLinkId = -1;
    private List<MloLink> mAffiliatedMloLinks = Collections.emptyList();
    @UnsupportedAppUsage
    public long hessid;
    @UnsupportedAppUsage
    public int anqpDomainId;
    public String capabilities;
    public String ifaceName;
    @SystemApi
    public static final int PROTOCOL_NONE = 0;
    @SystemApi
    public static final int PROTOCOL_WPA = 1;
    @SystemApi
    public static final int PROTOCOL_RSN = 2;
    @SystemApi
    public static final int PROTOCOL_OSEN = 3;
    @SystemApi
    public static final int PROTOCOL_WAPI = 4;
    @SystemApi
    public static final int KEY_MGMT_NONE = 0;
    @SystemApi
    public static final int KEY_MGMT_PSK = 1;
    @SystemApi
    public static final int KEY_MGMT_EAP = 2;
    @SystemApi
    public static final int KEY_MGMT_FT_PSK = 3;
    @SystemApi
    public static final int KEY_MGMT_FT_EAP = 4;
    @SystemApi
    public static final int KEY_MGMT_PSK_SHA256 = 5;
    @SystemApi
    public static final int KEY_MGMT_EAP_SHA256 = 6;
    @SystemApi
    public static final int KEY_MGMT_OSEN = 7;
    @SystemApi
    public static final int KEY_MGMT_SAE = 8;
    @SystemApi
    public static final int KEY_MGMT_OWE = 9;
    @SystemApi
    public static final int KEY_MGMT_EAP_SUITE_B_192 = 10;
    @SystemApi
    public static final int KEY_MGMT_FT_SAE = 11;
    @SystemApi
    public static final int KEY_MGMT_OWE_TRANSITION = 12;
    @SystemApi
    public static final int KEY_MGMT_WAPI_PSK = 13;
    @SystemApi
    public static final int KEY_MGMT_WAPI_CERT = 14;
    public static final int KEY_MGMT_FILS_SHA256 = 15;
    public static final int KEY_MGMT_FILS_SHA384 = 16;
    public static final int KEY_MGMT_DPP = 17;
    public static final int KEY_MGMT_SAE_EXT_KEY = 18;
    public static final int KEY_MGMT_FT_SAE_EXT_KEY = 19;
    public static final int KEY_MGMT_PASN = 20;
    public static final int KEY_MGMT_EAP_FT_SHA384 = 21;
    public static final int KEY_MGMT_FT_PSK_SHA384 = 22;
    public static final int KEY_MGMT_UNKNOWN = 23;
    @SystemApi
    public static final int CIPHER_NONE = 0;
    @SystemApi
    public static final int CIPHER_NO_GROUP_ADDRESSED = 1;
    @SystemApi
    public static final int CIPHER_TKIP = 2;
    @SystemApi
    public static final int CIPHER_CCMP = 3;
    @SystemApi
    public static final int CIPHER_GCMP_256 = 4;
    @SystemApi
    public static final int CIPHER_SMS4 = 5;
    @SystemApi
    public static final int CIPHER_GCMP_128 = 6;
    @SystemApi
    public static final int CIPHER_BIP_GMAC_128 = 7;
    @SystemApi
    public static final int CIPHER_BIP_GMAC_256 = 8;
    @SystemApi
    public static final int CIPHER_BIP_CMAC_256 = 9;
    public static final int CIPHER_CCMP_256 = 10;
    public int level;
    public int frequency;
    public static final int CHANNEL_WIDTH_20MHZ = 0;
    public static final int CHANNEL_WIDTH_40MHZ = 1;
    public static final int CHANNEL_WIDTH_80MHZ = 2;
    public static final int CHANNEL_WIDTH_160MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4;
    public static final int CHANNEL_WIDTH_320MHZ = 5;
    public static final int PREAMBLE_LEGACY = 0;
    public static final int PREAMBLE_HT = 1;
    public static final int PREAMBLE_VHT = 2;
    public static final int PREAMBLE_HE = 3;
    public static final int PREAMBLE_EHT = 4;
    public static final int WIFI_STANDARD_UNKNOWN = 0;
    public static final int WIFI_STANDARD_LEGACY = 1;
    public static final int WIFI_STANDARD_11N = 4;
    public static final int WIFI_STANDARD_11AC = 5;
    public static final int WIFI_STANDARD_11AX = 6;
    public static final int WIFI_STANDARD_11AD = 7;
    public static final int WIFI_STANDARD_11BE = 8;
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_6_GHZ = 8;
    public static final int WIFI_BAND_60_GHZ = 16;
    public static final int WIFI_BAND_5_GHZ_LOW = 0x20000000;
    public static final int WIFI_BAND_5_GHZ_HIGH = 0x40000000;
    private int mWifiStandard = 0;
    public int channelWidth;
    public int centerFreq0;
    public int centerFreq1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean is80211McRTTResponder;
    public long timestamp;
    @UnsupportedAppUsage
    public long seen;
    public RadioChainInfo[] radioChainInfos;
    @SystemApi
    public boolean untrusted;
    @UnsupportedAppUsage
    public int numUsage;
    @UnsupportedAppUsage
    public int distanceCm;
    @UnsupportedAppUsage
    public int distanceSdCm;
    public static final long FLAG_PASSPOINT_NETWORK = 1L;
    public static final long FLAG_80211mc_RESPONDER = 2L;
    public static final long FLAG_80211az_NTB_RESPONDER = 4L;
    public static final long FLAG_TWT_RESPONDER = 8L;
    public static final long FLAG_SECURE_HE_LTF_SUPPORTED = 16L;
    public static final long FLAG_RANGING_FRAME_PROTECTION_REQUIRED = 32L;
    @UnsupportedAppUsage
    public long flags;
    @Deprecated
    public CharSequence venueName;
    @Deprecated
    public CharSequence operatorFriendlyName;
    public static final int UNSPECIFIED = -1;
    public static final int BAND_24_GHZ_FIRST_CH_NUM = 1;
    public static final int BAND_24_GHZ_LAST_CH_NUM = 14;
    public static final int BAND_24_GHZ_START_FREQ_MHZ = 2412;
    public static final int BAND_24_GHZ_END_FREQ_MHZ = 2484;
    public static final int BAND_5_GHZ_FIRST_CH_NUM = 32;
    public static final int BAND_5_GHZ_LAST_CH_NUM = 177;
    public static final int BAND_5_GHZ_START_FREQ_MHZ = 5160;
    public static final int BAND_5_GHZ_END_FREQ_MHZ = 5885;
    public static final int BAND_6_GHZ_FIRST_CH_NUM = 1;
    public static final int BAND_6_GHZ_LAST_CH_NUM = 233;
    public static final int BAND_6_GHZ_START_FREQ_MHZ = 5955;
    public static final int BAND_6_GHZ_END_FREQ_MHZ = 7115;
    public static final int BAND_6_GHZ_PSC_START_MHZ = 5975;
    public static final int BAND_6_GHZ_PSC_STEP_SIZE_MHZ = 80;
    public static final int BAND_6_GHZ_OP_CLASS_136_CH_2_FREQ_MHZ = 5935;
    public static final int BAND_60_GHZ_FIRST_CH_NUM = 1;
    public static final int BAND_60_GHZ_LAST_CH_NUM = 6;
    public static final int BAND_60_GHZ_START_FREQ_MHZ = 58320;
    public static final int BAND_60_GHZ_END_FREQ_MHZ = 70200;
    public static final int BAND_5_GHZ_LOW_HIGHEST_FREQ_MHZ = 5320;
    public static final int BAND_5_GHZ_HIGH_LOWEST_FREQ_MHZ = 5500;
    @UnsupportedAppUsage
    public List<String> anqpLines;
    @UnsupportedAppUsage
    public InformationElement[] informationElements;
    public AnqpInformationElement[] anqpElements;
    @NonNull
    public static final Parcelable.Creator<ScanResult> CREATOR = new Parcelable.Creator<ScanResult>(){

        @Override
        public ScanResult createFromParcel(Parcel in) {
            int i;
            WifiSsid wifiSsid = null;
            if (in.readInt() == 1) {
                wifiSsid = WifiSsid.CREATOR.createFromParcel(in);
            }
            ScanResult sr = new ScanResult(wifiSsid, in.readString(), in.readString(), in.readLong(), in.readInt(), in.readString(), in.readInt(), in.readInt(), in.readLong(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), false);
            sr.mWifiStandard = in.readInt();
            sr.seen = in.readLong();
            sr.untrusted = in.readInt() != 0;
            sr.numUsage = in.readInt();
            sr.venueName = in.readString();
            sr.operatorFriendlyName = in.readString();
            sr.flags = in.readLong();
            sr.informationElements = in.createTypedArray(InformationElement.CREATOR);
            int n = in.readInt();
            if (n != 0) {
                sr.anqpLines = new ArrayList<String>();
                for (i = 0; i < n; ++i) {
                    sr.anqpLines.add(in.readString());
                }
            }
            if ((n = in.readInt()) != 0) {
                sr.anqpElements = new AnqpInformationElement[n];
                for (i = 0; i < n; ++i) {
                    int vendorId = in.readInt();
                    int elementId = in.readInt();
                    int len = in.readInt();
                    byte[] payload = new byte[len];
                    in.readByteArray(payload);
                    sr.anqpElements[i] = new AnqpInformationElement(vendorId, elementId, payload);
                }
            }
            if ((n = in.readInt()) != 0) {
                sr.radioChainInfos = new RadioChainInfo[n];
                for (i = 0; i < n; ++i) {
                    sr.radioChainInfos[i] = new RadioChainInfo();
                    sr.radioChainInfos[i].id = in.readInt();
                    sr.radioChainInfos[i].level = in.readInt();
                }
            }
            sr.ifaceName = in.readString();
            sr.mApMldMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            sr.mApMloLinkId = in.readInt();
            sr.mAffiliatedMloLinks = in.createTypedArrayList(MloLink.CREATOR);
            return sr;
        }

        public ScanResult[] newArray(int size) {
            return new ScanResult[size];
        }
    };

    @SystemApi
    public void setWifiSsid(@NonNull WifiSsid ssid) {
        this.wifiSsid = ssid;
        CharSequence utf8Text = this.wifiSsid.getUtf8Text();
        this.SSID = utf8Text != null ? utf8Text.toString() : "<unknown ssid>";
    }

    @Nullable
    public WifiSsid getWifiSsid() {
        return this.wifiSsid;
    }

    @Nullable
    public MacAddress getApMldMacAddress() {
        return this.mApMldMacAddress;
    }

    public void setApMldMacAddress(@Nullable MacAddress address) {
        this.mApMldMacAddress = address;
    }

    public int getApMloLinkId() {
        return this.mApMloLinkId;
    }

    public void setApMloLinkId(int linkId) {
        this.mApMloLinkId = linkId;
    }

    @NonNull
    public List<MloLink> getAffiliatedMloLinks() {
        return new ArrayList<MloLink>(this.mAffiliatedMloLinks);
    }

    public void setAffiliatedMloLinks(@NonNull List<MloLink> links) {
        this.mAffiliatedMloLinks = new ArrayList<MloLink>(links);
    }

    public int getWifiStandard() {
        return this.mWifiStandard;
    }

    public void setWifiStandard(int standard) {
        this.mWifiStandard = standard;
    }

    @Nullable
    public static String wifiStandardToString(int standard) {
        switch (standard) {
            case 1: {
                return "legacy";
            }
            case 4: {
                return "11n";
            }
            case 5: {
                return "11ac";
            }
            case 6: {
                return "11ax";
            }
            case 7: {
                return "11ad";
            }
            case 8: {
                return "11be";
            }
            case 0: {
                return "unknown";
            }
        }
        return null;
    }

    public void setFlag(long flag) {
        this.flags |= flag;
    }

    public void clearFlag(long flag) {
        this.flags &= flag ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean is80211mcResponder() {
        return (this.flags & 2L) != 0L;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean is80211azNtbResponder() {
        return (this.flags & 4L) != 0L;
    }

    public boolean isPasspointNetwork() {
        return (this.flags & 1L) != 0L;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isTwtResponder() {
        return (this.flags & 8L) != 0L;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isSecureHeLtfSupported() {
        return (this.flags & 0x10L) != 0L;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isRangingFrameProtectionRequired() {
        return (this.flags & 0x20L) != 0L;
    }

    @Keep
    public static boolean is24GHz(int freqMhz) {
        return freqMhz >= 2412 && freqMhz <= 2484;
    }

    @Keep
    public static boolean is5GHz(int freqMhz) {
        return freqMhz >= 5160 && freqMhz <= 5885;
    }

    @Keep
    public static boolean is6GHz(int freqMhz) {
        if (freqMhz == 5935) {
            return true;
        }
        return freqMhz >= 5955 && freqMhz <= 7115;
    }

    public static boolean is6GHzPsc(int freqMhz) {
        if (!ScanResult.is6GHz(freqMhz)) {
            return false;
        }
        return (freqMhz - 5975) % 80 == 0;
    }

    public static boolean is60GHz(int freqMhz) {
        return freqMhz >= 58320 && freqMhz <= 70200;
    }

    public static boolean isValidCombinedBandForDual5GHz(int freqMhz1, int freqMhz2) {
        int band1 = ScanResult.toBand(freqMhz1);
        int band2 = ScanResult.toBand(freqMhz2);
        if (band1 == 1 || band2 == 1) {
            return band1 != band2;
        }
        return freqMhz1 <= 5320 && freqMhz2 >= 5500 || freqMhz2 <= 5320 && freqMhz1 >= 5500;
    }

    public static int convertChannelToFrequencyMhzIfSupported(int channel, int band) {
        if (band == 1) {
            if (channel == 14) {
                return 2484;
            }
            if (channel >= 1 && channel <= 14) {
                return (channel - 1) * 5 + 2412;
            }
            return -1;
        }
        if (band == 2) {
            if (channel >= 32 && channel <= 177) {
                return (channel - 32) * 5 + 5160;
            }
            return -1;
        }
        if (band == 8) {
            if (channel >= 1 && channel <= 233) {
                if (channel == 2) {
                    return 5935;
                }
                return (channel - 1) * 5 + 5955;
            }
            return -1;
        }
        if (band == 16) {
            if (channel >= 1 && channel <= 6) {
                return (channel - 1) * 2160 + 58320;
            }
            return -1;
        }
        return -1;
    }

    public static int getBandFromOpClass(int opClass, int channel) {
        if (opClass >= 81 && opClass <= 84) {
            if (channel >= 1 && channel <= 14) {
                return 1;
            }
        } else if (opClass >= 115 && opClass <= 130) {
            if (channel >= 32 && channel <= 177) {
                return 2;
            }
        } else if (opClass >= 131 && opClass <= 137 && channel >= 1 && channel <= 233) {
            return 8;
        }
        return 0;
    }

    public static int convertFrequencyMhzToChannelIfSupported(int freqMhz) {
        if (freqMhz == 2484) {
            return 14;
        }
        if (ScanResult.is24GHz(freqMhz)) {
            return (freqMhz - 2412) / 5 + 1;
        }
        if (ScanResult.is5GHz(freqMhz)) {
            return (freqMhz - 5160) / 5 + 32;
        }
        if (ScanResult.is6GHz(freqMhz)) {
            if (freqMhz == 5935) {
                return 2;
            }
            return (freqMhz - 5955) / 5 + 1;
        }
        if (ScanResult.is60GHz(freqMhz)) {
            return (freqMhz - 58320) / 2160 + 1;
        }
        return -1;
    }

    public static int toBand(int frequency) {
        if (ScanResult.is24GHz(frequency)) {
            return 1;
        }
        if (ScanResult.is5GHz(frequency)) {
            return 2;
        }
        if (ScanResult.is6GHz(frequency)) {
            return 8;
        }
        if (ScanResult.is60GHz(frequency)) {
            return 16;
        }
        return -1;
    }

    @SystemApi
    public int getBand() {
        return ScanResult.toBand(this.frequency);
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.frequency);
    }

    public boolean is5GHz() {
        return ScanResult.is5GHz(this.frequency);
    }

    public boolean is6GHz() {
        return ScanResult.is6GHz(this.frequency);
    }

    public boolean is6GhzPsc() {
        return ScanResult.is6GHzPsc(this.frequency);
    }

    public boolean is60GHz() {
        return ScanResult.is60GHz(this.frequency);
    }

    @NonNull
    public List<InformationElement> getInformationElements() {
        return Collections.unmodifiableList(Arrays.asList(this.informationElements));
    }

    @NonNull
    public int[] getSecurityTypes() {
        List<SecurityParams> params = ScanResultUtil.generateSecurityParamsListFromScanResult(this);
        int[] securityTypes = new int[params.size()];
        for (int i = 0; i < securityTypes.length; ++i) {
            securityTypes[i] = WifiInfo.convertWifiConfigurationSecurityType(params.get(i).getSecurityType());
        }
        return securityTypes;
    }

    private boolean isHiddenSsid(@NonNull WifiSsid wifiSsid) {
        for (byte b : wifiSsid.getBytes()) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private ScanResult(Builder builder) {
        this.wifiSsid = builder.mWifiSsid;
        if (this.wifiSsid != null && this.isHiddenSsid(this.wifiSsid)) {
            this.SSID = "";
        } else {
            CharSequence utf8Ssid = this.wifiSsid != null ? this.wifiSsid.getUtf8Text() : null;
            this.SSID = utf8Ssid != null ? utf8Ssid.toString() : "<unknown ssid>";
        }
        this.BSSID = builder.mBssid;
        this.hessid = builder.mHessid;
        this.anqpDomainId = builder.mAnqpDomainId;
        if (builder.mOsuProviders != null) {
            this.anqpElements = new AnqpInformationElement[1];
            this.anqpElements[0] = new AnqpInformationElement(5271450, 8, builder.mOsuProviders);
        }
        this.capabilities = builder.mCaps;
        this.level = builder.mRssi;
        this.frequency = builder.mFrequency;
        this.timestamp = builder.mTsf;
        this.distanceCm = builder.mDistanceCm;
        this.distanceSdCm = builder.mDistanceSdCm;
        this.channelWidth = builder.mChannelWidth;
        this.centerFreq0 = builder.mCenterFreq0;
        this.centerFreq1 = builder.mCenterFreq1;
        this.flags = 0L;
        this.flags |= builder.mIs80211McRTTResponder ? 2L : 0L;
        this.flags |= builder.mIs80211azNtbRTTResponder ? 4L : 0L;
        this.flags |= builder.mIsTwtResponder ? 8L : 0L;
        this.radioChainInfos = null;
        this.mApMldMacAddress = null;
        this.flags |= builder.mIsSecureHeLtfSupported ? 16L : 0L;
        this.flags |= builder.mIsRangingFrameProtectionRequired ? 32L : 0L;
    }

    public ScanResult(WifiSsid wifiSsid, String BSSID, long hessid, int anqpDomainId, byte[] osuProviders, String caps, int level, int frequency, long tsf) {
        this.wifiSsid = wifiSsid;
        if (wifiSsid != null && this.isHiddenSsid(wifiSsid)) {
            this.SSID = "";
        } else {
            CharSequence utf8Ssid = wifiSsid != null ? wifiSsid.getUtf8Text() : null;
            this.SSID = utf8Ssid != null ? utf8Ssid.toString() : "<unknown ssid>";
        }
        this.BSSID = BSSID;
        this.hessid = hessid;
        this.anqpDomainId = anqpDomainId;
        if (osuProviders != null) {
            this.anqpElements = new AnqpInformationElement[1];
            this.anqpElements[0] = new AnqpInformationElement(5271450, 8, osuProviders);
        }
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = -1;
        this.distanceSdCm = -1;
        this.channelWidth = -1;
        this.centerFreq0 = -1;
        this.centerFreq1 = -1;
        this.flags = 0L;
        this.radioChainInfos = null;
        this.mApMldMacAddress = null;
    }

    public ScanResult(WifiSsid wifiSsid, String BSSID, String caps, int level, int frequency, long tsf, int distCm, int distSdCm) {
        this.wifiSsid = wifiSsid;
        if (wifiSsid != null && this.isHiddenSsid(wifiSsid)) {
            this.SSID = "";
        } else {
            CharSequence utf8Ssid = wifiSsid != null ? wifiSsid.getUtf8Text() : null;
            this.SSID = utf8Ssid != null ? utf8Ssid.toString() : "<unknown ssid>";
        }
        this.BSSID = BSSID;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = distCm;
        this.distanceSdCm = distSdCm;
        this.channelWidth = -1;
        this.centerFreq0 = -1;
        this.centerFreq1 = -1;
        this.flags = 0L;
        this.radioChainInfos = null;
        this.mApMldMacAddress = null;
    }

    public ScanResult(String Ssid, String BSSID, long hessid, int anqpDomainId, String caps, int level, int frequency, long tsf, int distCm, int distSdCm, int channelWidth, int centerFreq0, int centerFreq1, boolean is80211McRTTResponder) {
        this.SSID = Ssid;
        this.BSSID = BSSID;
        this.hessid = hessid;
        this.anqpDomainId = anqpDomainId;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = distCm;
        this.distanceSdCm = distSdCm;
        this.channelWidth = channelWidth;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.flags = is80211McRTTResponder ? 2L : 0L;
        this.radioChainInfos = null;
        this.mApMldMacAddress = null;
    }

    public ScanResult(WifiSsid wifiSsid, String Ssid, String BSSID, long hessid, int anqpDomainId, String caps, int level, int frequency, long tsf, int distCm, int distSdCm, int channelWidth, int centerFreq0, int centerFreq1, boolean is80211McRTTResponder) {
        this(Ssid, BSSID, hessid, anqpDomainId, caps, level, frequency, tsf, distCm, distSdCm, channelWidth, centerFreq0, centerFreq1, is80211McRTTResponder);
        this.wifiSsid = wifiSsid;
    }

    public ScanResult(@NonNull ScanResult source) {
        if (source != null) {
            this.wifiSsid = source.wifiSsid;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.hessid = source.hessid;
            this.anqpDomainId = source.anqpDomainId;
            this.informationElements = source.informationElements;
            this.anqpElements = source.anqpElements;
            this.capabilities = source.capabilities;
            this.level = source.level;
            this.frequency = source.frequency;
            this.channelWidth = source.channelWidth;
            this.centerFreq0 = source.centerFreq0;
            this.centerFreq1 = source.centerFreq1;
            this.timestamp = source.timestamp;
            this.distanceCm = source.distanceCm;
            this.distanceSdCm = source.distanceSdCm;
            this.seen = source.seen;
            this.untrusted = source.untrusted;
            this.numUsage = source.numUsage;
            this.venueName = source.venueName;
            this.operatorFriendlyName = source.operatorFriendlyName;
            this.flags = source.flags;
            this.radioChainInfos = source.radioChainInfos;
            this.mWifiStandard = source.mWifiStandard;
            this.ifaceName = source.ifaceName;
            this.mApMldMacAddress = source.mApMldMacAddress;
            this.mApMloLinkId = source.mApMloLinkId;
            this.mAffiliatedMloLinks = source.mAffiliatedMloLinks != null ? new ArrayList<MloLink>(source.mAffiliatedMloLinks) : Collections.emptyList();
        }
    }

    public ScanResult() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.wifiSsid == null ? "<unknown ssid>" : this.wifiSsid).append(", BSSID: ").append(this.BSSID == null ? none : this.BSSID).append(", capabilities: ").append(this.capabilities == null ? none : this.capabilities).append(", level: ").append(this.level).append(", frequency: ").append(this.frequency).append(", timestamp: ").append(this.timestamp);
        sb.append(", distance: ").append(this.distanceCm != -1 ? Integer.valueOf(this.distanceCm) : "?").append("(cm)");
        sb.append(", distanceSd: ").append(this.distanceSdCm != -1 ? Integer.valueOf(this.distanceSdCm) : "?").append("(cm)");
        sb.append(", passpoint: ");
        sb.append((this.flags & 1L) != 0L ? "yes" : "no");
        sb.append(", ChannelBandwidth: ").append(this.channelWidth);
        sb.append(", centerFreq0: ").append(this.centerFreq0);
        sb.append(", centerFreq1: ").append(this.centerFreq1);
        sb.append(", standard: ").append(ScanResult.wifiStandardToString(this.mWifiStandard));
        sb.append(", 80211mcResponder: ");
        sb.append((this.flags & 2L) != 0L ? "is supported" : "is not supported");
        sb.append(", 80211azNtbResponder: ");
        sb.append((this.flags & 4L) != 0L ? "is supported" : "is not supported");
        sb.append(", TWT Responder: ");
        sb.append((this.flags & 8L) != 0L ? "yes" : "no");
        sb.append(", Radio Chain Infos: ").append(Arrays.toString(this.radioChainInfos));
        sb.append(", interface name: ").append(this.ifaceName);
        if (this.mApMldMacAddress != null) {
            sb.append(", MLO Info: ").append(" AP MLD MAC Address: ").append(((Object)this.mApMldMacAddress).toString()).append(", AP MLO Link-Id: ").append(this.mApMloLinkId == -1 ? "Unspecified" : Integer.valueOf(this.mApMloLinkId)).append(", AP MLO Affiliated Links: ").append(this.mAffiliatedMloLinks);
        }
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        long start = dest.dataSize();
        if (this.wifiSsid != null) {
            dest.writeInt(1);
            this.wifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeLong(this.hessid);
        dest.writeInt(this.anqpDomainId);
        dest.writeString(this.capabilities);
        dest.writeInt(this.level);
        dest.writeInt(this.frequency);
        dest.writeLong(this.timestamp);
        dest.writeInt(this.distanceCm);
        dest.writeInt(this.distanceSdCm);
        dest.writeInt(this.channelWidth);
        dest.writeInt(this.centerFreq0);
        dest.writeInt(this.centerFreq1);
        dest.writeInt(this.mWifiStandard);
        dest.writeLong(this.seen);
        dest.writeInt(this.untrusted ? 1 : 0);
        dest.writeInt(this.numUsage);
        dest.writeString(this.venueName != null ? this.venueName.toString() : "");
        dest.writeString(this.operatorFriendlyName != null ? this.operatorFriendlyName.toString() : "");
        dest.writeLong(this.flags);
        dest.writeTypedArray(this.informationElements, flags);
        if (this.anqpLines != null) {
            dest.writeInt(this.anqpLines.size());
            for (int i = 0; i < this.anqpLines.size(); ++i) {
                dest.writeString(this.anqpLines.get(i));
            }
        } else {
            dest.writeInt(0);
        }
        int anqpElementsPayloadSize = 0;
        if (this.anqpElements != null) {
            dest.writeInt(this.anqpElements.length);
            for (AnqpInformationElement element : this.anqpElements) {
                dest.writeInt(element.getVendorId());
                dest.writeInt(element.getElementId());
                dest.writeInt(element.getPayload().length);
                dest.writeByteArray(element.getPayload());
                anqpElementsPayloadSize += element.getPayload().length;
            }
        } else {
            dest.writeInt(0);
        }
        if (this.radioChainInfos != null) {
            dest.writeInt(this.radioChainInfos.length);
            for (int i = 0; i < this.radioChainInfos.length; ++i) {
                dest.writeInt(this.radioChainInfos[i].id);
                dest.writeInt(this.radioChainInfos[i].level);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.ifaceName != null ? this.ifaceName.toString() : "");
        dest.writeParcelable(this.mApMldMacAddress, flags);
        dest.writeInt(this.mApMloLinkId);
        dest.writeTypedList(this.mAffiliatedMloLinks);
        if ((long)dest.dataSize() - start > 10000L) {
            Log.e(TAG, " Abnormal ScanResult: " + this + ". The size is " + ((long)dest.dataSize() - start) + ". The informationElements size is " + this.informationElements.length + ". The anqpPayload size is " + anqpElementsPayloadSize);
        }
    }

    public static class InformationElement
    implements Parcelable {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_SSID = 0;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_SUPPORTED_RATES = 1;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_TIM = 5;
        public static final int EID_COUNTRY = 7;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_BSS_LOAD = 11;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_ERP = 42;
        public static final int EID_HT_CAPABILITIES = 45;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_RSN = 48;
        public static final int EID_RSN_EXTENSION = 244;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_EXTENDED_SUPPORTED_RATES = 50;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_HT_OPERATION = 61;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_INTERWORKING = 107;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_ROAMING_CONSORTIUM = 111;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_EXTENDED_CAPS = 127;
        public static final int EID_VHT_CAPABILITIES = 191;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_VHT_OPERATION = 192;
        public static final int EID_RNR = 201;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int EID_VSA = 221;
        public static final int EID_EXTENSION_PRESENT = 255;
        public static final int EID_EXT_HE_CAPABILITIES = 35;
        public static final int EID_EXT_HE_OPERATION = 36;
        public static final int EID_EXT_EHT_OPERATION = 106;
        public static final int EID_EXT_MULTI_LINK = 107;
        public static final int EID_FRAGMENT_SUB_ELEMENT_MULTI_LINK = 254;
        public static final int EID_EXT_EHT_CAPABILITIES = 108;
        @UnsupportedAppUsage
        public int id;
        public int idExt;
        @UnsupportedAppUsage
        public byte[] bytes;
        @NonNull
        public static final Parcelable.Creator<InformationElement> CREATOR = new Parcelable.Creator<InformationElement>(){

            @Override
            public InformationElement createFromParcel(Parcel in) {
                InformationElement informationElement = new InformationElement();
                informationElement.id = in.readInt();
                informationElement.idExt = in.readInt();
                informationElement.bytes = in.createByteArray();
                return informationElement;
            }

            public InformationElement[] newArray(int size) {
                return new InformationElement[size];
            }
        };

        public InformationElement() {
        }

        public InformationElement(int id2, int idExt, @NonNull byte[] bytes) {
            this.id = id2;
            this.idExt = idExt;
            this.bytes = (byte[])bytes.clone();
        }

        public InformationElement(@NonNull InformationElement rhs) {
            this.id = rhs.id;
            this.idExt = rhs.idExt;
            this.bytes = (byte[])rhs.bytes.clone();
        }

        public int getId() {
            return this.id;
        }

        public int getIdExt() {
            return this.idExt;
        }

        @NonNull
        public ByteBuffer getBytes() {
            return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.idExt);
            dest.writeByteArray(this.bytes);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!SdkLevel.isAtLeastS()) {
                return false;
            }
            if (!(that instanceof InformationElement)) {
                return false;
            }
            InformationElement thatIE = (InformationElement)that;
            return this.id == thatIE.id && this.idExt == thatIE.idExt && Arrays.equals(this.bytes, thatIE.bytes);
        }

        public int hashCode() {
            if (!SdkLevel.isAtLeastS()) {
                return System.identityHashCode(this);
            }
            return Objects.hash(this.id, this.idExt, Arrays.hashCode(this.bytes));
        }
    }

    public static class Builder {
        private WifiSsid mWifiSsid;
        private String mBssid;
        private long mHessid = 0L;
        private int mAnqpDomainId = 0;
        private byte[] mOsuProviders = null;
        private String mCaps = null;
        private int mRssi = -1;
        private int mFrequency = -1;
        private long mTsf = 0L;
        private int mDistanceCm = -1;
        private int mDistanceSdCm = -1;
        private int mChannelWidth = 0;
        private int mCenterFreq0 = -1;
        private int mCenterFreq1 = -1;
        private boolean mIs80211McRTTResponder = false;
        private boolean mIs80211azNtbRTTResponder = false;
        private boolean mIsTwtResponder = false;
        private boolean mIsSecureHeLtfSupported = false;
        private boolean mIsRangingFrameProtectionRequired = false;

        @NonNull
        public Builder setHessid(long hessid) {
            this.mHessid = hessid;
            return this;
        }

        @NonNull
        public Builder setOsuProviders(@Nullable byte[] osuProviders) {
            this.mOsuProviders = osuProviders;
            return this;
        }

        @NonNull
        public Builder setAnqpDomainId(int anqpDomainId) {
            this.mAnqpDomainId = anqpDomainId;
            return this;
        }

        @NonNull
        public Builder setCaps(@Nullable String caps) {
            this.mCaps = caps;
            return this;
        }

        @NonNull
        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        @NonNull
        public Builder setFrequency(int frequency) {
            this.mFrequency = frequency;
            return this;
        }

        @NonNull
        public Builder setTsf(long tsf) {
            this.mTsf = tsf;
            return this;
        }

        @NonNull
        public Builder setDistanceCm(int distanceCm) {
            this.mDistanceCm = distanceCm;
            return this;
        }

        @NonNull
        public Builder setDistanceSdCm(int distanceSdCm) {
            this.mDistanceSdCm = distanceSdCm;
            return this;
        }

        @NonNull
        public Builder setChannelWidth(int channelWidth) {
            this.mChannelWidth = channelWidth;
            return this;
        }

        @NonNull
        public Builder setCenterFreq0(int centerFreq0) {
            this.mCenterFreq0 = centerFreq0;
            return this;
        }

        @NonNull
        public Builder setCenterFreq1(int centerFreq1) {
            this.mCenterFreq1 = centerFreq1;
            return this;
        }

        @NonNull
        public Builder setIs80211McRTTResponder(boolean is80211McRTTResponder) {
            this.mIs80211McRTTResponder = is80211McRTTResponder;
            return this;
        }

        @NonNull
        public Builder setIs80211azNtbRTTResponder(boolean is80211azNtbRTTResponder) {
            this.mIs80211azNtbRTTResponder = is80211azNtbRTTResponder;
            return this;
        }

        @NonNull
        public Builder setIsTwtResponder(boolean isTwtResponder) {
            this.mIsTwtResponder = isTwtResponder;
            return this;
        }

        public Builder(WifiSsid wifiSsid, String bssid) {
            this.mWifiSsid = wifiSsid;
            this.mBssid = bssid;
        }

        public Builder() {
        }

        public Builder setWifiSsid(WifiSsid wifiSsid) {
            this.mWifiSsid = wifiSsid;
            return this;
        }

        public Builder setBssid(String bssid) {
            this.mBssid = bssid;
            return this;
        }

        public void clear() {
            this.mWifiSsid = null;
            this.mBssid = null;
            this.mHessid = 0L;
            this.mAnqpDomainId = 0;
            this.mOsuProviders = null;
            this.mCaps = null;
            this.mRssi = -1;
            this.mFrequency = -1;
            this.mTsf = 0L;
            this.mDistanceCm = -1;
            this.mDistanceSdCm = -1;
            this.mChannelWidth = 0;
            this.mCenterFreq0 = -1;
            this.mCenterFreq1 = -1;
            this.mIs80211McRTTResponder = false;
            this.mIs80211azNtbRTTResponder = false;
            this.mIsTwtResponder = false;
        }

        public ScanResult build() {
            return new ScanResult(this);
        }

        public Builder setSecureHeLtfSupported(boolean supported) {
            this.mIsSecureHeLtfSupported = supported;
            return this;
        }

        public Builder setRangingFrameProtectionRequired(boolean required) {
            this.mIsRangingFrameProtectionRequired = required;
            return this;
        }
    }

    public static class RadioChainInfo {
        public int id;
        public int level;

        public String toString() {
            return "RadioChainInfo: id=" + this.id + ", level=" + this.level;
        }

        public boolean equals(Object otherObj) {
            if (this == otherObj) {
                return true;
            }
            if (!(otherObj instanceof RadioChainInfo)) {
                return false;
            }
            RadioChainInfo other = (RadioChainInfo)otherObj;
            return this.id == other.id && this.level == other.level;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.level);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiBand {
    }
}

