/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.util.PersistableBundleUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class OuiKeyedData
implements Parcelable {
    private static final String TAG = "OuiKeyedData";
    private final int mOui;
    private final PersistableBundle mData;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public static final Parcelable.Creator<OuiKeyedData> CREATOR = new Parcelable.Creator<OuiKeyedData>(){

        @Override
        public OuiKeyedData createFromParcel(Parcel in) {
            return new OuiKeyedData(in);
        }

        public OuiKeyedData[] newArray(int size) {
            return new OuiKeyedData[size];
        }
    };

    private OuiKeyedData(int oui, @NonNull PersistableBundle data) {
        this.mOui = oui;
        this.mData = data != null ? data.deepCopy() : null;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getOui() {
        return this.mOui;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public PersistableBundle getData() {
        return this.mData;
    }

    private static boolean validateOui(int oui) {
        return oui != 0 && (oui & 0xFF000000) == 0;
    }

    public boolean validate() {
        return OuiKeyedData.validateOui(this.mOui) && this.getData() != null;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OuiKeyedData that = (OuiKeyedData)o;
        return this.mOui == that.mOui && PersistableBundleUtils.isEqual(this.mData, that.mData);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int hashCode() {
        return Objects.hash(this.mOui, PersistableBundleUtils.getHashCode(this.mData));
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public String toString() {
        return "{oui=" + Integer.toHexString(this.mOui) + ", data=" + this.getData() + "}";
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mOui);
        dest.writePersistableBundle(this.mData);
    }

    OuiKeyedData(@NonNull Parcel in) {
        this.mOui = in.readInt();
        this.mData = in.readPersistableBundle();
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private final int mOui;
        @NonNull
        private final PersistableBundle mData;

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public Builder(int oui, @NonNull PersistableBundle data) {
            this.mOui = oui;
            this.mData = data;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public OuiKeyedData build() {
            OuiKeyedData ouiKeyedData = new OuiKeyedData(this.mOui, this.mData);
            if (!ouiKeyedData.validate()) {
                throw new IllegalArgumentException("Provided parameters are invalid");
            }
            return ouiKeyedData;
        }
    }
}

