/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class ThreadNetworkException
extends Exception {
    public static final int ERROR_INTERNAL_ERROR = 1;
    public static final int ERROR_ABORTED = 2;
    public static final int ERROR_TIMEOUT = 3;
    public static final int ERROR_UNAVAILABLE = 4;
    public static final int ERROR_BUSY = 5;
    public static final int ERROR_FAILED_PRECONDITION = 6;
    public static final int ERROR_UNSUPPORTED_CHANNEL = 7;
    public static final int ERROR_REJECTED_BY_PEER = 8;
    public static final int ERROR_RESPONSE_BAD_FORMAT = 9;
    public static final int ERROR_RESOURCE_EXHAUSTED = 10;
    public static final int ERROR_UNKNOWN = 11;
    public static final int ERROR_THREAD_DISABLED = 12;
    public static final int ERROR_UNSUPPORTED_FEATURE = 13;
    private static final int ERROR_MIN = 1;
    private static final int ERROR_MAX = 13;
    private final int mErrorCode;

    public ThreadNetworkException(int errorCode, @NonNull String message) {
        super(Objects.requireNonNull(message, "message cannot be null"));
        if (errorCode < 1 || errorCode > 13) {
            throw new IllegalArgumentException("errorCode cannot be " + errorCode + " (allowedRange = [" + 1 + ", " + 13 + "])");
        }
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

