/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.connectivity.android.net.thread.ChannelMaxPower;
import android.net.connectivity.android.net.thread.IActiveOperationalDatasetReceiver;
import android.net.connectivity.android.net.thread.IConfigurationReceiver;
import android.net.connectivity.android.net.thread.IOperationReceiver;
import android.net.connectivity.android.net.thread.IOperationalDatasetCallback;
import android.net.connectivity.android.net.thread.IStateCallback;
import android.net.connectivity.android.net.thread.IThreadNetworkController;
import android.net.thread.ActiveOperationalDataset;
import android.net.thread.PendingOperationalDataset;
import android.net.thread.ThreadConfiguration;
import android.net.thread.ThreadNetworkException;
import android.os.Binder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class ThreadNetworkController {
    private static final String TAG = "ThreadNetworkController";
    public static final int DEVICE_ROLE_STOPPED = 0;
    public static final int DEVICE_ROLE_DETACHED = 1;
    public static final int DEVICE_ROLE_CHILD = 2;
    public static final int DEVICE_ROLE_ROUTER = 3;
    public static final int DEVICE_ROLE_LEADER = 4;
    public static final int STATE_DISABLED = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_DISABLING = 2;
    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    public static final int EPHEMERAL_KEY_DISABLED = 0;
    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    public static final int EPHEMERAL_KEY_ENABLED = 1;
    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    public static final int EPHEMERAL_KEY_IN_USE = 2;
    public static final int THREAD_VERSION_1_3 = 4;
    @SuppressLint(value={"MinMaxConstant"})
    public static final int MAX_POWER_CHANNEL_DISABLED = Integer.MIN_VALUE;
    @NonNull
    private static final Duration EPHEMERAL_KEY_LIFETIME_MAX = Duration.ofMinutes(10L);
    private final IThreadNetworkController mControllerService;
    private final Object mStateCallbackMapLock = new Object();
    @GuardedBy(value={"mStateCallbackMapLock"})
    private final Map<StateCallback, StateCallbackProxy> mStateCallbackMap = new HashMap<StateCallback, StateCallbackProxy>();
    private final Object mOpDatasetCallbackMapLock = new Object();
    @GuardedBy(value={"mOpDatasetCallbackMapLock"})
    private final Map<OperationalDatasetCallback, OperationalDatasetCallbackProxy> mOpDatasetCallbackMap = new HashMap<OperationalDatasetCallback, OperationalDatasetCallbackProxy>();
    private final Object mConfigurationCallbackMapLock = new Object();
    @GuardedBy(value={"mConfigurationCallbackMapLock"})
    private final Map<Consumer<ThreadConfiguration>, ConfigurationCallbackProxy> mConfigurationCallbackMap = new HashMap<Consumer<ThreadConfiguration>, ConfigurationCallbackProxy>();

    public ThreadNetworkController(@NonNull IThreadNetworkController controllerService) {
        Objects.requireNonNull(controllerService, "controllerService cannot be null");
        this.mControllerService = controllerService;
    }

    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void setEnabled(boolean enabled, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        try {
            this.mControllerService.setEnabled(enabled, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    @NonNull
    public Duration getMaxEphemeralKeyLifetime() {
        return EPHEMERAL_KEY_LIFETIME_MAX;
    }

    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void activateEphemeralKeyMode(@NonNull Duration lifetime, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        if (lifetime.compareTo(Duration.ZERO) <= 0 || lifetime.compareTo(EPHEMERAL_KEY_LIFETIME_MAX) > 0) {
            throw new IllegalArgumentException("Invalid ephemeral key lifetime: the value must be in range of (0, " + EPHEMERAL_KEY_LIFETIME_MAX + "]");
        }
        long lifetimeMillis = lifetime.toMillis();
        try {
            this.mControllerService.activateEphemeralKeyMode(lifetimeMillis, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void deactivateEphemeralKeyMode(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        try {
            this.mControllerService.deactivateEphemeralKeyMode(new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getThreadVersion() {
        try {
            return this.mControllerService.getThreadVersion();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createRandomizedDataset(@NonNull String networkName, @NonNull Executor executor, @NonNull OutcomeReceiver<ActiveOperationalDataset, ThreadNetworkException> receiver) {
        ActiveOperationalDataset.checkNetworkName(networkName);
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.createRandomizedDataset(networkName, new ActiveDatasetReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public static boolean isAttached(int deviceRole) {
        return deviceRole == 2 || deviceRole == 3 || deviceRole == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void registerStateCallback(@NonNull Executor executor, @NonNull StateCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mStateCallbackMapLock;
        synchronized (object) {
            if (this.mStateCallbackMap.containsKey(callback)) {
                throw new IllegalArgumentException("callback has already been registered");
            }
            StateCallbackProxy callbackProxy = new StateCallbackProxy(executor, callback);
            this.mStateCallbackMap.put(callback, callbackProxy);
            try {
                this.mControllerService.registerStateCallback(callbackProxy);
            }
            catch (RemoteException e) {
                this.mStateCallbackMap.remove(callback);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void unregisterStateCallback(@NonNull StateCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mStateCallbackMapLock;
        synchronized (object) {
            StateCallbackProxy callbackProxy = this.mStateCallbackMap.get(callback);
            if (callbackProxy == null) {
                throw new IllegalArgumentException("callback hasn't been registered");
            }
            try {
                this.mControllerService.unregisterStateCallback(callbackProxy);
                this.mStateCallbackMap.remove(callback);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.THREAD_NETWORK_PRIVILEGED"})
    public void registerOperationalDatasetCallback(@NonNull Executor executor, @NonNull OperationalDatasetCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mOpDatasetCallbackMapLock;
        synchronized (object) {
            if (this.mOpDatasetCallbackMap.containsKey(callback)) {
                throw new IllegalArgumentException("callback has already been registered");
            }
            OperationalDatasetCallbackProxy callbackProxy = new OperationalDatasetCallbackProxy(executor, callback);
            this.mOpDatasetCallbackMap.put(callback, callbackProxy);
            try {
                this.mControllerService.registerOperationalDatasetCallback(callbackProxy);
            }
            catch (RemoteException e) {
                this.mOpDatasetCallbackMap.remove(callback);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.THREAD_NETWORK_PRIVILEGED"})
    public void unregisterOperationalDatasetCallback(@NonNull OperationalDatasetCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mOpDatasetCallbackMapLock;
        synchronized (object) {
            OperationalDatasetCallbackProxy callbackProxy = this.mOpDatasetCallbackMap.get(callback);
            if (callbackProxy == null) {
                throw new IllegalArgumentException("callback hasn't been registered");
            }
            try {
                this.mControllerService.unregisterOperationalDatasetCallback(callbackProxy);
                this.mOpDatasetCallbackMap.remove(callback);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void join(@NonNull ActiveOperationalDataset activeDataset, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(activeDataset, "activeDataset cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.join(activeDataset, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void scheduleMigration(@NonNull PendingOperationalDataset pendingDataset, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(pendingDataset, "pendingDataset cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.scheduleMigration(pendingDataset, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void leave(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.leave(new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void setConfiguration(@NonNull ThreadConfiguration configuration, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.setConfiguration(configuration, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.net.thread.flags.configuration_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void registerConfigurationCallback(@NonNull Executor executor, @NonNull Consumer<ThreadConfiguration> callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mConfigurationCallbackMapLock;
        synchronized (object) {
            if (this.mConfigurationCallbackMap.containsKey(callback)) {
                throw new IllegalArgumentException("callback has already been registered");
            }
            ConfigurationCallbackProxy callbackProxy = new ConfigurationCallbackProxy(executor, callback);
            this.mConfigurationCallbackMap.put(callback, callbackProxy);
            try {
                this.mControllerService.registerConfigurationCallback(callbackProxy);
            }
            catch (RemoteException e) {
                this.mConfigurationCallbackMap.remove(callback);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.net.thread.flags.configuration_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void unregisterConfigurationCallback(@NonNull Consumer<ThreadConfiguration> callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mConfigurationCallbackMapLock;
        synchronized (object) {
            ConfigurationCallbackProxy callbackProxy = this.mConfigurationCallbackMap.get(callback);
            if (callbackProxy == null) {
                throw new IllegalArgumentException("callback hasn't been registered");
            }
            try {
                this.mControllerService.unregisterConfigurationCallback(callbackProxy);
                this.mConfigurationCallbackMap.remove(callbackProxy.mConfigurationConsumer);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    @VisibleForTesting
    @RequiresPermission(allOf={"android.permission.THREAD_NETWORK_PRIVILEGED", "android.permission.NETWORK_SETTINGS"})
    public void setTestNetworkAsUpstream(@Nullable String testNetworkInterfaceName, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        try {
            this.mControllerService.setTestNetworkAsUpstream(testNetworkInterfaceName, new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.net.thread.flags.channel_max_powers_enabled")
    @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
    public void setChannelMaxPowers(@NonNull SparseIntArray channelMaxPowers, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ThreadNetworkException> receiver) {
        Objects.requireNonNull(channelMaxPowers, "channelMaxPowers cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(receiver, "receiver cannot be null");
        if (channelMaxPowers.size() < 1) {
            throw new IllegalArgumentException("channelMaxPowers cannot be empty");
        }
        for (int i = 0; i < channelMaxPowers.size(); ++i) {
            int channel = channelMaxPowers.keyAt(i);
            if (channel >= 11 && channel <= 26) continue;
            throw new IllegalArgumentException("Channel " + channel + " exceeds allowed range [" + 11 + ", " + 26 + "]");
        }
        try {
            this.mControllerService.setChannelMaxPowers(ThreadNetworkController.toChannelMaxPowerArray(channelMaxPowers), new OperationReceiverProxy(executor, receiver));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static ChannelMaxPower[] toChannelMaxPowerArray(@NonNull SparseIntArray channelMaxPowers) {
        ChannelMaxPower[] powerArray = new ChannelMaxPower[channelMaxPowers.size()];
        for (int i = 0; i < channelMaxPowers.size(); ++i) {
            powerArray[i] = new ChannelMaxPower();
            powerArray[i].channel = channelMaxPowers.keyAt(i);
            powerArray[i].maxPower = channelMaxPowers.get(powerArray[i].channel);
        }
        return powerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void propagateError(Executor executor, OutcomeReceiver<T, ThreadNetworkException> receiver, int errorCode, String errorMsg) {
        long identity = Binder.clearCallingIdentity();
        try {
            executor.execute(() -> receiver.onError(new ThreadNetworkException(errorCode, errorMsg)));
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private static class OperationReceiverProxy
    extends IOperationReceiver.Stub {
        final Executor mExecutor;
        final OutcomeReceiver<Void, ThreadNetworkException> mResultReceiver;

        OperationReceiverProxy(Executor executor, OutcomeReceiver<Void, ThreadNetworkException> resultReceiver) {
            this.mExecutor = executor;
            this.mResultReceiver = resultReceiver;
        }

        @Override
        public void onSuccess() {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mResultReceiver.onResult(null));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            ThreadNetworkController.propagateError(this.mExecutor, this.mResultReceiver, errorCode, errorMessage);
        }
    }

    private static class ActiveDatasetReceiverProxy
    extends IActiveOperationalDatasetReceiver.Stub {
        final Executor mExecutor;
        final OutcomeReceiver<ActiveOperationalDataset, ThreadNetworkException> mResultReceiver;

        ActiveDatasetReceiverProxy(Executor executor, OutcomeReceiver<ActiveOperationalDataset, ThreadNetworkException> resultReceiver) {
            this.mExecutor = executor;
            this.mResultReceiver = resultReceiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ActiveOperationalDataset dataset) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mResultReceiver.onResult(dataset));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            ThreadNetworkController.propagateError(this.mExecutor, this.mResultReceiver, errorCode, errorMessage);
        }
    }

    private static class StateCallbackProxy
    extends IStateCallback.Stub {
        private final Executor mExecutor;
        private final StateCallback mCallback;

        StateCallbackProxy(Executor executor, StateCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceRoleChanged(int deviceRole) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onDeviceRoleChanged(deviceRole));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPartitionIdChanged(long partitionId) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onPartitionIdChanged(partitionId));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThreadEnableStateChanged(int enabled) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onThreadEnableStateChanged(enabled));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEphemeralKeyStateChanged(int ephemeralKeyState, String ephemeralKey, long lifetimeMillis) {
            long identity = Binder.clearCallingIdentity();
            Instant expiry = ephemeralKeyState == 0 ? null : Instant.now().plusMillis(lifetimeMillis);
            try {
                this.mExecutor.execute(() -> this.mCallback.onEphemeralKeyStateChanged(ephemeralKeyState, ephemeralKey, expiry));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface StateCallback {
        public void onDeviceRoleChanged(int var1);

        default public void onPartitionIdChanged(long partitionId) {
        }

        default public void onThreadEnableStateChanged(int enabledState) {
        }

        @FlaggedApi(value="com.android.net.thread.flags.epskc_enabled")
        @RequiresPermission(value="android.permission.THREAD_NETWORK_PRIVILEGED")
        default public void onEphemeralKeyStateChanged(int ephemeralKeyState, @Nullable String ephemeralKey, @Nullable Instant expiry) {
        }
    }

    private static class OperationalDatasetCallbackProxy
    extends IOperationalDatasetCallback.Stub {
        private final Executor mExecutor;
        private final OperationalDatasetCallback mCallback;

        OperationalDatasetCallbackProxy(Executor executor, OperationalDatasetCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActiveOperationalDatasetChanged(@Nullable ActiveOperationalDataset activeDataset) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onActiveOperationalDatasetChanged(activeDataset));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPendingOperationalDatasetChanged(@Nullable PendingOperationalDataset pendingDataset) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onPendingOperationalDatasetChanged(pendingDataset));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface OperationalDatasetCallback {
        public void onActiveOperationalDatasetChanged(@Nullable ActiveOperationalDataset var1);

        default public void onPendingOperationalDatasetChanged(@Nullable PendingOperationalDataset pendingDataset) {
        }
    }

    private static class ConfigurationCallbackProxy
    extends IConfigurationReceiver.Stub {
        final Executor mExecutor;
        final Consumer<ThreadConfiguration> mConfigurationConsumer;

        ConfigurationCallbackProxy(Executor executor, Consumer<ThreadConfiguration> ConfigurationConsumer) {
            this.mExecutor = executor;
            this.mConfigurationConsumer = ConfigurationConsumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigurationChanged(ThreadConfiguration configuration) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mConfigurationConsumer.accept(configuration));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThreadVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EphemeralKeyState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnabledState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceRole {
    }
}

