/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.net.thread.ActiveOperationalDataset;
import android.net.thread.OperationalDatasetTimestamp;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class PendingOperationalDataset
implements Parcelable {
    private static final int TYPE_PENDING_TIMESTAMP = 51;
    private static final int TYPE_DELAY_TIMER = 52;
    private static final int LENGTH_DELAY_TIMER_BYTES = 4;
    @NonNull
    public static final Parcelable.Creator<PendingOperationalDataset> CREATOR = new Parcelable.Creator<PendingOperationalDataset>(){

        @Override
        public PendingOperationalDataset createFromParcel(Parcel in) {
            return PendingOperationalDataset.fromThreadTlvs(in.createByteArray());
        }

        public PendingOperationalDataset[] newArray(int size) {
            return new PendingOperationalDataset[size];
        }
    };
    @NonNull
    private final ActiveOperationalDataset mActiveOpDataset;
    @NonNull
    private final OperationalDatasetTimestamp mPendingTimestamp;
    @NonNull
    private final Duration mDelayTimer;

    public PendingOperationalDataset(@NonNull ActiveOperationalDataset activeOpDataset, @NonNull OperationalDatasetTimestamp pendingTimestamp, @NonNull Duration delayTimer) {
        Objects.requireNonNull(activeOpDataset, "activeOpDataset cannot be null");
        Objects.requireNonNull(pendingTimestamp, "pendingTimestamp cannot be null");
        Objects.requireNonNull(delayTimer, "delayTimer cannot be null");
        this.mActiveOpDataset = activeOpDataset;
        this.mPendingTimestamp = pendingTimestamp;
        this.mDelayTimer = delayTimer;
    }

    @NonNull
    public static PendingOperationalDataset fromThreadTlvs(@NonNull byte[] tlvs) {
        Objects.requireNonNull(tlvs, "tlvs cannot be null");
        SparseArray<byte[]> newUnknownTlvs = new SparseArray<byte[]>();
        OperationalDatasetTimestamp pendingTimestamp = null;
        Duration delayTimer = null;
        ActiveOperationalDataset activeDataset = ActiveOperationalDataset.fromThreadTlvs(tlvs);
        SparseArray<byte[]> unknownTlvs = activeDataset.getUnknownTlvs();
        block4: for (int i = 0; i < unknownTlvs.size(); ++i) {
            int key = unknownTlvs.keyAt(i);
            byte[] value = unknownTlvs.valueAt(i);
            switch (key) {
                case 51: {
                    pendingTimestamp = OperationalDatasetTimestamp.fromTlvValue(value);
                    continue block4;
                }
                case 52: {
                    Preconditions.checkArgument(value.length == 4, "Invalid delay timer (length = %d, expectedLength = %d)", value.length, 4);
                    int millis = ByteBuffer.wrap(value).getInt();
                    delayTimer = Duration.ofMillis(Integer.toUnsignedLong(millis));
                    continue block4;
                }
                default: {
                    newUnknownTlvs.put(key, value);
                }
            }
        }
        if (pendingTimestamp == null) {
            throw new IllegalArgumentException("Pending Timestamp is missing");
        }
        if (delayTimer == null) {
            throw new IllegalArgumentException("Delay Timer is missing");
        }
        activeDataset = new ActiveOperationalDataset.Builder(activeDataset).setUnknownTlvs(newUnknownTlvs).build();
        return new PendingOperationalDataset(activeDataset, pendingTimestamp, delayTimer);
    }

    @NonNull
    public ActiveOperationalDataset getActiveOperationalDataset() {
        return this.mActiveOpDataset;
    }

    @NonNull
    public OperationalDatasetTimestamp getPendingTimestamp() {
        return this.mPendingTimestamp;
    }

    @NonNull
    public Duration getDelayTimer() {
        return this.mDelayTimer;
    }

    @NonNull
    public byte[] toThreadTlvs() {
        ByteArrayOutputStream dataset = new ByteArrayOutputStream();
        byte[] activeDatasetBytes = this.mActiveOpDataset.toThreadTlvs();
        dataset.write(activeDatasetBytes, 0, activeDatasetBytes.length);
        dataset.write(51);
        byte[] pendingTimestampBytes = this.mPendingTimestamp.toTlvValue();
        dataset.write(pendingTimestampBytes.length);
        dataset.write(pendingTimestampBytes, 0, pendingTimestampBytes.length);
        dataset.write(52);
        byte[] delayTimerBytes = new byte[4];
        ByteBuffer.wrap(delayTimerBytes).putInt((int)this.mDelayTimer.toMillis());
        dataset.write(delayTimerBytes.length);
        dataset.write(delayTimerBytes, 0, delayTimerBytes.length);
        return dataset.toByteArray();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PendingOperationalDataset)) {
            return false;
        }
        PendingOperationalDataset otherDataset = (PendingOperationalDataset)other;
        return this.mActiveOpDataset.equals(otherDataset.mActiveOpDataset) && this.mPendingTimestamp.equals(otherDataset.mPendingTimestamp) && ((Object)this.mDelayTimer).equals(otherDataset.mDelayTimer);
    }

    public int hashCode() {
        return Objects.hash(this.mActiveOpDataset, this.mPendingTimestamp, this.mDelayTimer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{activeDataset=").append(this.getActiveOperationalDataset()).append(", pendingTimestamp=").append(this.getPendingTimestamp()).append(", delayTimer=").append(this.getDelayTimer()).append("}");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByteArray(this.toThreadTlvs());
    }
}

