/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.ConnectivityThread;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.connectivity.android.net.nsd.INsdManagerCallback;
import android.net.connectivity.android.net.nsd.INsdServiceConnector;
import android.net.connectivity.android.net.nsd.IOffloadEngine;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.nsd.AdvertisingRequest;
import android.net.nsd.DiscoveryRequest;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.net.nsd.OffloadEngine;
import android.net.nsd.OffloadServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NsdManager {
    private static final String TAG = NsdManager.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String TYPE_LABEL_REGEX = "_[a-zA-Z0-9-_]{1,61}[a-zA-Z0-9]";
    public static final String SUBTYPE_LABEL_REGEX = "_[\\x20-\\x2b\\x2d\\x2f-\\x7e]{1,62}";
    public static final String TYPE_REGEX = "^(?:(_[\\x20-\\x2b\\x2d\\x2f-\\x7e]{1,62})\\.)?(_[a-zA-Z0-9-_]{1,61}[a-zA-Z0-9]\\._(?:tcp|udp))\\.?((?:,_[\\x20-\\x2b\\x2d\\x2f-\\x7e]{1,62})*)$";
    public static final String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    public static final String EXTRA_NSD_STATE = "nsd_state";
    public static final int NSD_STATE_DISABLED = 1;
    public static final int NSD_STATE_ENABLED = 2;
    public static final int DISCOVER_SERVICES = 1;
    public static final int DISCOVER_SERVICES_STARTED = 2;
    public static final int DISCOVER_SERVICES_FAILED = 3;
    public static final int SERVICE_FOUND = 4;
    public static final int SERVICE_LOST = 5;
    public static final int STOP_DISCOVERY = 6;
    public static final int STOP_DISCOVERY_FAILED = 7;
    public static final int STOP_DISCOVERY_SUCCEEDED = 8;
    public static final int REGISTER_SERVICE = 9;
    public static final int REGISTER_SERVICE_FAILED = 10;
    public static final int REGISTER_SERVICE_SUCCEEDED = 11;
    public static final int UNREGISTER_SERVICE = 12;
    public static final int UNREGISTER_SERVICE_FAILED = 13;
    public static final int UNREGISTER_SERVICE_SUCCEEDED = 14;
    public static final int RESOLVE_SERVICE = 15;
    public static final int RESOLVE_SERVICE_FAILED = 16;
    public static final int RESOLVE_SERVICE_SUCCEEDED = 17;
    public static final int DAEMON_CLEANUP = 18;
    public static final int DAEMON_STARTUP = 19;
    public static final int MDNS_SERVICE_EVENT = 20;
    public static final int REGISTER_CLIENT = 21;
    public static final int UNREGISTER_CLIENT = 22;
    public static final int MDNS_DISCOVERY_MANAGER_EVENT = 23;
    public static final int STOP_RESOLUTION = 24;
    public static final int STOP_RESOLUTION_FAILED = 25;
    public static final int STOP_RESOLUTION_SUCCEEDED = 26;
    public static final int REGISTER_SERVICE_CALLBACK = 27;
    public static final int REGISTER_SERVICE_CALLBACK_FAILED = 28;
    public static final int SERVICE_UPDATED = 29;
    public static final int SERVICE_UPDATED_LOST = 30;
    public static final int UNREGISTER_SERVICE_CALLBACK = 31;
    public static final int UNREGISTER_SERVICE_CALLBACK_SUCCEEDED = 32;
    public static final int REGISTER_OFFLOAD_ENGINE = 33;
    public static final int UNREGISTER_OFFLOAD_ENGINE = 34;
    public static final int PROTOCOL_DNS_SD = 1;
    public static final long TTL_SECONDS_MIN = 30L;
    public static final long TTL_SECONDS_MAX = 36000L;
    private static final SparseArray<String> EVENT_NAMES = new SparseArray();
    private static final int FIRST_LISTENER_KEY = 1;
    private static final int DNSSEC_PROTOCOL = 3;
    private final INsdServiceConnector mService;
    private final Context mContext;
    private int mListenerKey = 1;
    @GuardedBy(value={"mMapLock"})
    private final SparseArray mListenerMap = new SparseArray();
    @GuardedBy(value={"mMapLock"})
    private final SparseArray<NsdServiceInfo> mServiceMap = new SparseArray();
    @GuardedBy(value={"mMapLock"})
    private final SparseArray<DiscoveryRequest> mDiscoveryMap = new SparseArray();
    @GuardedBy(value={"mMapLock"})
    private final SparseArray<Executor> mExecutorMap = new SparseArray();
    private final Object mMapLock = new Object();
    @GuardedBy(value={"mPerNetworkDiscoveryMap"})
    private final ArrayMap<Integer, PerNetworkDiscoveryTracker> mPerNetworkDiscoveryMap = new ArrayMap();
    @GuardedBy(value={"mOffloadEngines"})
    private final ArrayList<OffloadEngineProxy> mOffloadEngines = new ArrayList();
    private final ServiceHandler mHandler;
    public static final int FAILURE_INTERNAL_ERROR = 0;
    public static final int FAILURE_ALREADY_ACTIVE = 3;
    public static final int FAILURE_MAX_LIMIT = 4;
    public static final int FAILURE_OPERATION_NOT_RUNNING = 5;
    public static final int FAILURE_BAD_PARAMETERS = 6;

    public static String nameOf(int event) {
        String name = EVENT_NAMES.get(event);
        if (name == null) {
            return Integer.toString(event);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.net.flags.register_nsd_offload_engine_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void registerOffloadEngine(@NonNull String ifaceName, long offloadType, long offloadCapability, @NonNull Executor executor, @NonNull OffloadEngine engine) {
        Objects.requireNonNull(ifaceName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(engine);
        OffloadEngineProxy cbImpl = new OffloadEngineProxy(executor, engine);
        ArrayList<OffloadEngineProxy> arrayList = this.mOffloadEngines;
        synchronized (arrayList) {
            if (CollectionUtils.contains(this.mOffloadEngines, impl -> impl.mEngine == engine)) {
                throw new IllegalStateException("This engine is already registered");
            }
            this.mOffloadEngines.add(cbImpl);
        }
        try {
            this.mService.registerOffloadEngine(ifaceName, cbImpl, offloadCapability, offloadType);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.net.flags.register_nsd_offload_engine_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void unregisterOffloadEngine(@NonNull OffloadEngine engine) {
        OffloadEngineProxy cbImpl;
        Objects.requireNonNull(engine);
        ArrayList<OffloadEngineProxy> arrayList = this.mOffloadEngines;
        synchronized (arrayList) {
            int index = CollectionUtils.indexOf(this.mOffloadEngines, impl -> impl.mEngine == engine);
            if (index < 0) {
                throw new IllegalStateException("This engine is not registered");
            }
            cbImpl = this.mOffloadEngines.remove(index);
        }
        try {
            this.mService.unregisterOffloadEngine(cbImpl);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public NsdManager(Context context, INsdManager service) {
        this.mContext = context;
        this.mHandler = new ServiceHandler(ConnectivityThread.getInstanceLooper());
        try {
            this.mService = service.connect(new NsdCallbackImpl(this.mHandler), CompatChanges.isChangeEnabled(270306772L));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to connect to NsdService");
        }
        if (!CompatChanges.isChangeEnabled(235355681L) && !SdkLevel.isAtLeastV()) {
            try {
                this.mService.startDaemon();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to proactively start daemon");
            }
        }
    }

    private int nextListenerKey() {
        this.mListenerKey = Math.max(1, this.mListenerKey + 1);
        return this.mListenerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener, Executor e, NsdServiceInfo serviceInfo) {
        Object object = this.mMapLock;
        synchronized (object) {
            return this.putListener(listener, e, this.mServiceMap, serviceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener, Executor e, DiscoveryRequest discoveryRequest) {
        Object object = this.mMapLock;
        synchronized (object) {
            return this.putListener(listener, e, this.mDiscoveryMap, discoveryRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int putListener(Object listener, Executor e, SparseArray<T> map, T value) {
        Object object = this.mMapLock;
        synchronized (object) {
            NsdManager.checkListener(listener);
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex != -1) {
                throw new IllegalArgumentException("listener already in use");
            }
            int key = this.nextListenerKey();
            this.mListenerMap.put(key, listener);
            map.put(key, value);
            this.mExecutorMap.put(key, e);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRegisteredListener(Object listener, Executor e, NsdServiceInfo s) {
        int key;
        Object object = this.mMapLock;
        synchronized (object) {
            key = this.getListenerKey(listener);
            this.mServiceMap.put(key, s);
            this.mExecutorMap.put(key, e);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(int key) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mServiceMap.remove(key);
            this.mDiscoveryMap.remove(key);
            this.mExecutorMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex == -1) {
                throw new IllegalArgumentException("listener not registered");
            }
            return this.mListenerMap.keyAt(valueIndex);
        }
    }

    private static String getNsdServiceInfoType(DiscoveryRequest r) {
        if (r == null) {
            return "?";
        }
        return r.getServiceType();
    }

    public void registerService(NsdServiceInfo serviceInfo, int protocolType, RegistrationListener listener) {
        this.registerService(serviceInfo, protocolType, Runnable::run, listener);
    }

    public void registerService(@NonNull NsdServiceInfo serviceInfo, int protocolType, @NonNull Executor executor, @NonNull RegistrationListener listener) {
        NsdManager.checkServiceInfoForRegistration(serviceInfo);
        NsdManager.checkProtocol(protocolType);
        AdvertisingRequest.Builder builder = new AdvertisingRequest.Builder(serviceInfo, protocolType);
        if (this.isSubtypeUpdateRequest(serviceInfo, listener)) {
            builder.setFlags(1L);
        }
        this.registerService(builder.build(), executor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubtypeUpdateRequest(@NonNull NsdServiceInfo serviceInfo, @NonNull RegistrationListener listener) {
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex == -1) {
                return false;
            }
            int key = this.mListenerMap.keyAt(valueIndex);
            NsdServiceInfo existingService = this.mServiceMap.get(key);
            if (existingService == null) {
                return false;
            }
            Pair<String, String> existingTypeSubtype = NsdManager.getTypeAndSubtypes(existingService.getServiceType());
            Pair<String, String> newTypeSubtype = NsdManager.getTypeAndSubtypes(serviceInfo.getServiceType());
            if (existingTypeSubtype == null || newTypeSubtype == null) {
                return false;
            }
            boolean existingHasNoSubtype = TextUtils.isEmpty((CharSequence)existingTypeSubtype.second);
            boolean updatedHasNoSubtype = TextUtils.isEmpty((CharSequence)newTypeSubtype.second);
            if (existingHasNoSubtype && updatedHasNoSubtype) {
                return false;
            }
            return Objects.equals(existingService.getServiceName(), serviceInfo.getServiceName()) && Objects.equals(existingTypeSubtype.first, newTypeSubtype.first);
        }
    }

    @Nullable
    private static Pair<String, String> getTypeAndSubtypes(@Nullable String typeWithSubtype) {
        if (typeWithSubtype == null) {
            return null;
        }
        Matcher matcher = Pattern.compile(TYPE_REGEX).matcher(typeWithSubtype);
        if (!matcher.matches()) {
            return null;
        }
        if (!TextUtils.isEmpty(matcher.group(1))) {
            return null;
        }
        return new Pair<String, String>(matcher.group(2), matcher.group(3));
    }

    @FlaggedApi(value="com.android.net.flags.mdns_advertising_improvement")
    public void registerService(@NonNull AdvertisingRequest advertisingRequest, @NonNull Executor executor, @NonNull RegistrationListener listener) {
        NsdServiceInfo serviceInfo = advertisingRequest.getServiceInfo();
        int protocolType = advertisingRequest.getProtocolType();
        NsdManager.checkServiceInfoForRegistration(serviceInfo);
        NsdManager.checkProtocol(protocolType);
        int key = (advertisingRequest.getFlags() & 1L) > 0L ? this.updateRegisteredListener(listener, executor, serviceInfo) : this.putListener((Object)listener, executor, serviceInfo);
        try {
            this.mService.registerService(key, advertisingRequest);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unregisterService(RegistrationListener listener) {
        int id2 = this.getListenerKey(listener);
        try {
            this.mService.unregisterService(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void discoverServices(String serviceType, int protocolType, DiscoveryListener listener) {
        this.discoverServices(serviceType, protocolType, (Network)null, Runnable::run, listener);
    }

    public void discoverServices(@NonNull String serviceType, int protocolType, @Nullable Network network, @NonNull Executor executor, @NonNull DiscoveryListener listener) {
        if (TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        DiscoveryRequest request = new DiscoveryRequest.Builder(protocolType, serviceType).setNetwork(network).build();
        this.discoverServices(request, executor, listener);
    }

    @FlaggedApi(value="com.android.net.flags.nsd_subtypes_support_enabled")
    public void discoverServices(@NonNull DiscoveryRequest discoveryRequest, @NonNull Executor executor, @NonNull DiscoveryListener listener) {
        int key = this.putListener((Object)listener, executor, discoveryRequest);
        try {
            this.mService.discoverServices(key, discoveryRequest);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void discoverServices(@NonNull String serviceType, int protocolType, @NonNull NetworkRequest networkRequest, @NonNull Executor executor, @NonNull DiscoveryListener listener) {
        if (TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        Objects.requireNonNull(networkRequest, "NetworkRequest cannot be null");
        DiscoveryRequest discoveryRequest = new DiscoveryRequest.Builder(protocolType, serviceType).build();
        int baseListenerKey = this.putListener((Object)listener, executor, discoveryRequest);
        PerNetworkDiscoveryTracker discoveryInfo = new PerNetworkDiscoveryTracker(serviceType, protocolType, executor, listener);
        ArrayMap<Integer, PerNetworkDiscoveryTracker> arrayMap = this.mPerNetworkDiscoveryMap;
        synchronized (arrayMap) {
            this.mPerNetworkDiscoveryMap.put(baseListenerKey, discoveryInfo);
            discoveryInfo.start(networkRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceDiscovery(DiscoveryListener listener) {
        int id2 = this.getListenerKey(listener);
        ArrayMap<Integer, PerNetworkDiscoveryTracker> arrayMap = this.mPerNetworkDiscoveryMap;
        synchronized (arrayMap) {
            PerNetworkDiscoveryTracker info = this.mPerNetworkDiscoveryMap.get(id2);
            if (info != null) {
                info.requestStop();
                return;
            }
        }
        try {
            this.mService.stopDiscovery(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void resolveService(NsdServiceInfo serviceInfo, ResolveListener listener) {
        this.resolveService(serviceInfo, Runnable::run, listener);
    }

    @Deprecated
    public void resolveService(@NonNull NsdServiceInfo serviceInfo, @NonNull Executor executor, @NonNull ResolveListener listener) {
        NsdManager.checkServiceInfoForResolution(serviceInfo);
        int key = this.putListener((Object)listener, executor, serviceInfo);
        try {
            this.mService.resolveService(key, serviceInfo);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void stopServiceResolution(@NonNull ResolveListener listener) {
        int id2 = this.getListenerKey(listener);
        try {
            this.mService.stopResolution(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void registerServiceInfoCallback(@NonNull NsdServiceInfo serviceInfo, @NonNull Executor executor, @NonNull ServiceInfoCallback listener) {
        NsdManager.checkServiceInfoForResolution(serviceInfo);
        int key = this.putListener((Object)listener, executor, serviceInfo);
        try {
            this.mService.registerServiceInfoCallback(key, serviceInfo);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unregisterServiceInfoCallback(@NonNull ServiceInfoCallback listener) {
        int id2 = this.getListenerKey(listener);
        try {
            this.mService.unregisterServiceInfoCallback(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static void checkListener(Object listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
    }

    static void checkProtocol(int protocolType) {
        if (protocolType != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
    }

    private static void checkServiceInfoForResolution(NsdServiceInfo serviceInfo) {
        Objects.requireNonNull(serviceInfo, "NsdServiceInfo cannot be null");
        if (TextUtils.isEmpty(serviceInfo.getServiceName())) {
            throw new IllegalArgumentException("Service name cannot be empty");
        }
        if (TextUtils.isEmpty(serviceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
    }

    private static ServiceValidationType validateService(NsdServiceInfo serviceInfo) {
        boolean hasServiceType;
        boolean hasServiceName = !TextUtils.isEmpty(serviceInfo.getServiceName());
        boolean bl = hasServiceType = !TextUtils.isEmpty(serviceInfo.getServiceType());
        if (!hasServiceName && !hasServiceType && serviceInfo.getPort() == 0) {
            return ServiceValidationType.NO_SERVICE;
        }
        if (!hasServiceName || !hasServiceType) {
            throw new IllegalArgumentException("The service name or the service type is missing");
        }
        if (serviceInfo.getPort() < 0) {
            throw new IllegalArgumentException("Invalid port");
        }
        if (serviceInfo.getPort() == 0) {
            return ServiceValidationType.HAS_SERVICE_ZERO_PORT;
        }
        return ServiceValidationType.HAS_SERVICE;
    }

    private static HostValidationType validateHost(NsdServiceInfo serviceInfo) {
        boolean hasHostAddresses;
        boolean hasHostname = !TextUtils.isEmpty(serviceInfo.getHostname());
        boolean bl = hasHostAddresses = !CollectionUtils.isEmpty(serviceInfo.getHostAddresses());
        if (!hasHostname) {
            return HostValidationType.DEFAULT_HOST;
        }
        if (!hasHostAddresses) {
            return HostValidationType.CUSTOM_HOST_NO_ADDRESS;
        }
        return HostValidationType.CUSTOM_HOST;
    }

    private static PublicKeyValidationType validatePublicKey(NsdServiceInfo serviceInfo) {
        byte[] publicKey = serviceInfo.getPublicKey();
        if (publicKey == null) {
            return PublicKeyValidationType.NO_KEY;
        }
        if (publicKey.length < 4) {
            throw new IllegalArgumentException("The public key should be at least 4 bytes long");
        }
        byte protocol = publicKey[2];
        if (protocol == 3) {
            return PublicKeyValidationType.HAS_KEY;
        }
        throw new IllegalArgumentException("The public key's protocol (" + protocol + ") is invalid. It should be DNSSEC_PROTOCOL (3)");
    }

    public static void checkServiceInfoForRegistration(NsdServiceInfo serviceInfo) {
        Objects.requireNonNull(serviceInfo, "NsdServiceInfo cannot be null");
        ServiceValidationType serviceValidation = NsdManager.validateService(serviceInfo);
        HostValidationType hostValidation = NsdManager.validateHost(serviceInfo);
        PublicKeyValidationType publicKeyValidation = NsdManager.validatePublicKey(serviceInfo);
        if (serviceValidation == ServiceValidationType.NO_SERVICE && hostValidation == HostValidationType.DEFAULT_HOST) {
            throw new IllegalArgumentException("Nothing to register");
        }
        if (publicKeyValidation == PublicKeyValidationType.NO_KEY) {
            if (serviceValidation == ServiceValidationType.HAS_SERVICE_ZERO_PORT) {
                throw new IllegalArgumentException("The port is missing");
            }
            if (serviceValidation == ServiceValidationType.NO_SERVICE && hostValidation == HostValidationType.CUSTOM_HOST_NO_ADDRESS) {
                throw new IllegalArgumentException("The host addresses must be specified unless there is a service");
            }
        }
    }

    static {
        EVENT_NAMES.put(1, "DISCOVER_SERVICES");
        EVENT_NAMES.put(2, "DISCOVER_SERVICES_STARTED");
        EVENT_NAMES.put(3, "DISCOVER_SERVICES_FAILED");
        EVENT_NAMES.put(4, "SERVICE_FOUND");
        EVENT_NAMES.put(5, "SERVICE_LOST");
        EVENT_NAMES.put(6, "STOP_DISCOVERY");
        EVENT_NAMES.put(7, "STOP_DISCOVERY_FAILED");
        EVENT_NAMES.put(8, "STOP_DISCOVERY_SUCCEEDED");
        EVENT_NAMES.put(9, "REGISTER_SERVICE");
        EVENT_NAMES.put(10, "REGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(11, "REGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(12, "UNREGISTER_SERVICE");
        EVENT_NAMES.put(13, "UNREGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(14, "UNREGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(15, "RESOLVE_SERVICE");
        EVENT_NAMES.put(16, "RESOLVE_SERVICE_FAILED");
        EVENT_NAMES.put(17, "RESOLVE_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(18, "DAEMON_CLEANUP");
        EVENT_NAMES.put(19, "DAEMON_STARTUP");
        EVENT_NAMES.put(20, "MDNS_SERVICE_EVENT");
        EVENT_NAMES.put(24, "STOP_RESOLUTION");
        EVENT_NAMES.put(25, "STOP_RESOLUTION_FAILED");
        EVENT_NAMES.put(26, "STOP_RESOLUTION_SUCCEEDED");
        EVENT_NAMES.put(27, "REGISTER_SERVICE_CALLBACK");
        EVENT_NAMES.put(28, "REGISTER_SERVICE_CALLBACK_FAILED");
        EVENT_NAMES.put(29, "SERVICE_UPDATED");
        EVENT_NAMES.put(31, "UNREGISTER_SERVICE_CALLBACK");
        EVENT_NAMES.put(32, "UNREGISTER_SERVICE_CALLBACK_SUCCEEDED");
        EVENT_NAMES.put(23, "MDNS_DISCOVERY_MANAGER_EVENT");
        EVENT_NAMES.put(21, "REGISTER_CLIENT");
        EVENT_NAMES.put(22, "UNREGISTER_CLIENT");
    }

    private static class OffloadEngineProxy
    extends IOffloadEngine.Stub {
        private final Executor mExecutor;
        private final OffloadEngine mEngine;

        private OffloadEngineProxy(@NonNull Executor executor, @NonNull OffloadEngine appCb) {
            this.mExecutor = executor;
            this.mEngine = appCb;
        }

        @Override
        public void onOffloadServiceUpdated(OffloadServiceInfo info) {
            this.mExecutor.execute(() -> this.mEngine.onOffloadServiceUpdated(info));
        }

        @Override
        public void onOffloadServiceRemoved(OffloadServiceInfo info) {
            this.mExecutor.execute(() -> this.mEngine.onOffloadServiceRemoved(info));
        }
    }

    @VisibleForTesting
    class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            Executor executor;
            DiscoveryRequest discoveryRequest;
            NsdServiceInfo ns;
            Object listener;
            int what = message.what;
            int errorCode = message.arg1;
            int key = message.arg2;
            Object obj = message.obj;
            Object object = NsdManager.this.mMapLock;
            synchronized (object) {
                listener = NsdManager.this.mListenerMap.get(key);
                ns = NsdManager.this.mServiceMap.get(key);
                discoveryRequest = NsdManager.this.mDiscoveryMap.get(key);
                executor = NsdManager.this.mExecutorMap.get(key);
            }
            if (listener == null) {
                Log.d(TAG, "Stale key " + key);
                return;
            }
            switch (what) {
                case 2: {
                    String s = NsdManager.getNsdServiceInfoType((DiscoveryRequest)obj);
                    executor.execute(() -> ((DiscoveryListener)listener).onDiscoveryStarted(s));
                    break;
                }
                case 3: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onStartDiscoveryFailed(NsdManager.getNsdServiceInfoType(discoveryRequest), errorCode));
                    break;
                }
                case 4: {
                    executor.execute(() -> ((DiscoveryListener)listener).onServiceFound((NsdServiceInfo)obj));
                    break;
                }
                case 5: {
                    executor.execute(() -> ((DiscoveryListener)listener).onServiceLost((NsdServiceInfo)obj));
                    break;
                }
                case 7: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onStopDiscoveryFailed(NsdManager.getNsdServiceInfoType(discoveryRequest), errorCode));
                    break;
                }
                case 8: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onDiscoveryStopped(NsdManager.getNsdServiceInfoType(discoveryRequest)));
                    break;
                }
                case 10: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onRegistrationFailed(ns, errorCode));
                    break;
                }
                case 11: {
                    executor.execute(() -> ((RegistrationListener)listener).onServiceRegistered((NsdServiceInfo)obj));
                    break;
                }
                case 13: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onUnregistrationFailed(ns, errorCode));
                    break;
                }
                case 14: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onServiceUnregistered(ns));
                    break;
                }
                case 16: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onResolveFailed(ns, errorCode));
                    break;
                }
                case 17: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onServiceResolved((NsdServiceInfo)obj));
                    break;
                }
                case 25: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onStopResolutionFailed(ns, errorCode));
                    break;
                }
                case 26: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onResolutionStopped(ns));
                    break;
                }
                case 28: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ServiceInfoCallback)listener).onServiceInfoCallbackRegistrationFailed(errorCode));
                    break;
                }
                case 29: {
                    executor.execute(() -> ((ServiceInfoCallback)listener).onServiceUpdated((NsdServiceInfo)obj));
                    break;
                }
                case 30: {
                    executor.execute(() -> ((ServiceInfoCallback)listener).onServiceLost());
                    break;
                }
                case 32: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ServiceInfoCallback)listener).onServiceInfoCallbackUnregistered());
                    break;
                }
                default: {
                    Log.d(TAG, "Ignored " + message);
                }
            }
        }
    }

    private static class NsdCallbackImpl
    extends INsdManagerCallback.Stub {
        private final Handler mServHandler;

        NsdCallbackImpl(Handler serviceHandler) {
            this.mServHandler = serviceHandler;
        }

        private void sendInfo(int message, int listenerKey, NsdServiceInfo info) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, 0, listenerKey, info));
        }

        private void sendDiscoveryRequest(int message, int listenerKey, DiscoveryRequest discoveryRequest) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, 0, listenerKey, discoveryRequest));
        }

        private void sendError(int message, int listenerKey, int error) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, error, listenerKey));
        }

        private void sendNoArg(int message, int listenerKey) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, 0, listenerKey));
        }

        @Override
        public void onDiscoverServicesStarted(int listenerKey, DiscoveryRequest discoveryRequest) {
            this.sendDiscoveryRequest(2, listenerKey, discoveryRequest);
        }

        @Override
        public void onDiscoverServicesFailed(int listenerKey, int error) {
            this.sendError(3, listenerKey, error);
        }

        @Override
        public void onServiceFound(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(4, listenerKey, info);
        }

        @Override
        public void onServiceLost(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(5, listenerKey, info);
        }

        @Override
        public void onStopDiscoveryFailed(int listenerKey, int error) {
            this.sendError(7, listenerKey, error);
        }

        @Override
        public void onStopDiscoverySucceeded(int listenerKey) {
            this.sendNoArg(8, listenerKey);
        }

        @Override
        public void onRegisterServiceFailed(int listenerKey, int error) {
            this.sendError(10, listenerKey, error);
        }

        @Override
        public void onRegisterServiceSucceeded(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(11, listenerKey, info);
        }

        @Override
        public void onUnregisterServiceFailed(int listenerKey, int error) {
            this.sendError(13, listenerKey, error);
        }

        @Override
        public void onUnregisterServiceSucceeded(int listenerKey) {
            this.sendNoArg(14, listenerKey);
        }

        @Override
        public void onResolveServiceFailed(int listenerKey, int error) {
            this.sendError(16, listenerKey, error);
        }

        @Override
        public void onResolveServiceSucceeded(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(17, listenerKey, info);
        }

        @Override
        public void onStopResolutionFailed(int listenerKey, int error) {
            this.sendError(25, listenerKey, error);
        }

        @Override
        public void onStopResolutionSucceeded(int listenerKey) {
            this.sendNoArg(26, listenerKey);
        }

        @Override
        public void onServiceInfoCallbackRegistrationFailed(int listenerKey, int error) {
            this.sendError(28, listenerKey, error);
        }

        @Override
        public void onServiceUpdated(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(29, listenerKey, info);
        }

        @Override
        public void onServiceUpdatedLost(int listenerKey) {
            this.sendNoArg(30, listenerKey);
        }

        @Override
        public void onServiceInfoCallbackUnregistered(int listenerKey) {
            this.sendNoArg(32, listenerKey);
        }
    }

    public static interface RegistrationListener {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);
    }

    public static interface DiscoveryListener {
        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);

        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);
    }

    private class PerNetworkDiscoveryTracker {
        final String mServiceType;
        final int mProtocolType;
        final DiscoveryListener mBaseListener;
        final Executor mBaseExecutor;
        final ArrayMap<Network, DelegatingDiscoveryListener> mPerNetworkListeners = new ArrayMap();
        final ConnectivityManager.NetworkCallback mNetworkCb = new ConnectivityManager.NetworkCallback(){

            @Override
            public void onAvailable(@NonNull Network network) {
                DelegatingDiscoveryListener wrappedListener = new DelegatingDiscoveryListener(network, PerNetworkDiscoveryTracker.this.mBaseListener, PerNetworkDiscoveryTracker.this.mBaseExecutor);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.put(network, wrappedListener);
                NsdManager.this.discoverServices(PerNetworkDiscoveryTracker.this.mServiceType, PerNetworkDiscoveryTracker.this.mProtocolType, network, Runnable::run, (DiscoveryListener)wrappedListener);
            }

            @Override
            public void onLost(@NonNull Network network) {
                DelegatingDiscoveryListener listener = PerNetworkDiscoveryTracker.this.mPerNetworkListeners.get(network);
                if (listener == null) {
                    return;
                }
                listener.notifyAllServicesLost();
                NsdManager.this.stopServiceDiscovery(listener);
            }
        };
        private boolean mStopRequested;

        public void start(@NonNull NetworkRequest request) {
            ConnectivityManager cm = NsdManager.this.mContext.getSystemService(ConnectivityManager.class);
            cm.registerNetworkCallback(request, this.mNetworkCb, NsdManager.this.mHandler);
            NsdManager.this.mHandler.post(() -> this.mBaseExecutor.execute(() -> this.mBaseListener.onDiscoveryStarted(this.mServiceType)));
        }

        public void requestStop() {
            NsdManager.this.mHandler.post(() -> {
                this.mStopRequested = true;
                ConnectivityManager cm = NsdManager.this.mContext.getSystemService(ConnectivityManager.class);
                cm.unregisterNetworkCallback(this.mNetworkCb);
                if (this.mPerNetworkListeners.size() == 0) {
                    this.mBaseExecutor.execute(() -> this.mBaseListener.onDiscoveryStopped(this.mServiceType));
                    return;
                }
                for (int i = 0; i < this.mPerNetworkListeners.size(); ++i) {
                    DelegatingDiscoveryListener listener = this.mPerNetworkListeners.valueAt(i);
                    NsdManager.this.stopServiceDiscovery(listener);
                }
            });
        }

        private PerNetworkDiscoveryTracker(String serviceType, int protocolType, Executor baseExecutor, DiscoveryListener baseListener) {
            this.mServiceType = serviceType;
            this.mProtocolType = protocolType;
            this.mBaseExecutor = baseExecutor;
            this.mBaseListener = baseListener;
        }

        private class DelegatingDiscoveryListener
        implements DiscoveryListener {
            private final Network mNetwork;
            private final DiscoveryListener mWrapped;
            private final Executor mWrappedExecutor;
            private final ArraySet<TrackedNsdInfo> mFoundInfo = new ArraySet();
            private boolean mAllServicesLost = false;

            private DelegatingDiscoveryListener(Network network, DiscoveryListener listener, Executor executor) {
                this.mNetwork = network;
                this.mWrapped = listener;
                this.mWrappedExecutor = executor;
            }

            void notifyAllServicesLost() {
                for (int i = 0; i < this.mFoundInfo.size(); ++i) {
                    TrackedNsdInfo trackedInfo = this.mFoundInfo.valueAt(i);
                    NsdServiceInfo serviceInfo = new NsdServiceInfo(trackedInfo.mServiceName, trackedInfo.mServiceType);
                    serviceInfo.setNetwork(this.mNetwork);
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceLost(serviceInfo));
                }
                this.mAllServicesLost = true;
            }

            @Override
            public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                Log.e(TAG, "Failed to start discovery for " + serviceType + " on " + this.mNetwork + " with code " + errorCode);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
            }

            @Override
            public void onDiscoveryStarted(String serviceType) {
            }

            @Override
            public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                Log.e(TAG, "Failed to stop discovery for " + serviceType + " on " + this.mNetwork + " with code " + errorCode);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
                if (PerNetworkDiscoveryTracker.this.mStopRequested && PerNetworkDiscoveryTracker.this.mPerNetworkListeners.size() == 0) {
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onDiscoveryStopped(serviceType));
                }
            }

            @Override
            public void onDiscoveryStopped(String serviceType) {
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
                if (PerNetworkDiscoveryTracker.this.mStopRequested && PerNetworkDiscoveryTracker.this.mPerNetworkListeners.size() == 0) {
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onDiscoveryStopped(serviceType));
                }
            }

            @Override
            public void onServiceFound(NsdServiceInfo serviceInfo) {
                if (this.mAllServicesLost) {
                    return;
                }
                this.mFoundInfo.add(new TrackedNsdInfo(PerNetworkDiscoveryTracker.this, serviceInfo));
                this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceFound(serviceInfo));
            }

            @Override
            public void onServiceLost(NsdServiceInfo serviceInfo) {
                if (this.mAllServicesLost) {
                    return;
                }
                this.mFoundInfo.remove(new TrackedNsdInfo(PerNetworkDiscoveryTracker.this, serviceInfo));
                this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceLost(serviceInfo));
            }
        }

        private class TrackedNsdInfo {
            private final String mServiceName;
            private final String mServiceType;

            TrackedNsdInfo(PerNetworkDiscoveryTracker perNetworkDiscoveryTracker, NsdServiceInfo info) {
                this.mServiceName = info.getServiceName();
                this.mServiceType = info.getServiceType();
            }

            public int hashCode() {
                return Objects.hash(this.mServiceName, this.mServiceType);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TrackedNsdInfo)) {
                    return false;
                }
                TrackedNsdInfo other = (TrackedNsdInfo)obj;
                return Objects.equals(this.mServiceName, other.mServiceName) && Objects.equals(this.mServiceType, other.mServiceType);
            }
        }
    }

    public static interface ResolveListener {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);

        default public void onResolutionStopped(@NonNull NsdServiceInfo serviceInfo) {
        }

        default public void onStopResolutionFailed(@NonNull NsdServiceInfo serviceInfo, int errorCode) {
        }
    }

    private static enum ServiceValidationType {
        NO_SERVICE,
        HAS_SERVICE,
        HAS_SERVICE_ZERO_PORT;

    }

    private static enum HostValidationType {
        DEFAULT_HOST,
        CUSTOM_HOST,
        CUSTOM_HOST_NO_ADDRESS;

    }

    private static enum PublicKeyValidationType {
        NO_KEY,
        HAS_KEY;

    }

    public static interface ServiceInfoCallback {
        public void onServiceInfoCallbackRegistrationFailed(int var1);

        public void onServiceUpdated(@NonNull NsdServiceInfo var1);

        public void onServiceLost();

        public void onServiceInfoCallbackUnregistered();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolutionFailureCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopOperationFailureCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }
}

