/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike.exceptions;

import android.net.ipsec.ike.exceptions.IkeProtocolException;

public class InvalidMessageIdException
extends IkeProtocolException {
    private static final int EXPECTED_ERROR_DATA_LEN = 4;

    public InvalidMessageIdException(int messageId) {
        super(9, InvalidMessageIdException.integerToByteArray(messageId, 4));
    }

    public InvalidMessageIdException(byte[] notifyData) {
        super(9, notifyData);
    }

    public int getMessageId() {
        return InvalidMessageIdException.byteArrayToInteger(this.getErrorData());
    }

    @Override
    protected boolean isValidDataLength(int dataLen) {
        return 4 == dataLen;
    }

    @Override
    public int getMetricsErrorCode() {
        return 262153;
    }
}

