/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;

public class IkeKeyIdIdentification
extends IkeIdentification {
    private static final String KEY_ID_KEY = "keyId";
    @NonNull
    public final byte[] keyId;

    public IkeKeyIdIdentification(@NonNull byte[] keyId) {
        super(11);
        this.keyId = keyId;
    }

    @NonNull
    public static IkeKeyIdIdentification fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        PersistableBundle keyIdBundle = in.getPersistableBundle(KEY_ID_KEY);
        Objects.requireNonNull(in, "Key ID bundle is null");
        return new IkeKeyIdIdentification(PersistableBundleUtils.toByteArray(keyIdBundle));
    }

    @Override
    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putPersistableBundle(KEY_ID_KEY, PersistableBundleUtils.fromByteArray(this.keyId));
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, Arrays.hashCode(this.keyId));
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeKeyIdIdentification)) {
            return false;
        }
        return Arrays.equals(this.keyId, ((IkeKeyIdIdentification)o).keyId);
    }

    @Override
    public String getIdTypeString() {
        return "Key ID";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        throw new AuthenticationFailedException("Key ID cannot be used together with digital-signature-based authentication");
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.keyId;
    }
}

