/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.BidirectionalStream;
import android.net.http.HeaderBlock;
import android.net.http.HeaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BidirectionalStreamWrapper
extends BidirectionalStream {
    private final android.net.connectivity.org.chromium.net.BidirectionalStream backend;
    private String mHttpMethod = "POST";
    private int mPriority = 3;
    private boolean mHasTrafficStatsTag;
    private int mTrafficStatsTag;
    private boolean mHasTrafficStatsUid;
    private int mTrafficStatsUid;
    private boolean mDelayRequestHeadersUntilFirstFlush;
    private final List<Map.Entry<String, String>> mHeadersList;
    private HeaderBlock mHeaders;

    BidirectionalStreamWrapper(android.net.connectivity.org.chromium.net.BidirectionalStream backend) {
        this.backend = backend;
        this.mHeadersList = new ArrayList<Map.Entry<String, String>>();
        this.mHeaders = new HeaderBlockImpl(this.mHeadersList);
    }

    BidirectionalStreamWrapper(android.net.connectivity.org.chromium.net.BidirectionalStream backend, String httpMethod, boolean hasTrafficStatsTag, int trafficStatsTag, boolean hasTrafficStatsUid, int trafficStatsUid, int priority, HeaderBlock headers, boolean delayRequestHeadersUntilFirstFlush) {
        this(backend);
        this.mHasTrafficStatsTag = hasTrafficStatsTag;
        this.mHasTrafficStatsUid = hasTrafficStatsUid;
        this.mHttpMethod = httpMethod;
        this.mTrafficStatsTag = trafficStatsTag;
        this.mTrafficStatsUid = trafficStatsUid;
        this.mPriority = priority;
        this.mHeaders = headers;
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilFirstFlush;
    }

    @Override
    public void start() {
        this.backend.start();
    }

    @Override
    public void read(ByteBuffer buffer) {
        this.backend.read(buffer);
    }

    @Override
    public void write(ByteBuffer buffer, boolean endOfStream) {
        this.backend.write(buffer, endOfStream);
    }

    @Override
    public void flush() {
        this.backend.flush();
    }

    @Override
    public void cancel() {
        this.backend.cancel();
    }

    @Override
    public boolean isDone() {
        return this.backend.isDone();
    }

    @Override
    public boolean isDelayRequestHeadersUntilFirstFlushEnabled() {
        return this.mDelayRequestHeadersUntilFirstFlush;
    }

    @Override
    public int getPriority() {
        return this.mPriority;
    }

    @Override
    public String getHttpMethod() {
        return this.mHttpMethod;
    }

    @Override
    public boolean hasTrafficStatsTag() {
        return this.mHasTrafficStatsTag;
    }

    @Override
    public int getTrafficStatsTag() {
        if (!this.hasTrafficStatsTag()) {
            throw new IllegalStateException("TrafficStatsTag is not set");
        }
        return this.mTrafficStatsTag;
    }

    @Override
    public boolean hasTrafficStatsUid() {
        return this.mHasTrafficStatsUid;
    }

    @Override
    public int getTrafficStatsUid() {
        if (!this.hasTrafficStatsUid()) {
            throw new IllegalStateException("TrafficStatsUid is not set");
        }
        return this.mTrafficStatsUid;
    }

    @Override
    public HeaderBlock getHeaders() {
        return this.mHeaders;
    }

    void setHttpMethod(String httpMethod) {
        this.mHttpMethod = httpMethod;
    }

    void setTrafficStatsTag(int trafficStatsTag) {
        this.mHasTrafficStatsTag = true;
        this.mTrafficStatsTag = trafficStatsTag;
    }

    void setTrafficStatsUid(int trafficStatsUid) {
        this.mHasTrafficStatsUid = true;
        this.mTrafficStatsUid = trafficStatsUid;
    }

    void setPriority(int priority) {
        this.mPriority = priority;
    }

    void setDelayRequestHeadersUntilFirstFlushEnabled(boolean delayRequestHeadersUntilFirstFlushEnabled) {
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilFirstFlushEnabled;
    }

    void addHeader(String header, String value) {
        this.mHeadersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
    }
}

