/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.urlconnection;

import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import com.android.internal.lang.System_Delegate;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

class MessageLoop
implements Executor {
    private final BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
    private boolean mLoopRunning;
    private boolean mLoopFailed;
    private InterruptedIOException mPriorInterruptedIOException;
    private RuntimeException mPriorRuntimeException;
    private static final long INVALID_THREAD_ID = -1L;
    private long mThreadId = -1L;

    MessageLoop() {
    }

    private boolean calledOnValidThread() {
        if (this.mThreadId == -1L) {
            this.mThreadId = Thread.currentThread().getId();
            return true;
        }
        return this.mThreadId == Thread.currentThread().getId();
    }

    private Runnable take(boolean useTimeout, long timeoutNano) throws InterruptedIOException {
        Runnable task = null;
        try {
            task = !useTimeout ? this.mQueue.take() : this.mQueue.poll(timeoutNano, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            InterruptedIOException exception = new InterruptedIOException();
            exception.initCause(e);
            throw exception;
        }
        if (task == null) {
            throw new SocketTimeoutException();
        }
        return task;
    }

    public void loop() throws IOException {
        this.loop(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loop(int timeoutMilli) throws IOException {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("Cronet MessageLoop#loop");){
            assert (this.calledOnValidThread());
            long startNano = System_Delegate.nanoTime();
            long timeoutNano = TimeUnit.NANOSECONDS.convert(timeoutMilli, TimeUnit.MILLISECONDS);
            if (this.mLoopFailed) {
                if (this.mPriorInterruptedIOException == null) throw this.mPriorRuntimeException;
                throw this.mPriorInterruptedIOException;
            }
            if (this.mLoopRunning) {
                throw new IllegalStateException("Cannot run loop when it is already running.");
            }
            this.mLoopRunning = true;
            while (this.mLoopRunning) {
                try {
                    Runnable runnable = timeoutMilli == 0 ? this.take(false, 0L) : this.take(true, timeoutNano - System_Delegate.nanoTime() + startNano);
                    ScopedSysTraceEvent taskTraceEvent = ScopedSysTraceEvent.scoped("Cronet MessageLoop#loop running task");
                    try {
                        runnable.run();
                    }
                    finally {
                        if (taskTraceEvent == null) continue;
                        taskTraceEvent.close();
                    }
                }
                catch (InterruptedIOException e) {
                    this.mLoopRunning = false;
                    this.mLoopFailed = true;
                    this.mPriorInterruptedIOException = e;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.mLoopRunning = false;
                    this.mLoopFailed = true;
                    this.mPriorRuntimeException = e;
                    throw e;
                    return;
                }
            }
        }
    }

    public void quit() {
        assert (this.calledOnValidThread());
        this.mLoopRunning = false;
    }

    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mQueue.put(task);
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(e);
        }
    }

    public boolean isRunning() {
        return this.mLoopRunning;
    }

    public boolean hasLoopFailed() {
        return this.mLoopFailed;
    }
}

