/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.urlconnection;

import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.UploadDataProvider;
import android.net.connectivity.org.chromium.net.UploadDataSink;
import android.net.connectivity.org.chromium.net.urlconnection.CronetHttpURLConnection;
import android.net.connectivity.org.chromium.net.urlconnection.CronetOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.Objects;

class CronetBufferedOutputStream
extends CronetOutputStream {
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private final int mInitialContentLength;
    private final CronetHttpURLConnection mConnection;
    private final UploadDataProvider mUploadDataProvider = new UploadDataProviderImpl();
    private ByteBuffer mBuffer;
    private boolean mConnectRequested;
    private boolean mConnected;

    CronetBufferedOutputStream(CronetHttpURLConnection connection, long contentLength) {
        Objects.requireNonNull(connection, "Argument connection cannot be null.");
        if (contentLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Use setFixedLengthStreamingMode() or setChunkedStreamingMode() for requests larger than 2GB.");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length < 0.");
        }
        this.mConnection = connection;
        this.mInitialContentLength = (int)contentLength;
        this.mBuffer = ByteBuffer.allocate(this.mInitialContentLength);
    }

    CronetBufferedOutputStream(CronetHttpURLConnection connection) {
        this.mConnection = Objects.requireNonNull(connection);
        this.mInitialContentLength = -1;
        this.mBuffer = ByteBuffer.allocate(16384);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.checkNotClosed();
        this.ensureCanWrite(1);
        this.mBuffer.put((byte)oneByte);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        this.ensureCanWrite(count);
        this.mBuffer.put(buffer, offset, count);
    }

    private void ensureCanWrite(int count) throws IOException {
        if (this.mInitialContentLength != -1 && this.mBuffer.position() + count > this.mInitialContentLength) {
            throw new ProtocolException("exceeded content-length limit of " + this.mInitialContentLength + " bytes");
        }
        if (this.mInitialContentLength != -1) {
            return;
        }
        if (this.mBuffer.limit() - this.mBuffer.position() > count) {
            return;
        }
        int afterSize = Math.max(this.mBuffer.capacity() * 2, this.mBuffer.capacity() + count);
        ByteBuffer newByteBuffer = ByteBuffer.allocate(afterSize);
        this.mBuffer.flip();
        newByteBuffer.put(this.mBuffer);
        this.mBuffer = newByteBuffer;
    }

    @Override
    boolean connectRequested() throws IOException {
        assert (!this.mConnected);
        if (!this.isClosed()) {
            this.mConnectRequested = true;
            return false;
        }
        this.mConnected = true;
        if (this.mBuffer.position() < this.mInitialContentLength) {
            throw new ProtocolException("Content received is less than Content-Length");
        }
        this.mBuffer.flip();
        return true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.mConnectRequested) {
            this.mConnection.connect();
            this.mConnectRequested = false;
        }
    }

    @Override
    void checkReceivedEnoughContent() throws IOException {
    }

    @Override
    UploadDataProvider getUploadDataProvider() {
        return this.mUploadDataProvider;
    }

    private class UploadDataProviderImpl
    extends UploadDataProvider {
        private UploadDataProviderImpl() {
        }

        @Override
        public long getLength() {
            if (CronetBufferedOutputStream.this.mInitialContentLength == -1) {
                return CronetBufferedOutputStream.this.mConnected ? (long)CronetBufferedOutputStream.this.mBuffer.limit() : (long)CronetBufferedOutputStream.this.mBuffer.position();
            }
            return CronetBufferedOutputStream.this.mInitialContentLength;
        }

        @Override
        public void read(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetBufferedOutputStream.UploadDataProviderImpl#read");){
                int availableSpace = byteBuffer.remaining();
                if (availableSpace < CronetBufferedOutputStream.this.mBuffer.remaining()) {
                    byteBuffer.put(CronetBufferedOutputStream.this.mBuffer.array(), CronetBufferedOutputStream.this.mBuffer.position(), availableSpace);
                    CronetBufferedOutputStream.this.mBuffer.position(CronetBufferedOutputStream.this.mBuffer.position() + availableSpace);
                } else {
                    byteBuffer.put(CronetBufferedOutputStream.this.mBuffer);
                }
                uploadDataSink.onReadSucceeded(false);
            }
        }

        @Override
        public void rewind(UploadDataSink uploadDataSink) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetBufferedOutputStream.UploadDataProviderImpl#rewind");){
                CronetBufferedOutputStream.this.mBuffer.position(0);
                uploadDataSink.onRewindSucceeded();
            }
        }
    }
}

