/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.ObserverList;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.build.annotations.UsedByReflection;
import android.net.connectivity.org.chromium.net.ApiVersion;
import android.net.connectivity.org.chromium.net.BidirectionalStream;
import android.net.connectivity.org.chromium.net.ExperimentalBidirectionalStream;
import android.net.connectivity.org.chromium.net.ExperimentalUrlRequest;
import android.net.connectivity.org.chromium.net.NetworkQualityRttListener;
import android.net.connectivity.org.chromium.net.NetworkQualityThroughputListener;
import android.net.connectivity.org.chromium.net.RequestContextConfigOptions;
import android.net.connectivity.org.chromium.net.RequestFinishedInfo;
import android.net.connectivity.org.chromium.net.UploadDataProvider;
import android.net.connectivity.org.chromium.net.UrlRequest;
import android.net.connectivity.org.chromium.net.httpflags.ResolvedFlags;
import android.net.connectivity.org.chromium.net.impl.BidirectionalStreamBuilderImpl;
import android.net.connectivity.org.chromium.net.impl.CronetBidirectionalStream;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBase;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBuilderImpl;
import android.net.connectivity.org.chromium.net.impl.CronetLibraryLoader;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.impl.CronetLoggerFactory;
import android.net.connectivity.org.chromium.net.impl.CronetUrlRequest;
import android.net.connectivity.org.chromium.net.impl.CronetUrlRequestContextJni;
import android.net.connectivity.org.chromium.net.impl.ImplVersion;
import android.net.connectivity.org.chromium.net.impl.RefCountDelegate;
import android.net.connectivity.org.chromium.net.impl.VersionSafeCallbacks;
import android.net.connectivity.org.chromium.net.urlconnection.CronetHttpURLConnection;
import android.net.connectivity.org.chromium.net.urlconnection.CronetURLStreamHandlerFactory;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.net.connectivity.org.jni_zero.NativeClassQualifiedName;
import android.os.ConditionVariable;
import android.os.SystemClock;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

@JNINamespace(value="cronet")
@UsedByReflection(value="CronetEngine.java")
@VisibleForTesting
public class CronetUrlRequestContext
extends CronetEngineBase {
    static final String LOG_TAG = CronetUrlRequestContext.class.getSimpleName();
    private final Object mLock = new Object();
    private final ConditionVariable mInitCompleted = new ConditionVariable(false);
    private final AtomicInteger mRunningRequestCount = new AtomicInteger(0);
    private final AtomicInteger mActiveRequestCount = new AtomicInteger(0);
    @GuardedBy(value="mLock")
    private long mUrlRequestContextAdapter;
    private Thread mNetworkThread;
    private final boolean mNetworkQualityEstimatorEnabled;
    private final Object mNetworkQualityLock = new Object();
    private final Object mFinishedListenerLock = new Object();
    @GuardedBy(value="mNetworkQualityLock")
    private int mEffectiveConnectionType = 0;
    @GuardedBy(value="mNetworkQualityLock")
    private int mHttpRttMs = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private int mTransportRttMs = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private int mDownstreamThroughputKbps = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private final ObserverList<VersionSafeCallbacks.NetworkQualityRttListenerWrapper> mRttListenerList = new ObserverList();
    @GuardedBy(value="mNetworkQualityLock")
    private final ObserverList<VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper> mThroughputListenerList = new ObserverList();
    @GuardedBy(value="mFinishedListenerLock")
    private final Map<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener> mFinishedListenerMap = new HashMap<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener>();
    private final ConditionVariable mStopNetLogCompleted = new ConditionVariable();
    @GuardedBy(value="sInUseStoragePaths")
    private static final HashSet<String> sInUseStoragePaths = new HashSet();
    private final String mInUseStoragePath;
    @GuardedBy(value="mLock")
    private boolean mIsLogging;
    @GuardedBy(value="mLock")
    private boolean mIsStoppingNetLog;
    private long mNetworkHandle = -1L;
    private final long mLogId;
    private final CronetLogger mLogger;
    private final CronetLogger.CronetSource mSource;
    @VisibleForTesting
    public static final String OVERRIDE_NETWORK_THREAD_PRIORITY_FLAG_NAME = "Cronet_override_network_thread_priority";

    long getLogId() {
        return this.mLogId;
    }

    CronetLogger getCronetLogger() {
        return this.mLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByReflection(value="CronetEngine.java")
    public CronetUrlRequestContext(CronetEngineBuilderImpl builder, long startUptimeMillis) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#CronetUrlRequestContext");){
            Object object;
            this.mSource = builder.getCronetSource();
            this.mRttListenerList.disableThreadAsserts();
            this.mThroughputListenerList.disableThreadAsserts();
            this.mNetworkQualityEstimatorEnabled = builder.networkQualityEstimatorEnabled();
            boolean triggeredInitialization = CronetLibraryLoader.ensureInitialized(builder.getContext(), builder);
            if (builder.httpCacheMode() == 1) {
                this.mInUseStoragePath = builder.storagePath();
                object = sInUseStoragePaths;
                synchronized (object) {
                    if (!sInUseStoragePaths.add(this.mInUseStoragePath)) {
                        throw new IllegalStateException("Disk cache storage path already in use");
                    }
                }
            } else {
                this.mInUseStoragePath = null;
            }
            object = this.mLock;
            synchronized (object) {
                try (ScopedSysTraceEvent adapterTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#CronetUrlRequestContext creating adapter");){
                    this.mUrlRequestContextAdapter = CronetUrlRequestContextJni.get().createRequestContextAdapter(CronetUrlRequestContext.createNativeUrlRequestContextConfig(builder));
                }
                if (this.mUrlRequestContextAdapter == 0L) {
                    throw new NullPointerException("Context Adapter creation failed.");
                }
            }
            this.mLogger = CronetLoggerFactory.createLogger(builder.getContext(), builder.getCronetSource());
            this.mLogId = this.mLogger.generateId();
            CronetLogger.CronetEngineBuilderInfo builderLoggerInfo = builder.toLoggerInfo();
            try {
                this.mLogger.logCronetEngineCreation(this.getLogId(), builderLoggerInfo, this.buildCronetVersion(), builder.getCronetSource());
            }
            catch (RuntimeException e) {
                Log.i(LOG_TAG, "Error while trying to log CronetEngine creation: ", e);
            }
            final CronetInitializedInfoLogger cronetInitializedInfoLogger = triggeredInitialization ? new CronetInitializedInfoLogger(this.mLogger, builderLoggerInfo.getCronetInitializationRef(), startUptimeMillis, builder.getCronetSource()) : null;
            CronetLibraryLoader.postToInitThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = CronetUrlRequestContext.this.mLock;
                    synchronized (object) {
                        try (ScopedSysTraceEvent requestContextTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#CronetUrlRequestContext initializing request context");){
                            CronetUrlRequestContextJni.get().initRequestContextOnInitThread(CronetUrlRequestContext.this.mUrlRequestContextAdapter, CronetUrlRequestContext.this);
                        }
                    }
                    if (cronetInitializedInfoLogger != null) {
                        cronetInitializedInfoLogger.onInitThreadDone(CronetLibraryLoader.getCronetInitializedInfo());
                    }
                }
            });
            if (cronetInitializedInfoLogger != null) {
                cronetInitializedInfoLogger.onUserThreadDone();
            }
        }
    }

    @VisibleForTesting
    public static long createNativeUrlRequestContextConfig(CronetEngineBuilderImpl builder) {
        long urlRequestContextConfig = CronetUrlRequestContextJni.get().createRequestContextConfig(CronetUrlRequestContext.createRequestContextConfigOptions(builder).toByteArray());
        if (urlRequestContextConfig == 0L) {
            throw new IllegalArgumentException("Experimental options parsing failed.");
        }
        for (CronetEngineBuilderImpl.QuicHint quicHint : builder.quicHints()) {
            CronetUrlRequestContextJni.get().addQuicHint(urlRequestContextConfig, quicHint.mHost, quicHint.mPort, quicHint.mAlternatePort);
        }
        for (CronetEngineBuilderImpl.Pkp pkp : builder.publicKeyPins()) {
            CronetUrlRequestContextJni.get().addPkp(urlRequestContextConfig, pkp.mHost, pkp.mHashes, pkp.mIncludeSubdomains, pkp.mExpirationDate.getTime());
        }
        return urlRequestContextConfig;
    }

    private static RequestContextConfigOptions createRequestContextConfigOptions(CronetEngineBuilderImpl engineBuilder) {
        ResolvedFlags.Value networkThreadPriorityFlagValue = CronetLibraryLoader.getHttpFlags().flags().get(OVERRIDE_NETWORK_THREAD_PRIORITY_FLAG_NAME);
        RequestContextConfigOptions.Builder resultBuilder = RequestContextConfigOptions.newBuilder().setQuicEnabled(engineBuilder.quicEnabled()).setHttp2Enabled(engineBuilder.http2Enabled()).setBrotliEnabled(engineBuilder.brotliEnabled()).setDisableCache(engineBuilder.cacheDisabled()).setHttpCacheMode(engineBuilder.httpCacheMode()).setHttpCacheMaxSize(engineBuilder.httpCacheMaxSize()).setMockCertVerifier(engineBuilder.mockCertVerifier()).setEnableNetworkQualityEstimator(engineBuilder.networkQualityEstimatorEnabled()).setBypassPublicKeyPinningForLocalTrustAnchors(engineBuilder.publicKeyPinningBypassForLocalTrustAnchorsEnabled()).setNetworkThreadPriority(networkThreadPriorityFlagValue != null ? (int)networkThreadPriorityFlagValue.getIntValue() : engineBuilder.threadPriority(10));
        if (engineBuilder.getUserAgent() != null) {
            resultBuilder.setUserAgent(engineBuilder.getUserAgent());
        }
        if (engineBuilder.storagePath() != null) {
            resultBuilder.setStoragePath(engineBuilder.storagePath());
        }
        if (engineBuilder.getDefaultQuicUserAgentId() != null) {
            resultBuilder.setQuicDefaultUserAgentId(engineBuilder.getDefaultQuicUserAgentId());
        }
        if (engineBuilder.experimentalOptions() != null) {
            resultBuilder.setExperimentalOptions(engineBuilder.experimentalOptions());
        }
        return (RequestContextConfigOptions)resultBuilder.build();
    }

    CronetLogger.CronetSource getCronetSource() {
        return this.mSource;
    }

    @Override
    public ExperimentalBidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
        return new BidirectionalStreamBuilderImpl(url, callback, executor, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExperimentalUrlRequest createRequest(String url, UrlRequest.Callback callback, Executor executor, int priority, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, RequestFinishedInfo.Listener requestFinishedListener, int idempotency, long networkHandle, String method, ArrayList<Map.Entry<String, String>> requestHeaders, UploadDataProvider uploadDataProvider, Executor uploadDataProviderExecutor, byte[] sharedDictionaryHash, ByteBuffer sharedDictionary, @NonNull String sharedDictionaryId) {
        if (networkHandle == -1L) {
            networkHandle = this.mNetworkHandle;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return new CronetUrlRequest(this, url, priority, callback, executor, requestAnnotations, disableCache, disableConnectionMigration, allowDirectExecutor, trafficStatsTagSet, trafficStatsTag, trafficStatsUidSet, trafficStatsUid, requestFinishedListener, idempotency, networkHandle, method, requestHeaders, uploadDataProvider, uploadDataProviderExecutor, sharedDictionaryHash, sharedDictionary, sharedDictionaryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExperimentalBidirectionalStream createBidirectionalStream(String url, BidirectionalStream.Callback callback, Executor executor, String httpMethod, List<Map.Entry<String, String>> requestHeaders, int priority, boolean delayRequestHeadersUntilFirstFlush, Collection<Object> requestAnnotations, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, long networkHandle) {
        if (networkHandle == -1L) {
            networkHandle = this.mNetworkHandle;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return new CronetBidirectionalStream(this, url, priority, callback, executor, httpMethod, requestHeaders, delayRequestHeadersUntilFirstFlush, requestAnnotations, trafficStatsTagSet, trafficStatsTag, trafficStatsUidSet, trafficStatsUid, networkHandle);
        }
    }

    @Override
    public String getVersionString() {
        return "Cronet/" + ImplVersion.getCronetVersionWithLastChange();
    }

    @Override
    public int getActiveRequestCount() {
        return this.mActiveRequestCount.get();
    }

    private CronetLogger.CronetVersion buildCronetVersion() {
        return new CronetLogger.CronetVersion(ApiVersion.getCronetVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#shutdown");){
            Object object;
            if (this.mInUseStoragePath != null) {
                object = sInUseStoragePaths;
                synchronized (object) {
                    sInUseStoragePaths.remove(this.mInUseStoragePath);
                }
            }
            object = this.mLock;
            synchronized (object) {
                this.checkHaveAdapter();
                if (this.mRunningRequestCount.get() != 0) {
                    throw new IllegalStateException("Cannot shutdown with running requests.");
                }
                if (Thread.currentThread() == this.mNetworkThread) {
                    throw new IllegalThreadStateException("Cannot shutdown from network thread.");
                }
            }
            this.mInitCompleted.block();
            this.stopNetLog();
            object = this.mLock;
            synchronized (object) {
                block20: {
                    if (this.haveRequestContextAdapter()) break block20;
                    return;
                }
                CronetUrlRequestContextJni.get().destroy(this.mUrlRequestContextAdapter, this);
                this.mUrlRequestContextAdapter = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNetLogToFile(String fileName, boolean logAll) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            if (this.mIsLogging) {
                return;
            }
            if (!CronetUrlRequestContextJni.get().startNetLogToFile(this.mUrlRequestContextAdapter, this, fileName, logAll)) {
                throw new RuntimeException("Unable to start NetLog");
            }
            this.mIsLogging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNetLogToDisk(String dirPath, boolean logAll, int maxSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            if (this.mIsLogging) {
                return;
            }
            CronetUrlRequestContextJni.get().startNetLogToDisk(this.mUrlRequestContextAdapter, this, dirPath, logAll, maxSize);
            this.mIsLogging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopNetLog() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            if (!this.mIsLogging || this.mIsStoppingNetLog) {
                return;
            }
            CronetUrlRequestContextJni.get().stopNetLog(this.mUrlRequestContextAdapter, this);
            this.mIsStoppingNetLog = true;
        }
        this.mStopNetLogCompleted.block();
        this.mStopNetLogCompleted.close();
        object = this.mLock;
        synchronized (object) {
            this.mIsStoppingNetLog = false;
            this.mIsLogging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWritePropertiesForTesting() {
        Object object = this.mLock;
        synchronized (object) {
            CronetUrlRequestContextJni.get().flushWritePropertiesForTesting(this.mUrlRequestContextAdapter, this);
        }
    }

    @CalledByNative
    public void stopNetLogCompleted() {
        this.mStopNetLogCompleted.open();
    }

    @Override
    public byte[] getGlobalMetricsDeltas() {
        return CronetUrlRequestContextJni.get().getHistogramDeltas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEffectiveConnectionType() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return CronetUrlRequestContext.convertConnectionTypeToApiValue(this.mEffectiveConnectionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHttpRttMs() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mHttpRttMs != -1 ? this.mHttpRttMs : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransportRttMs() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mTransportRttMs != -1 ? this.mTransportRttMs : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDownstreamThroughputKbps() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mDownstreamThroughputKbps != -1 ? this.mDownstreamThroughputKbps : -1;
        }
    }

    @Override
    public void bindToNetwork(long networkHandle) {
        this.mNetworkHandle = networkHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void configureNetworkQualityEstimatorForTesting(boolean useLocalHostRequests, boolean useSmallerResponses, boolean disableOfflineCheck) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            CronetUrlRequestContextJni.get().configureNetworkQualityEstimatorForTesting(this.mUrlRequestContextAdapter, this, useLocalHostRequests, useSmallerResponses, disableOfflineCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRttListener(NetworkQualityRttListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mRttListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    CronetUrlRequestContextJni.get().provideRTTObservations(this.mUrlRequestContextAdapter, this, true);
                }
            }
            this.mRttListenerList.addObserver(new VersionSafeCallbacks.NetworkQualityRttListenerWrapper(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRttListener(NetworkQualityRttListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mRttListenerList.removeObserver(new VersionSafeCallbacks.NetworkQualityRttListenerWrapper(listener)) && this.mRttListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    CronetUrlRequestContextJni.get().provideRTTObservations(this.mUrlRequestContextAdapter, this, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThroughputListener(NetworkQualityThroughputListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mThroughputListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    CronetUrlRequestContextJni.get().provideThroughputObservations(this.mUrlRequestContextAdapter, this, true);
                }
            }
            this.mThroughputListenerList.addObserver(new VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThroughputListener(NetworkQualityThroughputListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mThroughputListenerList.removeObserver(new VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper(listener)) && this.mThroughputListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    CronetUrlRequestContextJni.get().provideThroughputObservations(this.mUrlRequestContextAdapter, this, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        Object object = this.mFinishedListenerLock;
        synchronized (object) {
            this.mFinishedListenerMap.put(listener, new VersionSafeCallbacks.RequestFinishedInfoListener(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        Object object = this.mFinishedListenerLock;
        synchronized (object) {
            this.mFinishedListenerMap.remove(listener);
        }
    }

    @Override
    public URLConnection openConnection(URL url) {
        return this.openConnection(url, Proxy.NO_PROXY);
    }

    @Override
    public URLConnection openConnection(URL url, Proxy proxy) {
        if (proxy.type() != Proxy.Type.DIRECT) {
            throw new UnsupportedOperationException();
        }
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return new CronetHttpURLConnection(url, this);
        }
        throw new UnsupportedOperationException("Unexpected protocol:" + protocol);
    }

    @Override
    public URLStreamHandlerFactory createURLStreamHandlerFactory() {
        return new CronetURLStreamHandlerFactory(this);
    }

    void onRequestStarted() {
        this.mActiveRequestCount.incrementAndGet();
        this.mRunningRequestCount.incrementAndGet();
    }

    void onRequestDestroyed() {
        this.mRunningRequestCount.decrementAndGet();
    }

    void onRequestFinished() {
        this.mActiveRequestCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getUrlRequestContextAdapter() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return this.mUrlRequestContextAdapter;
        }
    }

    @GuardedBy(value="mLock")
    private void checkHaveAdapter() throws IllegalStateException {
        if (!this.haveRequestContextAdapter()) {
            throw new IllegalStateException("Engine is shut down.");
        }
    }

    @GuardedBy(value="mLock")
    private boolean haveRequestContextAdapter() {
        return this.mUrlRequestContextAdapter != 0L;
    }

    private static int convertConnectionTypeToApiValue(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 0: {
                return 0;
            }
        }
        throw new RuntimeException("Internal Error: Illegal EffectiveConnectionType value " + type);
    }

    @CalledByNative
    private void initNetworkThread() {
        this.mNetworkThread = Thread.currentThread();
        this.mInitCompleted.open();
        Thread.currentThread().setName("ChromiumNet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onEffectiveConnectionTypeChanged(int effectiveConnectionType) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            this.mEffectiveConnectionType = effectiveConnectionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onRTTOrThroughputEstimatesComputed(int httpRttMs, int transportRttMs, int downstreamThroughputKbps) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            this.mHttpRttMs = httpRttMs;
            this.mTransportRttMs = transportRttMs;
            this.mDownstreamThroughputKbps = downstreamThroughputKbps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onRttObservation(final int rttMs, final long whenMs, final int source) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            for (final VersionSafeCallbacks.NetworkQualityRttListenerWrapper listener : this.mRttListenerList) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        listener.onRttObservation(rttMs, whenMs, source);
                    }
                };
                CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task, "onRttObservation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onThroughputObservation(final int throughputKbps, final long whenMs, final int source) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            for (final VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper listener : this.mThroughputListenerList) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        listener.onThroughputObservation(throughputKbps, whenMs, source);
                    }
                };
                CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task, "onThroughputObservation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportRequestFinished(final RequestFinishedInfo requestInfo, RefCountDelegate inflightCallbackCount, VersionSafeCallbacks.RequestFinishedInfoListener extraRequestFinishedInfoListener) {
        ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener> currentListeners = new ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener>();
        Iterator iterator = this.mFinishedListenerLock;
        synchronized (iterator) {
            currentListeners.addAll(this.mFinishedListenerMap.values());
        }
        if (extraRequestFinishedInfoListener != null) {
            currentListeners.add(extraRequestFinishedInfoListener);
        }
        for (final VersionSafeCallbacks.RequestFinishedInfoListener listener : currentListeners) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    listener.onRequestFinished(requestInfo);
                }
            };
            CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task, inflightCallbackCount, "reportRequestFinished");
        }
    }

    private static void postObservationTaskToExecutor(Executor executor, Runnable task, RefCountDelegate inflightCallbackCount, String name) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#postObservationTaskToExecutor " + name);){
            if (inflightCallbackCount != null) {
                inflightCallbackCount.increment();
            }
            try {
                executor.execute(() -> {
                    try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequestContext#postObservationTaskToExecutor " + name + " running callback");){
                        try {
                            task.run();
                        }
                        catch (Exception e) {
                            Log.e(LOG_TAG, "Exception thrown from observation task", e);
                        }
                        finally {
                            if (inflightCallbackCount != null) {
                                inflightCallbackCount.decrement();
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException failException) {
                if (inflightCallbackCount != null) {
                    inflightCallbackCount.decrement();
                }
                Log.e(LOG_TAG, "Exception posting task to executor", failException);
            }
        }
    }

    private static void postObservationTaskToExecutor(Executor executor, Runnable task, String name) {
        CronetUrlRequestContext.postObservationTaskToExecutor(executor, task, null, name);
    }

    public boolean isNetworkThread(Thread thread) {
        return thread == this.mNetworkThread;
    }

    static interface Natives {
        public long createRequestContextConfig(byte[] var1);

        public void addQuicHint(long var1, String var3, int var4, int var5);

        public void addPkp(long var1, String var3, byte[][] var4, boolean var5, long var6);

        public long createRequestContextAdapter(long var1);

        public byte[] getHistogramDeltas();

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void destroy(long var1, CronetUrlRequestContext var3);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public boolean startNetLogToFile(long var1, CronetUrlRequestContext var3, String var4, boolean var5);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void startNetLogToDisk(long var1, CronetUrlRequestContext var3, String var4, boolean var5, int var6);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void stopNetLog(long var1, CronetUrlRequestContext var3);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void flushWritePropertiesForTesting(long var1, CronetUrlRequestContext var3);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void initRequestContextOnInitThread(long var1, CronetUrlRequestContext var3);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void configureNetworkQualityEstimatorForTesting(long var1, CronetUrlRequestContext var3, boolean var4, boolean var5, boolean var6);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void provideRTTObservations(long var1, CronetUrlRequestContext var3, boolean var4);

        @NativeClassQualifiedName(value="CronetContextAdapter")
        public void provideThroughputObservations(long var1, CronetUrlRequestContext var3, boolean var4);
    }

    private static class CronetInitializedInfoLogger {
        private final CronetLogger mCronetLogger;
        private final long mStartUptimeMillis;
        private final CronetLogger.CronetInitializedInfo mCronetInitializedInfo = new CronetLogger.CronetInitializedInfo();

        public CronetInitializedInfoLogger(CronetLogger cronetLogger, long cronetInitializationRef, long startUptimeMillis, CronetLogger.CronetSource source) {
            this.mCronetLogger = cronetLogger;
            this.mCronetInitializedInfo.cronetInitializationRef = cronetInitializationRef;
            this.mCronetInitializedInfo.source = source;
            this.mCronetInitializedInfo.cronetImplVersion = ImplVersion.getCronetVersion();
            this.mStartUptimeMillis = startUptimeMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUserThreadDone() {
            int elapsedTime = this.getElapsedTime();
            CronetLogger.CronetInitializedInfo cronetInitializedInfo = this.mCronetInitializedInfo;
            synchronized (cronetInitializedInfo) {
                assert (this.mCronetInitializedInfo.engineCreationLatencyMillis < 0);
                this.mCronetInitializedInfo.engineCreationLatencyMillis = elapsedTime;
                this.maybeLog();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInitThreadDone(CronetLibraryLoader.CronetInitializedInfo libraryLoaderInfo) {
            this.mCronetInitializedInfo.httpFlagsLatencyMillis = libraryLoaderInfo.httpFlagsLatencyMillis;
            this.mCronetInitializedInfo.httpFlagsSuccessful = libraryLoaderInfo.httpFlagsSuccessful;
            this.mCronetInitializedInfo.httpFlagsNames = libraryLoaderInfo.httpFlagsNames;
            this.mCronetInitializedInfo.httpFlagsValues = libraryLoaderInfo.httpFlagsValues;
            int elapsedTime = this.getElapsedTime();
            CronetLogger.CronetInitializedInfo cronetInitializedInfo = this.mCronetInitializedInfo;
            synchronized (cronetInitializedInfo) {
                assert (this.mCronetInitializedInfo.engineAsyncLatencyMillis < 0);
                this.mCronetInitializedInfo.engineAsyncLatencyMillis = elapsedTime;
                this.maybeLog();
            }
        }

        private void maybeLog() {
            if (this.mCronetInitializedInfo.engineCreationLatencyMillis < 0 || this.mCronetInitializedInfo.engineAsyncLatencyMillis < 0) {
                return;
            }
            this.mCronetLogger.logCronetInitializedInfo(this.mCronetInitializedInfo);
        }

        private int getElapsedTime() {
            int elapsedTime = (int)(SystemClock.uptimeMillis() - this.mStartUptimeMillis);
            assert (elapsedTime >= 0);
            return elapsedTime;
        }
    }
}

