/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.content.Context;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.impl.CronetManifest;
import android.net.connectivity.org.chromium.net.impl.NoOpLogger;
import android.net.connectivity.org.chromium.net.telemetry.CronetLoggerImpl;
import android.os._Original_Build;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;

public class CronetLoggerFactory {
    private static final String TAG = CronetLoggerFactory.class.getSimpleName();
    private static final int SAMPLE_RATE_PER_SECOND = 1;
    private static CronetLogger sLogger;

    private CronetLoggerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CronetLogger createLogger(Context ctx, CronetLogger.CronetSource source) {
        Class<CronetLoggerFactory> clazz = CronetLoggerFactory.class;
        synchronized (CronetLoggerFactory.class) {
            if (sLogger == null && _Original_Build.VERSION.SDK_INT >= 30 && CronetManifest.isAppOptedInForTelemetry(ctx, source)) {
                try {
                    sLogger = new CronetLoggerImpl(1);
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception creating an instance of CronetLoggerImpl", e);
                }
            }
            if (sLogger == null) {
                sLogger = new NoOpLogger();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoggerForTesting(@Nullable CronetLogger testingLogger) {
        Class<CronetLoggerFactory> clazz = CronetLoggerFactory.class;
        synchronized (CronetLoggerFactory.class) {
            sLogger = testingLogger;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static class SwapLoggerForTesting
    implements AutoCloseable {
        public SwapLoggerForTesting(CronetLogger testLogger) {
            CronetLoggerFactory.setLoggerForTesting(testLogger);
        }

        @Override
        public void close() {
            CronetLoggerFactory.setLoggerForTesting(null);
        }
    }
}

