/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.annotation.SuppressLint;
import android.net.connectivity.org.chromium.net.BidirectionalStream;
import android.net.connectivity.org.chromium.net.ExperimentalBidirectionalStream;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBase;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class BidirectionalStreamBuilderImpl
extends ExperimentalBidirectionalStream.Builder {
    private final CronetEngineBase mCronetEngine;
    private final String mUrl;
    private final BidirectionalStream.Callback mCallback;
    private final Executor mExecutor;
    private final ArrayList<Map.Entry<String, String>> mRequestHeaders = new ArrayList();
    private String mHttpMethod = "POST";
    private int mPriority = 3;
    private boolean mDelayRequestHeadersUntilFirstFlush;
    private Collection<Object> mRequestAnnotations;
    private boolean mTrafficStatsTagSet;
    private int mTrafficStatsTag;
    private boolean mTrafficStatsUidSet;
    private int mTrafficStatsUid;
    private long mNetworkHandle = -1L;

    public BidirectionalStreamBuilderImpl(String url, BidirectionalStream.Callback callback, Executor executor, CronetEngineBase cronetEngine) {
        this.mUrl = Objects.requireNonNull(url, "URL is required.");
        this.mCallback = Objects.requireNonNull(callback, "Callback is required.");
        this.mExecutor = Objects.requireNonNull(executor, "Executor is required.");
        this.mCronetEngine = Objects.requireNonNull(cronetEngine, "CronetEngine is required.");
    }

    @Override
    public BidirectionalStreamBuilderImpl setHttpMethod(String method) {
        this.mHttpMethod = Objects.requireNonNull(method, "Method is required.");
        return this;
    }

    @Override
    public BidirectionalStreamBuilderImpl addHeader(String header, String value) {
        Objects.requireNonNull(header, "Invalid header name.");
        Objects.requireNonNull(value, "Invalid header value.");
        this.mRequestHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
        return this;
    }

    @Override
    public BidirectionalStreamBuilderImpl setPriority(int priority) {
        this.mPriority = priority;
        return this;
    }

    @Override
    public BidirectionalStreamBuilderImpl delayRequestHeadersUntilFirstFlush(boolean delayRequestHeadersUntilFirstFlush) {
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilFirstFlush;
        return this;
    }

    @Override
    public ExperimentalBidirectionalStream.Builder addRequestAnnotation(Object annotation) {
        Objects.requireNonNull(annotation, "Invalid metrics annotation.");
        if (this.mRequestAnnotations == null) {
            this.mRequestAnnotations = new ArrayList<Object>();
        }
        this.mRequestAnnotations.add(annotation);
        return this;
    }

    @Override
    public ExperimentalBidirectionalStream.Builder setTrafficStatsTag(int tag) {
        this.mTrafficStatsTagSet = true;
        this.mTrafficStatsTag = tag;
        return this;
    }

    @Override
    public ExperimentalBidirectionalStream.Builder setTrafficStatsUid(int uid) {
        this.mTrafficStatsUidSet = true;
        this.mTrafficStatsUid = uid;
        return this;
    }

    @Override
    public ExperimentalBidirectionalStream.Builder bindToNetwork(long networkHandle) {
        this.mNetworkHandle = networkHandle;
        return this;
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public ExperimentalBidirectionalStream build() {
        return this.mCronetEngine.createBidirectionalStream(this.mUrl, this.mCallback, this.mExecutor, this.mHttpMethod, this.mRequestHeaders, this.mPriority, this.mDelayRequestHeadersUntilFirstFlush, this.mRequestAnnotations, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mNetworkHandle);
    }
}

