/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.metrics;

import android.net.connectivity.org.chromium.base.Callback;
import android.net.connectivity.org.chromium.base.TimeUtils;
import android.net.connectivity.org.chromium.base.metrics.HistogramBucket;
import android.net.connectivity.org.chromium.base.metrics.NativeUmaRecorderJni;
import android.net.connectivity.org.chromium.base.metrics.UmaRecorder;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.net.connectivity.org.jni_zero.JniType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JNINamespace(value="base::android")
@NullMarked
class NativeUmaRecorder
implements UmaRecorder {
    private final Map<String, Long> mNativeHints = Collections.synchronizedMap(new HashMap());
    private @Nullable Map<Callback<String>, Long> mUserActionTestingCallbackNativePtrs;

    NativeUmaRecorder() {
    }

    @Override
    public void recordBooleanHistogram(String name, boolean sample) {
        long oldHint = this.getNativeHint(name);
        long newHint = NativeUmaRecorderJni.get().recordBooleanHistogram(name, oldHint, sample);
        this.maybeUpdateNativeHint(name, oldHint, newHint);
    }

    @Override
    public void recordExponentialHistogram(String name, int sample, int min, int max, int numBuckets) {
        long oldHint = this.getNativeHint(name);
        long newHint = NativeUmaRecorderJni.get().recordExponentialHistogram(name, oldHint, sample, min, max, numBuckets);
        this.maybeUpdateNativeHint(name, oldHint, newHint);
    }

    @Override
    public void recordLinearHistogram(String name, int sample, int min, int max, int numBuckets) {
        long oldHint = this.getNativeHint(name);
        long newHint = NativeUmaRecorderJni.get().recordLinearHistogram(name, oldHint, sample, min, max, numBuckets);
        this.maybeUpdateNativeHint(name, oldHint, newHint);
    }

    @Override
    public void recordSparseHistogram(String name, int sample) {
        long oldHint = this.getNativeHint(name);
        long newHint = NativeUmaRecorderJni.get().recordSparseHistogram(name, oldHint, sample);
        this.maybeUpdateNativeHint(name, oldHint, newHint);
    }

    @Override
    public void recordUserAction(String name, long elapsedRealtimeMillis) {
        long millisSinceEvent = TimeUtils.elapsedRealtimeMillis() - elapsedRealtimeMillis;
        NativeUmaRecorderJni.get().recordUserAction(name, millisSinceEvent);
    }

    @Override
    public int getHistogramValueCountForTesting(String name, int sample) {
        return NativeUmaRecorderJni.get().getHistogramValueCountForTesting(name, sample, 0L);
    }

    @Override
    public int getHistogramTotalCountForTesting(String name) {
        return NativeUmaRecorderJni.get().getHistogramTotalCountForTesting(name, 0L);
    }

    @Override
    public List<HistogramBucket> getHistogramSamplesForTesting(String name) {
        long[] samplesArray = NativeUmaRecorderJni.get().getHistogramSamplesForTesting(name);
        ArrayList<HistogramBucket> buckets = new ArrayList<HistogramBucket>(samplesArray.length);
        for (int i = 0; i < samplesArray.length; i += 3) {
            int min = (int)samplesArray[i];
            long max = samplesArray[i + 1];
            int count = (int)samplesArray[i + 2];
            buckets.add(new HistogramBucket(min, max, count));
        }
        return buckets;
    }

    @Override
    public void addUserActionCallbackForTesting(Callback<String> callback) {
        long ptr = NativeUmaRecorderJni.get().addActionCallbackForTesting(callback);
        if (this.mUserActionTestingCallbackNativePtrs == null) {
            this.mUserActionTestingCallbackNativePtrs = Collections.synchronizedMap(new HashMap());
        }
        this.mUserActionTestingCallbackNativePtrs.put(callback, ptr);
    }

    @Override
    public void removeUserActionCallbackForTesting(Callback<String> callback) {
        if (this.mUserActionTestingCallbackNativePtrs == null) {
            assert (false) : "Attempting to remove a user action callback without previously registering any.";
            return;
        }
        Long ptr = this.mUserActionTestingCallbackNativePtrs.remove(callback);
        if (ptr == null) {
            assert (false) : "Attempting to remove a user action callback that was never previously registered.";
            return;
        }
        NativeUmaRecorderJni.get().removeActionCallbackForTesting(ptr);
    }

    private long getNativeHint(String name) {
        Long hint = this.mNativeHints.get(name);
        return hint == null ? 0L : hint;
    }

    private void maybeUpdateNativeHint(String name, long oldHint, long newHint) {
        if (oldHint != newHint) {
            this.mNativeHints.put(name, newHint);
        }
    }

    public static interface Natives {
        public long recordBooleanHistogram(@JniType(value="std::string") String var1, long var2, boolean var4);

        public long recordExponentialHistogram(@JniType(value="std::string") String var1, long var2, int var4, int var5, int var6, int var7);

        public long recordLinearHistogram(@JniType(value="std::string") String var1, long var2, int var4, int var5, int var6, int var7);

        public long recordSparseHistogram(@JniType(value="std::string") String var1, long var2, int var4);

        public void recordUserAction(@JniType(value="std::string") String var1, long var2);

        public int getHistogramValueCountForTesting(@JniType(value="std::string") String var1, int var2, long var3);

        public int getHistogramTotalCountForTesting(@JniType(value="std::string") String var1, long var2);

        public long[] getHistogramSamplesForTesting(@JniType(value="std::string") String var1);

        public long createHistogramSnapshotForTesting();

        public void destroyHistogramSnapshotForTesting(long var1);

        public long addActionCallbackForTesting(Callback<String> var1);

        public void removeActionCallbackForTesting(long var1);
    }
}

