/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.connectivity.org.chromium.base.BuildInfo;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.os._Original_Build;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

@NullMarked
public class PackageUtils {
    private static final String TAG = "PackageUtils";
    private static final char[] HEX_CHAR_LOOKUP = "0123456789ABCDEF".toCharArray();

    public static @Nullable PackageInfo getPackageInfo(String packageName, int flags) {
        PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
        try {
            return pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static int getPackageVersion(String packageName) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(packageName, 0);
        if (packageInfo != null) {
            return packageInfo.versionCode;
        }
        return -1;
    }

    public static boolean isPackageInstalled(String packageName) {
        return PackageUtils.getPackageInfo(packageName, 0) != null;
    }

    public static PackageInfo getApplicationPackageInfo(int flags) {
        BuildInfo bi = BuildInfo.getInstance();
        if (!bi.packageName.equals(bi.hostPackageName)) {
            PackageUtils.maybeWorkAroundWebViewPackageVisibility();
        }
        PackageInfo ret = PackageUtils.getPackageInfo(bi.packageName, flags);
        assert (ret != null);
        return ret;
    }

    public static long packageVersionCode(PackageInfo pi) {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return pi.getLongVersionCode();
        }
        return pi.versionCode;
    }

    public static void maybeWorkAroundWebViewPackageVisibility() {
        if (_Original_Build.VERSION.SDK_INT < 30 || _Original_Build.VERSION.SDK_INT >= 34) {
            return;
        }
        try {
            Class<?> wvus = Class.forName("android.webkit.WebViewUpdateService");
            Method getWebViewPackageName = wvus.getDeclaredMethod("getCurrentWebViewPackageName", new Class[0]);
            getWebViewPackageName.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.w(TAG, "maybeWorkAroundWebViewPackageVisibility failed", e);
        }
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static @Nullable List<String> getCertificateSHA256FingerprintForPackage(String packageName) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(packageName, 64);
        if (packageInfo == null) {
            return null;
        }
        ArrayList<String> fingerprints = new ArrayList<String>(packageInfo.signatures.length);
        for (Signature signature : packageInfo.signatures) {
            ByteArrayInputStream input = new ByteArrayInputStream(signature.toByteArray());
            String hexString = null;
            try {
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(input);
                hexString = PackageUtils.byteArrayToHexString(MessageDigest.getInstance("SHA256").digest(certificate.getEncoded()));
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                Log.w(TAG, "Exception", e);
                return null;
            }
            fingerprints.add(hexString);
        }
        return fingerprints;
    }

    @VisibleForTesting
    static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(byteArray.length * 3 - 1);
        for (int i = 0; i < byteArray.length; ++i) {
            hexString.append(HEX_CHAR_LOOKUP[(byteArray[i] & 0xF0) >>> 4]);
            hexString.append(HEX_CHAR_LOOKUP[byteArray[i] & 0xF]);
            if (i >= byteArray.length - 1) continue;
            hexString.append(':');
        }
        return hexString.toString();
    }

    private PackageUtils() {
    }
}

