/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.DeviceInfoJni;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.PackageUtils;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.CalledByNativeForTesting;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.net.connectivity.org.jni_zero.JniType;
import android.os._Original_Build;
import com.android.layoutlib.androidx.annotation.GuardedBy;

@JNINamespace(value="base::android::device_info")
@NullMarked
public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private static @Nullable String sGmsVersionCodeForTesting;
    private static boolean sInitialized;
    private String mGmsVersionCode;
    private final boolean mIsTv;
    private final boolean mIsAutomotive;
    private final boolean mIsFoldable;
    private final boolean mIsDesktop;
    private final int mVulkanDeqpLevel;
    @GuardedBy(value="CREATION_LOCK")
    private static @Nullable DeviceInfo sInstance;
    private static final Object CREATION_LOCK;

    @CalledByNative
    private static void nativeReadyForFields() {
        DeviceInfoJni.get().fillFields(DeviceInfo.getGmsVersionCode(), DeviceInfo.isTV(), DeviceInfo.isAutomotive(), DeviceInfo.isFoldable(), DeviceInfo.isDesktop(), DeviceInfo.getVulkanDeqpLevel());
    }

    public static String getGmsVersionCode() {
        return sGmsVersionCodeForTesting == null ? DeviceInfo.getInstance().mGmsVersionCode : sGmsVersionCodeForTesting;
    }

    @CalledByNativeForTesting
    public static void setGmsVersionCodeForTest(@JniType(value="std::string") String gmsVersionCode) {
        sGmsVersionCodeForTesting = gmsVersionCode;
    }

    public static boolean isTV() {
        return DeviceInfo.getInstance().mIsTv;
    }

    public static boolean isAutomotive() {
        return DeviceInfo.getInstance().mIsAutomotive;
    }

    public static boolean isFoldable() {
        return DeviceInfo.getInstance().mIsFoldable;
    }

    public static boolean isDesktop() {
        return DeviceInfo.getInstance().mIsDesktop;
    }

    public static int getVulkanDeqpLevel() {
        return DeviceInfo.getInstance().mVulkanDeqpLevel;
    }

    public static boolean isInitializedForTesting() {
        return sInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeviceInfo getInstance() {
        if (BuildConfig.IS_FOR_TEST) {
            return new DeviceInfo();
        }
        Object object = CREATION_LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new DeviceInfo();
            }
            return sInstance;
        }
    }

    public static long packageVersionCode(PackageInfo pi) {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return pi.getLongVersionCode();
        }
        return pi.versionCode;
    }

    private DeviceInfo() {
        FeatureInfo[] features;
        boolean isAutomotive;
        sInitialized = true;
        PackageInfo gmsPackageInfo = PackageUtils.getPackageInfo("com.google.android.gms", 0);
        this.mGmsVersionCode = gmsPackageInfo != null ? String.valueOf(DeviceInfo.packageVersionCode(gmsPackageInfo)) : "gms versionCode not available.";
        Context appContext = ContextUtils.getApplicationContext();
        PackageManager pm = appContext.getPackageManager();
        UiModeManager uiModeManager = (UiModeManager)appContext.getSystemService("uimode");
        this.mIsTv = uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
        try {
            isAutomotive = pm.hasSystemFeature("android.hardware.type.automotive");
        }
        catch (SecurityException e) {
            Log.e(TAG, "Unable to query for Automotive system feature", e);
            isAutomotive = false;
        }
        this.mIsAutomotive = isAutomotive;
        this.mIsFoldable = _Original_Build.VERSION.SDK_INT >= 30 && pm.hasSystemFeature("android.hardware.sensor.hinge_angle");
        this.mIsDesktop = pm.hasSystemFeature("android.hardware.type.pc");
        int vulkanLevel = 0;
        if (_Original_Build.VERSION.SDK_INT >= 33 && (features = pm.getSystemAvailableFeatures()) != null) {
            for (FeatureInfo feature : features) {
                if (!"android.software.vulkan.deqp.level".equals(feature.name)) continue;
                vulkanLevel = feature.version;
                break;
            }
        }
        this.mVulkanDeqpLevel = vulkanLevel;
    }

    static {
        CREATION_LOCK = new Object();
    }

    static interface Natives {
        public void fillFields(String var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6);
    }
}

