/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.QosFilter;
import android.net.QosSocketInfo;
import android.net.connectivity.android.net.QosSocketFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.Objects;

public class QosFilterParcelable
implements Parcelable {
    private static final String LOG_TAG = QosFilterParcelable.class.getSimpleName();
    private static final int NO_FILTER_PRESENT = 0;
    private static final int QOS_SOCKET_FILTER = 1;
    private final QosFilter mQosFilter;
    public static final Parcelable.Creator<QosFilterParcelable> CREATOR = new Parcelable.Creator<QosFilterParcelable>(){

        @Override
        public QosFilterParcelable createFromParcel(Parcel in) {
            return new QosFilterParcelable(in);
        }

        public QosFilterParcelable[] newArray(int size) {
            return new QosFilterParcelable[size];
        }
    };

    @Nullable
    public QosFilter getQosFilter() {
        return this.mQosFilter;
    }

    public QosFilterParcelable(@NonNull QosFilter qosFilter) {
        Objects.requireNonNull(qosFilter, "qosFilter must be non-null");
        this.mQosFilter = qosFilter;
    }

    private QosFilterParcelable(Parcel in) {
        int filterParcelType = in.readInt();
        switch (filterParcelType) {
            case 1: {
                this.mQosFilter = new QosSocketFilter(QosSocketInfo.CREATOR.createFromParcel(in));
                break;
            }
            default: {
                this.mQosFilter = null;
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mQosFilter instanceof QosSocketFilter) {
            dest.writeInt(1);
            QosSocketFilter qosSocketFilter = (QosSocketFilter)this.mQosFilter;
            qosSocketFilter.getQosSocketInfo().writeToParcelWithoutFd(dest, 0);
            return;
        }
        dest.writeInt(0);
        Log.e(LOG_TAG, "Parceling failed, unknown type of filter present: " + this.mQosFilter);
    }
}

