/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.NetworkRequest;
import android.net.connectivity.android.net.MulticastRoutingConfig;
import android.os.Parcel;
import android.os.Parcelable;

public class LocalNetworkConfig
implements Parcelable {
    @Nullable
    private final NetworkRequest mUpstreamSelector;
    @NonNull
    private final MulticastRoutingConfig mUpstreamMulticastRoutingConfig;
    @NonNull
    private final MulticastRoutingConfig mDownstreamMulticastRoutingConfig;
    @NonNull
    public static final Parcelable.Creator<LocalNetworkConfig> CREATOR = new Parcelable.Creator<LocalNetworkConfig>(){

        @Override
        public LocalNetworkConfig createFromParcel(Parcel in) {
            NetworkRequest upstreamSelector = (NetworkRequest)in.readParcelable(null);
            MulticastRoutingConfig upstreamConfig = (MulticastRoutingConfig)in.readParcelable(null);
            MulticastRoutingConfig downstreamConfig = (MulticastRoutingConfig)in.readParcelable(null);
            return new LocalNetworkConfig(upstreamSelector, upstreamConfig, downstreamConfig);
        }

        public LocalNetworkConfig[] newArray(int size) {
            return new LocalNetworkConfig[size];
        }
    };

    private LocalNetworkConfig(@Nullable NetworkRequest upstreamSelector, @Nullable MulticastRoutingConfig upstreamConfig, @Nullable MulticastRoutingConfig downstreamConfig) {
        this.mUpstreamSelector = upstreamSelector;
        this.mUpstreamMulticastRoutingConfig = null != upstreamConfig ? upstreamConfig : MulticastRoutingConfig.CONFIG_FORWARD_NONE;
        this.mDownstreamMulticastRoutingConfig = null != downstreamConfig ? downstreamConfig : MulticastRoutingConfig.CONFIG_FORWARD_NONE;
    }

    @Nullable
    public NetworkRequest getUpstreamSelector() {
        return this.mUpstreamSelector;
    }

    @NonNull
    public MulticastRoutingConfig getUpstreamMulticastRoutingConfig() {
        return this.mUpstreamMulticastRoutingConfig;
    }

    @NonNull
    public MulticastRoutingConfig getDownstreamMulticastRoutingConfig() {
        return this.mDownstreamMulticastRoutingConfig;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mUpstreamSelector, flags);
        dest.writeParcelable(this.mUpstreamMulticastRoutingConfig, flags);
        dest.writeParcelable(this.mDownstreamMulticastRoutingConfig, flags);
    }

    public String toString() {
        return "LocalNetworkConfig{UpstreamSelector=" + this.mUpstreamSelector + ", UpstreamMulticastConfig=" + this.mUpstreamMulticastRoutingConfig + ", DownstreamMulticastConfig=" + this.mDownstreamMulticastRoutingConfig + '}';
    }

    public static class Builder {
        @Nullable
        private NetworkRequest mUpstreamSelector;
        @Nullable
        private MulticastRoutingConfig mUpstreamMulticastRoutingConfig;
        @Nullable
        private MulticastRoutingConfig mDownstreamMulticastRoutingConfig;

        @NonNull
        public Builder setUpstreamSelector(@Nullable NetworkRequest upstreamSelector) {
            this.mUpstreamSelector = upstreamSelector;
            return this;
        }

        @NonNull
        public Builder setUpstreamMulticastRoutingConfig(@Nullable MulticastRoutingConfig cfg) {
            this.mUpstreamMulticastRoutingConfig = cfg;
            return this;
        }

        @NonNull
        public Builder setDownstreamMulticastRoutingConfig(@Nullable MulticastRoutingConfig cfg) {
            this.mDownstreamMulticastRoutingConfig = cfg;
            return this;
        }

        @NonNull
        public LocalNetworkConfig build() {
            return new LocalNetworkConfig(this.mUpstreamSelector, this.mUpstreamMulticastRoutingConfig, this.mDownstreamMulticastRoutingConfig);
        }
    }
}

