/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.net.connectivity.android.net.BpfNetMapsConstants;
import android.net.connectivity.android.net.UidOwnerValue;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.net.connectivity.com.android.net.module.util.IBpfMap;
import android.net.connectivity.com.android.net.module.util.Struct;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Pair;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.StringJoiner;

@RequiresApi(value=33)
public class BpfNetMapsUtils {
    private static final long sMaskDropIfSet;
    private static final long sMaskDropIfUnset;

    private BpfNetMapsUtils() {
    }

    public static long getMatchByFirewallChain(int chain) {
        switch (chain) {
            case 1: {
                return 4L;
            }
            case 2: {
                return 8L;
            }
            case 3: {
                return 16L;
            }
            case 4: {
                return 32L;
            }
            case 6: {
                return 4096L;
            }
            case 5: {
                return 64L;
            }
            case 7: {
                return 512L;
            }
            case 8: {
                return 1024L;
            }
            case 9: {
                return 2048L;
            }
            case 10: {
                return 1L;
            }
            case 11: {
                return 2L;
            }
            case 12: {
                return 8192L;
            }
        }
        throw new ServiceSpecificException(OsConstants.EINVAL, "Invalid firewall chain: " + chain);
    }

    public static boolean isFirewallAllowList(int chain) {
        if (BpfNetMapsConstants.ALLOW_CHAINS.contains(chain) || BpfNetMapsConstants.METERED_ALLOW_CHAINS.contains(chain)) {
            return true;
        }
        if (BpfNetMapsConstants.DENY_CHAINS.contains(chain) || BpfNetMapsConstants.METERED_DENY_CHAINS.contains(chain)) {
            return false;
        }
        throw new ServiceSpecificException(OsConstants.EINVAL, "Invalid firewall chain: " + chain);
    }

    public static String matchToString(long matchMask) {
        if (matchMask == 0L) {
            return "NO_MATCH";
        }
        StringJoiner sj = new StringJoiner(" ");
        for (Pair<Long, String> match : BpfNetMapsConstants.MATCH_LIST) {
            long matchFlag = (Long)match.first;
            String matchName = (String)match.second;
            if ((matchMask & matchFlag) == 0L) continue;
            sj.add(matchName);
            matchMask &= matchFlag ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (matchMask != 0L) {
            sj.add("UNKNOWN_MATCH(" + matchMask + ")");
        }
        return ((Object)sj).toString();
    }

    public static void throwIfPreT(String msg) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException(msg);
        }
    }

    public static boolean isChainEnabled(IBpfMap<Struct.S32, Struct.U32> configurationMap, int chain) {
        BpfNetMapsUtils.throwIfPreT("isChainEnabled is not available on pre-T devices");
        long match = BpfNetMapsUtils.getMatchByFirewallChain(chain);
        try {
            Struct.U32 config = configurationMap.getValue(BpfNetMapsConstants.UID_RULES_CONFIGURATION_KEY);
            return (config.val & match) != 0L;
        }
        catch (ErrnoException e) {
            throw new ServiceSpecificException(e.errno, "Unable to get firewall chain status: " + Os.strerror(e.errno));
        }
    }

    public static int getUidRule(IBpfMap<Struct.S32, UidOwnerValue> uidOwnerMap, int chain, int uid) {
        BpfNetMapsUtils.throwIfPreT("getUidRule is not available on pre-T devices");
        long match = BpfNetMapsUtils.getMatchByFirewallChain(chain);
        boolean isAllowList = BpfNetMapsUtils.isFirewallAllowList(chain);
        try {
            UidOwnerValue uidMatch = uidOwnerMap.getValue(new Struct.S32(uid));
            boolean isMatchEnabled = uidMatch != null && (uidMatch.rule & match) != 0L;
            return isMatchEnabled == isAllowList ? 1 : 2;
        }
        catch (ErrnoException e) {
            throw new ServiceSpecificException(e.errno, "Unable to get uid rule status: " + Os.strerror(e.errno));
        }
    }

    public static int getUidNetworkingBlockedReasons(int uid, IBpfMap<Struct.S32, Struct.U32> configurationMap, IBpfMap<Struct.S32, UidOwnerValue> uidOwnerMap, IBpfMap<Struct.S32, Struct.U8> dataSaverEnabledMap) {
        long uidMatch;
        long uidRuleConfig;
        if (UserHandle.getAppId(uid) < 10000) {
            return 0;
        }
        try {
            uidRuleConfig = configurationMap.getValue((Struct.S32)BpfNetMapsConstants.UID_RULES_CONFIGURATION_KEY).val;
            UidOwnerValue value = uidOwnerMap.getValue(new Struct.S32(uid));
            uidMatch = value != null ? value.rule : 0L;
        }
        catch (ErrnoException e) {
            throw new ServiceSpecificException(e.errno, "Unable to get firewall chain status: " + Os.strerror(e.errno));
        }
        long blockingMatches = uidRuleConfig & (uidMatch ^ 0xFFFFFFFFFFFFFFFFL) & sMaskDropIfUnset | uidRuleConfig & uidMatch & sMaskDropIfSet;
        int blockedReasons = 0;
        if ((blockingMatches & 0x10L) != 0L) {
            blockedReasons |= 1;
        }
        if ((blockingMatches & 4L) != 0L) {
            blockedReasons |= 2;
        }
        if ((blockingMatches & 8L) != 0L) {
            blockedReasons |= 4;
        }
        if ((blockingMatches & 0x20L) != 0L) {
            blockedReasons |= 8;
        }
        if ((blockingMatches & 0x40L) != 0L) {
            blockedReasons |= 0x20;
        }
        if ((blockingMatches & 0x1000L) != 0L) {
            blockedReasons |= 0x40;
        }
        if ((blockingMatches & 0xE00L) != 0L) {
            blockedReasons |= 0x80;
        }
        if ((uidMatch & 2L) != 0L) {
            blockedReasons |= 0x20000;
        }
        if ((uidMatch & 0x2000L) != 0L) {
            blockedReasons |= 0x40000;
        }
        if ((uidMatch & 1L) == 0L && BpfNetMapsUtils.getDataSaverEnabled(dataSaverEnabledMap)) {
            blockedReasons |= 0x10000;
        }
        return blockedReasons;
    }

    public static boolean isUidNetworkingBlocked(int uid, boolean isNetworkMetered, IBpfMap<Struct.S32, Struct.U32> configurationMap, IBpfMap<Struct.S32, UidOwnerValue> uidOwnerMap, IBpfMap<Struct.S32, Struct.U8> dataSaverEnabledMap) {
        BpfNetMapsUtils.throwIfPreT("isUidBlockedByFirewallChains is not available on pre-T devices");
        int blockedReasons = BpfNetMapsUtils.getUidNetworkingBlockedReasons(uid, configurationMap, uidOwnerMap, dataSaverEnabledMap);
        if (isNetworkMetered) {
            return blockedReasons != 0;
        }
        return (blockedReasons & 0xFFFF) != 0;
    }

    public static boolean getDataSaverEnabled(IBpfMap<Struct.S32, Struct.U8> dataSaverEnabledMap) {
        BpfNetMapsUtils.throwIfPreT("getDataSaverEnabled is not available on pre-T devices");
        try {
            return dataSaverEnabledMap.getValue((Struct.S32)BpfNetMapsConstants.DATA_SAVER_ENABLED_KEY).val == 1;
        }
        catch (ErrnoException e) {
            throw new ServiceSpecificException(e.errno, "Unable to get data saver: " + Os.strerror(e.errno));
        }
    }

    static {
        long match;
        long maskDropIfSet = 0L;
        long maskDropIfUnset = 0L;
        for (int chain : BpfNetMapsConstants.ALLOW_CHAINS) {
            match = BpfNetMapsUtils.getMatchByFirewallChain(chain);
            maskDropIfUnset |= match;
        }
        for (int chain : BpfNetMapsConstants.DENY_CHAINS) {
            match = BpfNetMapsUtils.getMatchByFirewallChain(chain);
            maskDropIfSet |= match;
        }
        sMaskDropIfSet = maskDropIfSet;
        sMaskDropIfUnset = maskDropIfUnset;
    }
}

