/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.TestNetworkInterface;
import android.net.connectivity.android.net.ITestNetworkManager;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class TestNetworkManager {
    public static final String TEST_TUN_PREFIX = "testtun";
    public static final String TEST_TAP_PREFIX = "testtap";
    public static final String CLAT_INTERFACE_PREFIX = "v4-";
    @NonNull
    private static final String TAG = TestNetworkManager.class.getSimpleName();
    @NonNull
    private final ITestNetworkManager mService;
    private static final boolean TAP = false;
    private static final boolean TUN = true;
    private static final boolean BRING_UP = true;
    private static final boolean CARRIER_UP = true;
    private static final boolean USE_IPV6_PROV_DELAY = false;
    private static final LinkAddress[] NO_ADDRS = new LinkAddress[0];

    public TestNetworkManager(@NonNull ITestNetworkManager service) {
        this.mService = Objects.requireNonNull(service, "missing ITestNetworkManager");
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public void teardownTestNetwork(@NonNull Network network) {
        try {
            this.mService.teardownTestNetwork(network.netId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void setupTestNetwork(@NonNull String iface, @Nullable LinkProperties lp, boolean isMetered, @NonNull int[] administratorUids, @NonNull IBinder binder) {
        try {
            this.mService.setupTestNetwork(iface, lp, isMetered, administratorUids, binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setupTestNetwork(@NonNull LinkProperties lp, boolean isMetered, @NonNull IBinder binder) {
        Objects.requireNonNull(lp, "Invalid LinkProperties");
        this.setupTestNetwork(lp.getInterfaceName(), lp, isMetered, new int[0], binder);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public void setupTestNetwork(@NonNull String iface, @NonNull IBinder binder) {
        this.setupTestNetwork(iface, null, true, new int[0], binder);
    }

    public void setupTestNetwork(@NonNull String iface, @NonNull int[] administratorUids, @NonNull IBinder binder) {
        this.setupTestNetwork(iface, null, true, administratorUids, binder);
    }

    @Deprecated
    @NonNull
    public TestNetworkInterface createTunInterface(@NonNull LinkAddress[] linkAddrs) {
        return this.createTunInterface(Arrays.asList(linkAddrs));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    @NonNull
    public TestNetworkInterface createTunInterface(@NonNull Collection<LinkAddress> linkAddrs) {
        try {
            LinkAddress[] arr = new LinkAddress[linkAddrs.size()];
            return this.mService.createInterface(true, true, true, false, linkAddrs.toArray(arr), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    @NonNull
    public TestNetworkInterface createTapInterface() {
        try {
            return this.mService.createInterface(false, true, true, false, NO_ADDRS, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    @NonNull
    public TestNetworkInterface createTapInterface(boolean bringUp, @NonNull String iface) {
        try {
            return this.mService.createInterface(false, true, bringUp, false, NO_ADDRS, iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    @NonNull
    public TestNetworkInterface createTapInterface(boolean carrierUp, boolean bringUp, boolean disableIpv6ProvisioningDelay) {
        try {
            return this.mService.createInterface(false, carrierUp, bringUp, disableIpv6ProvisioningDelay, NO_ADDRS, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public void setCarrierEnabled(@NonNull TestNetworkInterface iface, boolean enabled) {
        try {
            this.mService.setCarrierEnabled(iface, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    @NonNull
    public TestNetworkInterface createTestInterface(@NonNull TestInterfaceRequest request) {
        try {
            return this.mService.createInterface(request.isTun, request.hasCarrier, request.bringUp, request.disableIpv6ProvDelay, request.linkAddresses, request.ifname);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static class TestInterfaceRequest {
        public final boolean isTun;
        public final boolean hasCarrier;
        public final boolean bringUp;
        public final boolean disableIpv6ProvDelay;
        @Nullable
        public final String ifname;
        public final LinkAddress[] linkAddresses;

        private TestInterfaceRequest(boolean isTun, boolean hasCarrier, boolean bringUp, boolean disableProvDelay, @Nullable String ifname, LinkAddress[] linkAddresses) {
            this.isTun = isTun;
            this.hasCarrier = hasCarrier;
            this.bringUp = bringUp;
            this.disableIpv6ProvDelay = disableProvDelay;
            this.ifname = ifname;
            this.linkAddresses = linkAddresses;
        }

        public static class Builder {
            private boolean mIsTun = false;
            private boolean mHasCarrier = true;
            private boolean mBringUp = true;
            private boolean mDisableIpv6ProvDelay = false;
            @Nullable
            private String mIfname;
            private List<LinkAddress> mLinkAddresses = new ArrayList<LinkAddress>();

            public Builder setTun() {
                this.mIsTun = true;
                return this;
            }

            public Builder setTap() {
                this.mIsTun = false;
                return this;
            }

            public Builder setHasCarrier(boolean hasCarrier) {
                this.mHasCarrier = hasCarrier;
                return this;
            }

            public Builder setBringUp(boolean bringUp) {
                this.mBringUp = bringUp;
                return this;
            }

            public Builder setDisableIpv6ProvisioningDelay(boolean disableProvDelay) {
                this.mDisableIpv6ProvDelay = disableProvDelay;
                return this;
            }

            public Builder setInterfaceName(@Nullable String ifname) {
                this.mIfname = ifname;
                return this;
            }

            public Builder addLinkAddress(LinkAddress la) {
                this.mLinkAddresses.add(la);
                return this;
            }

            public TestInterfaceRequest build() {
                return new TestInterfaceRequest(this.mIsTun, this.mHasCarrier, this.mBringUp, this.mDisableIpv6ProvDelay, this.mIfname, this.mLinkAddresses.toArray(new LinkAddress[0]));
            }
        }
    }
}

