/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.InetAddresses;
import android.net.InvalidPacketException;
import android.net.KeepalivePacketData;
import android.net.connectivity.com.android.net.module.util.IpUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

@SystemApi
public class NattKeepalivePacketData
extends KeepalivePacketData
implements Parcelable {
    private static final int IPV4_HEADER_LENGTH = 20;
    private static final int IPV6_HEADER_LENGTH = 40;
    private static final int UDP_HEADER_LENGTH = 8;
    @NonNull
    public static final Parcelable.Creator<NattKeepalivePacketData> CREATOR = new Parcelable.Creator<NattKeepalivePacketData>(){

        @Override
        public NattKeepalivePacketData createFromParcel(Parcel in) {
            InetAddress srcAddress = InetAddresses.parseNumericAddress(in.readString());
            InetAddress dstAddress = InetAddresses.parseNumericAddress(in.readString());
            int srcPort = in.readInt();
            int dstPort = in.readInt();
            try {
                return NattKeepalivePacketData.nattKeepalivePacket(srcAddress, srcPort, dstAddress, dstPort);
            }
            catch (InvalidPacketException e) {
                throw new IllegalArgumentException("Invalid NAT-T keepalive data: " + e.getError());
            }
        }

        public NattKeepalivePacketData[] newArray(int size) {
            return new NattKeepalivePacketData[size];
        }
    };

    public NattKeepalivePacketData(@NonNull InetAddress srcAddress, int srcPort, @NonNull InetAddress dstAddress, int dstPort, @NonNull byte[] data) throws InvalidPacketException {
        super(srcAddress, srcPort, dstAddress, dstPort, data);
    }

    public static NattKeepalivePacketData nattKeepalivePacket(InetAddress srcAddress, int srcPort, InetAddress dstAddress, int dstPort) throws InvalidPacketException {
        InetAddress dstAddr;
        InetAddress srcAddr;
        if (dstPort != 4500) {
            throw new InvalidPacketException(-22);
        }
        try {
            srcAddr = InetAddress.getByAddress(srcAddress.getAddress());
            dstAddr = InetAddress.getByAddress(dstAddress.getAddress());
        }
        catch (UnknownHostException e) {
            throw new InvalidPacketException(-21);
        }
        if (srcAddr instanceof Inet4Address && dstAddr instanceof Inet4Address) {
            return NattKeepalivePacketData.nattKeepalivePacketv4((Inet4Address)srcAddr, srcPort, (Inet4Address)dstAddr, dstPort);
        }
        if (srcAddr instanceof Inet6Address && dstAddr instanceof Inet6Address) {
            return NattKeepalivePacketData.nattKeepalivePacketv6((Inet6Address)srcAddr, srcPort, (Inet6Address)dstAddr, dstPort);
        }
        throw new InvalidPacketException(-21);
    }

    private static NattKeepalivePacketData nattKeepalivePacketv4(Inet4Address srcAddress, int srcPort, Inet4Address dstAddress, int dstPort) throws InvalidPacketException {
        int length = 29;
        ByteBuffer buf = ByteBuffer.allocate(length);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putShort((short)17664);
        buf.putShort((short)length);
        buf.putShort((short)0);
        buf.putShort((short)16384);
        buf.put((byte)64);
        buf.put((byte)OsConstants.IPPROTO_UDP);
        int ipChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put(srcAddress.getAddress());
        buf.put(dstAddress.getAddress());
        buf.putShort((short)srcPort);
        buf.putShort((short)dstPort);
        buf.putShort((short)9);
        int udpChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put((byte)-1);
        buf.putShort(ipChecksumOffset, IpUtils.ipChecksum(buf, 0));
        buf.putShort(udpChecksumOffset, IpUtils.udpChecksum(buf, 0, 20));
        return new NattKeepalivePacketData(srcAddress, srcPort, dstAddress, dstPort, buf.array());
    }

    private static NattKeepalivePacketData nattKeepalivePacketv6(Inet6Address srcAddress, int srcPort, Inet6Address dstAddress, int dstPort) throws InvalidPacketException {
        ByteBuffer buf = ByteBuffer.allocate(49);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(0x60000000);
        buf.putShort((short)9);
        buf.put((byte)OsConstants.IPPROTO_UDP);
        buf.put((byte)64);
        buf.put(srcAddress.getAddress());
        buf.put(dstAddress.getAddress());
        buf.putShort((short)srcPort);
        buf.putShort((short)dstPort);
        buf.putShort((short)9);
        int udpChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put((byte)-1);
        buf.putShort(udpChecksumOffset, IpUtils.udpChecksum(buf, 0, 40));
        return new NattKeepalivePacketData(srcAddress, srcPort, dstAddress, dstPort, buf.array());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.getSrcAddress().getHostAddress());
        out.writeString(this.getDstAddress().getHostAddress());
        out.writeInt(this.getSrcPort());
        out.writeInt(this.getDstPort());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof NattKeepalivePacketData)) {
            return false;
        }
        NattKeepalivePacketData other = (NattKeepalivePacketData)o;
        InetAddress srcAddress = this.getSrcAddress();
        InetAddress dstAddress = this.getDstAddress();
        return ((Object)srcAddress).equals(other.getSrcAddress()) && ((Object)dstAddress).equals(other.getDstAddress()) && this.getSrcPort() == other.getSrcPort() && this.getDstPort() == other.getDstPort();
    }

    public int hashCode() {
        return Objects.hash(this.getSrcAddress(), this.getDstAddress(), this.getSrcPort(), this.getDstPort());
    }
}

