/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructLinger;
import android.system.StructTimeval;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalSocketImpl {
    private SocketInputStream fis;
    private SocketOutputStream fos;
    private Object readMonitor = new Object();
    private Object writeMonitor = new Object();
    private FileDescriptor fd;
    private boolean mFdCreatedInternally;
    @UnsupportedAppUsage
    FileDescriptor[] inboundFileDescriptors;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    FileDescriptor[] outboundFileDescriptors;

    private int read_native(FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#read_native(Ljava/io/FileDescriptor;)I", true, this);
    }

    private int readba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#readba_native([BIILjava/io/FileDescriptor;)I", true, this);
    }

    private void writeba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#writeba_native([BIILjava/io/FileDescriptor;)V", true, this);
    }

    private void write_native(int n, FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#write_native(ILjava/io/FileDescriptor;)V", true, this);
    }

    private void connectLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#connectLocal(Ljava/io/FileDescriptor;Ljava/lang/String;I)V", true, this);
    }

    private void bindLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#bindLocal(Ljava/io/FileDescriptor;Ljava/lang/String;I)V", true, this);
    }

    private Credentials getPeerCredentials_native(FileDescriptor fileDescriptor) throws IOException {
        return (Credentials)OverrideMethod.invokeA("android.net.LocalSocketImpl#getPeerCredentials_native(Ljava/io/FileDescriptor;)Landroid/net/Credentials;", true, this);
    }

    @UnsupportedAppUsage
    LocalSocketImpl() {
    }

    LocalSocketImpl(FileDescriptor fd) {
        this.fd = fd;
    }

    public String toString() {
        return super.toString() + " fd:" + this.fd;
    }

    public void create(int sockType) throws IOException {
        int osType;
        if (this.fd != null) {
            throw new IOException("LocalSocketImpl already has an fd");
        }
        switch (sockType) {
            case 1: {
                osType = OsConstants.SOCK_DGRAM;
                break;
            }
            case 2: {
                osType = OsConstants.SOCK_STREAM;
                break;
            }
            case 3: {
                osType = OsConstants.SOCK_SEQPACKET;
                break;
            }
            default: {
                throw new IllegalStateException("unknown sockType");
            }
        }
        try {
            this.fd = Os.socket(OsConstants.AF_UNIX, osType, 0);
            this.mFdCreatedInternally = true;
        }
        catch (ErrnoException e) {
            e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fd == null || !this.mFdCreatedInternally) {
                this.fd = null;
                return;
            }
            try {
                Os.close(this.fd);
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            this.fd = null;
        }
    }

    protected void connect(LocalSocketAddress address, int timeout) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.connectLocal(this.fd, address.getName(), address.getNamespace().getId());
    }

    public void bind(LocalSocketAddress endpoint) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.bindLocal(this.fd, endpoint.getName(), endpoint.getNamespace().getId());
    }

    protected void listen(int backlog) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.listen(this.fd, backlog);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    protected void accept(LocalSocketImpl s) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            s.fd = Os.accept(this.fd, null);
            s.mFdCreatedInternally = true;
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fis == null) {
                this.fis = new SocketInputStream();
            }
            return this.fis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fos == null) {
                this.fos = new SocketOutputStream();
            }
            return this.fos;
        }
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    protected void shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.shutdown(this.fd, OsConstants.SHUT_RD);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.shutdown(this.fd, OsConstants.SHUT_WR);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    protected void sendUrgentData(int data) throws IOException {
        throw new RuntimeException("not impled");
    }

    public Object getOption(int optID) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Integer toReturn;
            switch (optID) {
                case 4102: {
                    StructTimeval timeval = Os.getsockoptTimeval(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO);
                    toReturn = (int)timeval.toMillis();
                    break;
                }
                case 4: 
                case 4097: 
                case 4098: {
                    int osOpt = LocalSocketImpl.javaSoToOsOpt(optID);
                    toReturn = Os.getsockoptInt(this.fd, OsConstants.SOL_SOCKET, osOpt);
                    break;
                }
                case 128: {
                    StructLinger linger = Os.getsockoptLinger(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
                    if (!linger.isOn()) {
                        toReturn = -1;
                        break;
                    }
                    toReturn = linger.l_linger;
                    break;
                }
                case 1: {
                    toReturn = Os.getsockoptInt(this.fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY);
                    break;
                }
                default: {
                    throw new IOException("Unknown option: " + optID);
                }
            }
            return toReturn;
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    public void setOption(int optID, Object value) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        int boolValue = -1;
        int intValue = 0;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Boolean) {
            boolValue = (Boolean)value != false ? 1 : 0;
        } else {
            throw new IOException("bad value: " + value);
        }
        try {
            switch (optID) {
                case 128: {
                    StructLinger linger = new StructLinger(boolValue, intValue);
                    Os.setsockoptLinger(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER, linger);
                    break;
                }
                case 4102: {
                    StructTimeval timeval = StructTimeval.fromMillis(intValue);
                    Os.setsockoptTimeval(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, timeval);
                    Os.setsockoptTimeval(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, timeval);
                    break;
                }
                case 4: 
                case 4097: 
                case 4098: {
                    int osOpt = LocalSocketImpl.javaSoToOsOpt(optID);
                    Os.setsockoptInt(this.fd, OsConstants.SOL_SOCKET, osOpt, intValue);
                    break;
                }
                case 1: {
                    Os.setsockoptInt(this.fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY, intValue);
                    break;
                }
                default: {
                    throw new IOException("Unknown option: " + optID);
                }
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDescriptorsForSend(FileDescriptor[] fds) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] result = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return result;
        }
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.getPeerCredentials_native(this.fd);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static int javaSoToOsOpt(int optID) {
        switch (optID) {
            case 4097: {
                return OsConstants.SO_SNDBUF;
            }
            case 4098: {
                return OsConstants.SO_RCVBUF;
            }
            case 4: {
                return OsConstants.SO_REUSEADDR;
            }
        }
        throw new UnsupportedOperationException("Unknown option: " + optID);
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        @Override
        public int available() throws IOException {
            FileDescriptor myFd = LocalSocketImpl.this.fd;
            if (myFd == null) {
                throw new IOException("socket closed");
            }
            try {
                return Os.ioctlInt(myFd, OsConstants.FIONREAD);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                int ret = LocalSocketImpl.this.read_native(myFd);
                return ret;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int ret = LocalSocketImpl.this.readba_native(b, off, len, myFd);
                return ret;
            }
        }
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                LocalSocketImpl.this.writeba_native(b, off, len, myFd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                LocalSocketImpl.this.write_native(b, myFd);
            }
        }
    }
}

