/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.IpSecAlgorithm;
import android.net.Network;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;

public class IpSecConfig
implements Parcelable {
    private static final String TAG = "IpSecConfig";
    private int mMode = 0;
    private String mSourceAddress = "";
    private String mDestinationAddress = "";
    private Network mNetwork;
    private int mSpiResourceId = -1;
    private IpSecAlgorithm mEncryption;
    private IpSecAlgorithm mAuthentication;
    private IpSecAlgorithm mAuthenticatedEncryption;
    private int mEncapType = 0;
    private int mEncapSocketResourceId = -1;
    private int mEncapRemotePort;
    private int mNattKeepaliveInterval;
    private int mMarkValue;
    private int mMarkMask;
    private int mXfrmInterfaceId;
    @NonNull
    public static final Parcelable.Creator<IpSecConfig> CREATOR = new Parcelable.Creator<IpSecConfig>(){

        @Override
        public IpSecConfig createFromParcel(Parcel in) {
            return new IpSecConfig(in);
        }

        public IpSecConfig[] newArray(int size) {
            return new IpSecConfig[size];
        }
    };

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void setSourceAddress(String sourceAddress) {
        this.mSourceAddress = sourceAddress;
    }

    public void setDestinationAddress(String destinationAddress) {
        this.mDestinationAddress = destinationAddress;
    }

    public void setSpiResourceId(int resourceId) {
        this.mSpiResourceId = resourceId;
    }

    public void setEncryption(IpSecAlgorithm encryption) {
        this.mEncryption = encryption;
    }

    public void setAuthentication(IpSecAlgorithm authentication) {
        this.mAuthentication = authentication;
    }

    public void setAuthenticatedEncryption(IpSecAlgorithm authenticatedEncryption) {
        this.mAuthenticatedEncryption = authenticatedEncryption;
    }

    public void setNetwork(Network network) {
        this.mNetwork = network;
    }

    public void setEncapType(int encapType) {
        this.mEncapType = encapType;
    }

    public void setEncapSocketResourceId(int resourceId) {
        this.mEncapSocketResourceId = resourceId;
    }

    public void setEncapRemotePort(int port) {
        this.mEncapRemotePort = port;
    }

    public void setNattKeepaliveInterval(int interval) {
        this.mNattKeepaliveInterval = interval;
    }

    public void setMarkValue(int mark) {
        this.mMarkValue = mark;
    }

    public void setMarkMask(int mask) {
        this.mMarkMask = mask;
    }

    public void setXfrmInterfaceId(int xfrmInterfaceId) {
        this.mXfrmInterfaceId = xfrmInterfaceId;
    }

    public int getMode() {
        return this.mMode;
    }

    public String getSourceAddress() {
        return this.mSourceAddress;
    }

    public int getSpiResourceId() {
        return this.mSpiResourceId;
    }

    public String getDestinationAddress() {
        return this.mDestinationAddress;
    }

    public IpSecAlgorithm getEncryption() {
        return this.mEncryption;
    }

    public IpSecAlgorithm getAuthentication() {
        return this.mAuthentication;
    }

    public IpSecAlgorithm getAuthenticatedEncryption() {
        return this.mAuthenticatedEncryption;
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public int getEncapType() {
        return this.mEncapType;
    }

    public int getEncapSocketResourceId() {
        return this.mEncapSocketResourceId;
    }

    public int getEncapRemotePort() {
        return this.mEncapRemotePort;
    }

    public int getNattKeepaliveInterval() {
        return this.mNattKeepaliveInterval;
    }

    public int getMarkValue() {
        return this.mMarkValue;
    }

    public int getMarkMask() {
        return this.mMarkMask;
    }

    public int getXfrmInterfaceId() {
        return this.mXfrmInterfaceId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mMode);
        out.writeString(this.mSourceAddress);
        out.writeString(this.mDestinationAddress);
        out.writeParcelable(this.mNetwork, flags);
        out.writeInt(this.mSpiResourceId);
        out.writeParcelable(this.mEncryption, flags);
        out.writeParcelable(this.mAuthentication, flags);
        out.writeParcelable(this.mAuthenticatedEncryption, flags);
        out.writeInt(this.mEncapType);
        out.writeInt(this.mEncapSocketResourceId);
        out.writeInt(this.mEncapRemotePort);
        out.writeInt(this.mNattKeepaliveInterval);
        out.writeInt(this.mMarkValue);
        out.writeInt(this.mMarkMask);
        out.writeInt(this.mXfrmInterfaceId);
    }

    @VisibleForTesting
    public IpSecConfig() {
    }

    @VisibleForTesting
    public IpSecConfig(IpSecConfig c) {
        this.mMode = c.mMode;
        this.mSourceAddress = c.mSourceAddress;
        this.mDestinationAddress = c.mDestinationAddress;
        this.mNetwork = c.mNetwork;
        this.mSpiResourceId = c.mSpiResourceId;
        this.mEncryption = c.mEncryption;
        this.mAuthentication = c.mAuthentication;
        this.mAuthenticatedEncryption = c.mAuthenticatedEncryption;
        this.mEncapType = c.mEncapType;
        this.mEncapSocketResourceId = c.mEncapSocketResourceId;
        this.mEncapRemotePort = c.mEncapRemotePort;
        this.mNattKeepaliveInterval = c.mNattKeepaliveInterval;
        this.mMarkValue = c.mMarkValue;
        this.mMarkMask = c.mMarkMask;
        this.mXfrmInterfaceId = c.mXfrmInterfaceId;
    }

    private IpSecConfig(Parcel in) {
        this.mMode = in.readInt();
        this.mSourceAddress = in.readString();
        this.mDestinationAddress = in.readString();
        this.mNetwork = in.readParcelable(Network.class.getClassLoader(), Network.class);
        this.mSpiResourceId = in.readInt();
        this.mEncryption = in.readParcelable(IpSecAlgorithm.class.getClassLoader(), IpSecAlgorithm.class);
        this.mAuthentication = in.readParcelable(IpSecAlgorithm.class.getClassLoader(), IpSecAlgorithm.class);
        this.mAuthenticatedEncryption = in.readParcelable(IpSecAlgorithm.class.getClassLoader(), IpSecAlgorithm.class);
        this.mEncapType = in.readInt();
        this.mEncapSocketResourceId = in.readInt();
        this.mEncapRemotePort = in.readInt();
        this.mNattKeepaliveInterval = in.readInt();
        this.mMarkValue = in.readInt();
        this.mMarkMask = in.readInt();
        this.mXfrmInterfaceId = in.readInt();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("{mMode=").append(this.mMode == 1 ? "TUNNEL" : "TRANSPORT").append(", mSourceAddress=").append(this.mSourceAddress).append(", mDestinationAddress=").append(this.mDestinationAddress).append(", mNetwork=").append(this.mNetwork).append(", mEncapType=").append(this.mEncapType).append(", mEncapSocketResourceId=").append(this.mEncapSocketResourceId).append(", mEncapRemotePort=").append(this.mEncapRemotePort).append(", mNattKeepaliveInterval=").append(this.mNattKeepaliveInterval).append("{mSpiResourceId=").append(this.mSpiResourceId).append(", mEncryption=").append(this.mEncryption).append(", mAuthentication=").append(this.mAuthentication).append(", mAuthenticatedEncryption=").append(this.mAuthenticatedEncryption).append(", mMarkValue=").append(this.mMarkValue).append(", mMarkMask=").append(this.mMarkMask).append(", mXfrmInterfaceId=").append(this.mXfrmInterfaceId).append("}");
        return strBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IpSecConfig)) {
            return false;
        }
        IpSecConfig rhs = (IpSecConfig)other;
        return this.mMode == rhs.mMode && this.mSourceAddress.equals(rhs.mSourceAddress) && this.mDestinationAddress.equals(rhs.mDestinationAddress) && (this.mNetwork != null && this.mNetwork.equals(rhs.mNetwork) || this.mNetwork == rhs.mNetwork) && this.mEncapType == rhs.mEncapType && this.mEncapSocketResourceId == rhs.mEncapSocketResourceId && this.mEncapRemotePort == rhs.mEncapRemotePort && this.mNattKeepaliveInterval == rhs.mNattKeepaliveInterval && this.mSpiResourceId == rhs.mSpiResourceId && IpSecAlgorithm.equals(this.mEncryption, rhs.mEncryption) && IpSecAlgorithm.equals(this.mAuthenticatedEncryption, rhs.mAuthenticatedEncryption) && IpSecAlgorithm.equals(this.mAuthentication, rhs.mAuthentication) && this.mMarkValue == rhs.mMarkValue && this.mMarkMask == rhs.mMarkMask && this.mXfrmInterfaceId == rhs.mXfrmInterfaceId;
    }
}

