/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.LinkAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashSet;

public class InterfaceConfiguration
implements Parcelable {
    private String mHwAddr;
    private LinkAddress mAddr;
    private HashSet<String> mFlags = new HashSet();
    private static final String FLAG_UP = "up";
    private static final String FLAG_DOWN = "down";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @NonNull
    public static final Parcelable.Creator<InterfaceConfiguration> CREATOR = new Parcelable.Creator<InterfaceConfiguration>(){

        @Override
        public InterfaceConfiguration createFromParcel(Parcel in) {
            InterfaceConfiguration info = new InterfaceConfiguration();
            info.mHwAddr = in.readString();
            if (in.readByte() == 1) {
                info.mAddr = (LinkAddress)in.readParcelable(null);
            }
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                info.mFlags.add(in.readString());
            }
            return info;
        }

        public InterfaceConfiguration[] newArray(int size) {
            return new InterfaceConfiguration[size];
        }
    };

    @UnsupportedAppUsage
    public InterfaceConfiguration() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("mHwAddr=").append(this.mHwAddr);
        builder.append(" mAddr=").append(String.valueOf(this.mAddr));
        builder.append(" mFlags=").append(this.getFlags());
        return builder.toString();
    }

    @UnsupportedAppUsage
    public Iterable<String> getFlags() {
        return this.mFlags;
    }

    public boolean hasFlag(String flag) {
        InterfaceConfiguration.validateFlag(flag);
        return this.mFlags.contains(flag);
    }

    @UnsupportedAppUsage
    public void clearFlag(String flag) {
        InterfaceConfiguration.validateFlag(flag);
        this.mFlags.remove(flag);
    }

    @UnsupportedAppUsage
    public void setFlag(String flag) {
        InterfaceConfiguration.validateFlag(flag);
        this.mFlags.add(flag);
    }

    @UnsupportedAppUsage
    public void setInterfaceUp() {
        this.mFlags.remove(FLAG_DOWN);
        this.mFlags.add(FLAG_UP);
    }

    @UnsupportedAppUsage
    public void setInterfaceDown() {
        this.mFlags.remove(FLAG_UP);
        this.mFlags.add(FLAG_DOWN);
    }

    public void ignoreInterfaceUpDownStatus() {
        this.mFlags.remove(FLAG_UP);
        this.mFlags.remove(FLAG_DOWN);
    }

    public LinkAddress getLinkAddress() {
        return this.mAddr;
    }

    @UnsupportedAppUsage
    public void setLinkAddress(LinkAddress addr) {
        this.mAddr = addr;
    }

    public String getHardwareAddress() {
        return this.mHwAddr;
    }

    public void setHardwareAddress(String hwAddr) {
        this.mHwAddr = hwAddr;
    }

    public boolean isActive() {
        try {
            if (this.isUp()) {
                for (byte b : this.mAddr.getAddress().getAddress()) {
                    if (b == 0) continue;
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    public boolean isUp() {
        return this.hasFlag(FLAG_UP);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mHwAddr);
        if (this.mAddr != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mAddr, flags);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.mFlags.size());
        for (String flag : this.mFlags) {
            dest.writeString(flag);
        }
    }

    private static void validateFlag(String flag) {
        if (flag.indexOf(32) >= 0) {
            throw new IllegalArgumentException("flag contains space: " + flag);
        }
    }
}

