/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsSession
extends IInterface {
    public NetworkStats getDeviceSummaryForNetwork(NetworkTemplate var1, long var2, long var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsSession.aidl:30:1:30:25")
    public NetworkStats getSummaryForNetwork(NetworkTemplate var1, long var2, long var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsSession.aidl:33:1:33:25")
    public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate var1, int var2) throws RemoteException;

    public NetworkStatsHistory getHistoryIntervalForNetwork(NetworkTemplate var1, int var2, long var3, long var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsSession.aidl:52:1:52:25")
    public NetworkStats getSummaryForAllUid(NetworkTemplate var1, long var2, long var4, boolean var6) throws RemoteException;

    public NetworkStats getTaggedSummaryForAllUid(NetworkTemplate var1, long var2, long var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsSession.aidl:59:1:59:25")
    public NetworkStatsHistory getHistoryForUid(NetworkTemplate var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public NetworkStatsHistory getHistoryIntervalForUid(NetworkTemplate var1, int var2, int var3, int var4, int var5, long var6, long var8) throws RemoteException;

    public int[] getRelevantUids() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsSession.aidl:67:1:67:25")
    public void close() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsSession {
        public static final String DESCRIPTOR = "android.net.INetworkStatsSession";
        static final int TRANSACTION_getDeviceSummaryForNetwork = 1;
        static final int TRANSACTION_getSummaryForNetwork = 2;
        static final int TRANSACTION_getHistoryForNetwork = 3;
        static final int TRANSACTION_getHistoryIntervalForNetwork = 4;
        static final int TRANSACTION_getSummaryForAllUid = 5;
        static final int TRANSACTION_getTaggedSummaryForAllUid = 6;
        static final int TRANSACTION_getHistoryForUid = 7;
        static final int TRANSACTION_getHistoryIntervalForUid = 8;
        static final int TRANSACTION_getRelevantUids = 9;
        static final int TRANSACTION_close = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsSession) {
                return (INetworkStatsSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDeviceSummaryForNetwork";
                }
                case 2: {
                    return "getSummaryForNetwork";
                }
                case 3: {
                    return "getHistoryForNetwork";
                }
                case 4: {
                    return "getHistoryIntervalForNetwork";
                }
                case 5: {
                    return "getSummaryForAllUid";
                }
                case 6: {
                    return "getTaggedSummaryForAllUid";
                }
                case 7: {
                    return "getHistoryForUid";
                }
                case 8: {
                    return "getHistoryIntervalForUid";
                }
                case 9: {
                    return "getRelevantUids";
                }
                case 10: {
                    return "close";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getDeviceSummaryForNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getSummaryForNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    NetworkStatsHistory _result = this.getHistoryForNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    NetworkStatsHistory _result = this.getHistoryIntervalForNetwork(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getSummaryForAllUid(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getTaggedSummaryForAllUid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    NetworkStatsHistory _result = this.getHistoryForUid(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    long _arg5 = data.readLong();
                    long _arg6 = data.readLong();
                    data.enforceNoDataAvail();
                    NetworkStatsHistory _result = this.getHistoryIntervalForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    int[] _result = this.getRelevantUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 10: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements INetworkStatsSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getDeviceSummaryForNetwork(NetworkTemplate template, long start, long end) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields) throws RemoteException {
                NetworkStatsHistory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeInt(fields);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStatsHistory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStatsHistory getHistoryIntervalForNetwork(NetworkTemplate template, int fields, long start, long end) throws RemoteException {
                NetworkStatsHistory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeInt(fields);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStatsHistory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getSummaryForAllUid(NetworkTemplate template, long start, long end, boolean includeTags) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    _data.writeBoolean(includeTags);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getTaggedSummaryForAllUid(NetworkTemplate template, long start, long end) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStatsHistory getHistoryForUid(NetworkTemplate template, int uid, int set, int tag, int fields) throws RemoteException {
                NetworkStatsHistory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeInt(uid);
                    _data.writeInt(set);
                    _data.writeInt(tag);
                    _data.writeInt(fields);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStatsHistory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStatsHistory getHistoryIntervalForUid(NetworkTemplate template, int uid, int set, int tag, int fields, long start, long end) throws RemoteException {
                NetworkStatsHistory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    _data.writeInt(uid);
                    _data.writeInt(set);
                    _data.writeInt(tag);
                    _data.writeInt(fields);
                    _data.writeLong(start);
                    _data.writeLong(end);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStatsHistory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getRelevantUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsSession {
        @Override
        public NetworkStats getDeviceSummaryForNetwork(NetworkTemplate template, long start, long end) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStatsHistory getHistoryIntervalForNetwork(NetworkTemplate template, int fields, long start, long end) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getSummaryForAllUid(NetworkTemplate template, long start, long end, boolean includeTags) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getTaggedSummaryForAllUid(NetworkTemplate template, long start, long end) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStatsHistory getHistoryForUid(NetworkTemplate template, int uid, int set, int tag, int fields) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStatsHistory getHistoryIntervalForUid(NetworkTemplate template, int uid, int set, int tag, int fields, long start, long end) throws RemoteException {
            return null;
        }

        @Override
        public int[] getRelevantUids() throws RemoteException {
            return null;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

