/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DscpPolicy;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkScore;
import android.net.QosSession;
import android.net.connectivity.android.net.LocalNetworkConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telephony.data.EpsBearerQosSessionAttributes;
import android.telephony.data.NrQosSessionAttributes;
import java.util.ArrayList;
import java.util.List;

public interface INetworkAgentRegistry
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkAgentRegistry";

    public void sendNetworkCapabilities(NetworkCapabilities var1) throws RemoteException;

    public void sendLinkProperties(LinkProperties var1) throws RemoteException;

    public void sendNetworkInfo(NetworkInfo var1) throws RemoteException;

    public void sendLocalNetworkConfig(LocalNetworkConfig var1) throws RemoteException;

    public void sendScore(NetworkScore var1) throws RemoteException;

    public void sendExplicitlySelected(boolean var1, boolean var2) throws RemoteException;

    public void sendSocketKeepaliveEvent(int var1, int var2) throws RemoteException;

    public void sendUnderlyingNetworks(List<Network> var1) throws RemoteException;

    public void sendEpsQosSessionAvailable(int var1, QosSession var2, EpsBearerQosSessionAttributes var3) throws RemoteException;

    public void sendNrQosSessionAvailable(int var1, QosSession var2, NrQosSessionAttributes var3) throws RemoteException;

    public void sendQosSessionLost(int var1, QosSession var2) throws RemoteException;

    public void sendQosCallbackError(int var1, int var2) throws RemoteException;

    public void sendTeardownDelayMs(int var1) throws RemoteException;

    public void sendLingerDuration(int var1) throws RemoteException;

    public void sendAddDscpPolicy(DscpPolicy var1) throws RemoteException;

    public void sendRemoveDscpPolicy(int var1) throws RemoteException;

    public void sendRemoveAllDscpPolicies() throws RemoteException;

    public void sendUnregisterAfterReplacement(int var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements INetworkAgentRegistry {
        static final int TRANSACTION_sendNetworkCapabilities = 1;
        static final int TRANSACTION_sendLinkProperties = 2;
        static final int TRANSACTION_sendNetworkInfo = 3;
        static final int TRANSACTION_sendLocalNetworkConfig = 4;
        static final int TRANSACTION_sendScore = 5;
        static final int TRANSACTION_sendExplicitlySelected = 6;
        static final int TRANSACTION_sendSocketKeepaliveEvent = 7;
        static final int TRANSACTION_sendUnderlyingNetworks = 8;
        static final int TRANSACTION_sendEpsQosSessionAvailable = 9;
        static final int TRANSACTION_sendNrQosSessionAvailable = 10;
        static final int TRANSACTION_sendQosSessionLost = 11;
        static final int TRANSACTION_sendQosCallbackError = 12;
        static final int TRANSACTION_sendTeardownDelayMs = 13;
        static final int TRANSACTION_sendLingerDuration = 14;
        static final int TRANSACTION_sendAddDscpPolicy = 15;
        static final int TRANSACTION_sendRemoveDscpPolicy = 16;
        static final int TRANSACTION_sendRemoveAllDscpPolicies = 17;
        static final int TRANSACTION_sendUnregisterAfterReplacement = 18;

        public Stub() {
            this.attachInterface(this, INetworkAgentRegistry.DESCRIPTOR);
        }

        public static INetworkAgentRegistry asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkAgentRegistry.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkAgentRegistry) {
                return (INetworkAgentRegistry)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendNetworkCapabilities";
                }
                case 2: {
                    return "sendLinkProperties";
                }
                case 3: {
                    return "sendNetworkInfo";
                }
                case 4: {
                    return "sendLocalNetworkConfig";
                }
                case 5: {
                    return "sendScore";
                }
                case 6: {
                    return "sendExplicitlySelected";
                }
                case 7: {
                    return "sendSocketKeepaliveEvent";
                }
                case 8: {
                    return "sendUnderlyingNetworks";
                }
                case 9: {
                    return "sendEpsQosSessionAvailable";
                }
                case 10: {
                    return "sendNrQosSessionAvailable";
                }
                case 11: {
                    return "sendQosSessionLost";
                }
                case 12: {
                    return "sendQosCallbackError";
                }
                case 13: {
                    return "sendTeardownDelayMs";
                }
                case 14: {
                    return "sendLingerDuration";
                }
                case 15: {
                    return "sendAddDscpPolicy";
                }
                case 16: {
                    return "sendRemoveDscpPolicy";
                }
                case 17: {
                    return "sendRemoveAllDscpPolicies";
                }
                case 18: {
                    return "sendUnregisterAfterReplacement";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkAgentRegistry.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    NetworkCapabilities _arg0 = data.readTypedObject(NetworkCapabilities.CREATOR);
                    this.sendNetworkCapabilities(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    LinkProperties _arg0 = data.readTypedObject(LinkProperties.CREATOR);
                    this.sendLinkProperties(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    NetworkInfo _arg0 = data.readTypedObject(NetworkInfo.CREATOR);
                    this.sendNetworkInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    LocalNetworkConfig _arg0 = data.readTypedObject(LocalNetworkConfig.CREATOR);
                    this.sendLocalNetworkConfig(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    NetworkScore _arg0 = data.readTypedObject(NetworkScore.CREATOR);
                    this.sendScore(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    this.sendExplicitlySelected(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.sendSocketKeepaliveEvent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ArrayList<Network> _arg0 = data.createTypedArrayList(Network.CREATOR);
                    this.sendUnderlyingNetworks(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    QosSession _arg1 = data.readTypedObject(QosSession.CREATOR);
                    EpsBearerQosSessionAttributes _arg2 = data.readTypedObject(EpsBearerQosSessionAttributes.CREATOR);
                    this.sendEpsQosSessionAvailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    QosSession _arg1 = data.readTypedObject(QosSession.CREATOR);
                    NrQosSessionAttributes _arg2 = data.readTypedObject(NrQosSessionAttributes.CREATOR);
                    this.sendNrQosSessionAvailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    QosSession _arg1 = data.readTypedObject(QosSession.CREATOR);
                    this.sendQosSessionLost(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.sendQosCallbackError(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    this.sendTeardownDelayMs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    this.sendLingerDuration(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    DscpPolicy _arg0 = data.readTypedObject(DscpPolicy.CREATOR);
                    this.sendAddDscpPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    this.sendRemoveDscpPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    this.sendRemoveAllDscpPolicies();
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    this.sendUnregisterAfterReplacement(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements INetworkAgentRegistry {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkAgentRegistry.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNetworkCapabilities(NetworkCapabilities nc) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(nc, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLinkProperties(LinkProperties lp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(lp, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNetworkInfo(NetworkInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLocalNetworkConfig(LocalNetworkConfig config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendScore(NetworkScore score) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(score, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendExplicitlySelected(boolean explicitlySelected, boolean acceptPartial) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeBoolean(explicitlySelected);
                    _data.writeBoolean(acceptPartial);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSocketKeepaliveEvent(int slot, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendUnderlyingNetworks(List<Network> networks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, networks, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendEpsQosSessionAvailable(int callbackId, QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(callbackId);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNrQosSessionAvailable(int callbackId, QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(callbackId);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendQosSessionLost(int qosCallbackId, QosSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    _data.writeTypedObject(session, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendQosCallbackError(int qosCallbackId, int exceptionType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    _data.writeInt(exceptionType);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTeardownDelayMs(int teardownDelayMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(teardownDelayMs);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLingerDuration(int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAddDscpPolicy(DscpPolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRemoveDscpPolicy(int policyId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(policyId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRemoveAllDscpPolicies() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendUnregisterAfterReplacement(int timeoutMillis) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(timeoutMillis);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkAgentRegistry {
        @Override
        public void sendNetworkCapabilities(NetworkCapabilities nc) throws RemoteException {
        }

        @Override
        public void sendLinkProperties(LinkProperties lp) throws RemoteException {
        }

        @Override
        public void sendNetworkInfo(NetworkInfo info) throws RemoteException {
        }

        @Override
        public void sendLocalNetworkConfig(LocalNetworkConfig config) throws RemoteException {
        }

        @Override
        public void sendScore(NetworkScore score) throws RemoteException {
        }

        @Override
        public void sendExplicitlySelected(boolean explicitlySelected, boolean acceptPartial) throws RemoteException {
        }

        @Override
        public void sendSocketKeepaliveEvent(int slot, int reason) throws RemoteException {
        }

        @Override
        public void sendUnderlyingNetworks(List<Network> networks) throws RemoteException {
        }

        @Override
        public void sendEpsQosSessionAvailable(int callbackId, QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void sendNrQosSessionAvailable(int callbackId, QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void sendQosSessionLost(int qosCallbackId, QosSession session) throws RemoteException {
        }

        @Override
        public void sendQosCallbackError(int qosCallbackId, int exceptionType) throws RemoteException {
        }

        @Override
        public void sendTeardownDelayMs(int teardownDelayMs) throws RemoteException {
        }

        @Override
        public void sendLingerDuration(int durationMs) throws RemoteException {
        }

        @Override
        public void sendAddDscpPolicy(DscpPolicy policy) throws RemoteException {
        }

        @Override
        public void sendRemoveDscpPolicy(int policyId) throws RemoteException {
        }

        @Override
        public void sendRemoveAllDscpPolicies() throws RemoteException {
        }

        @Override
        public void sendUnregisterAfterReplacement(int timeoutMillis) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

