/*
 * Decompiled with CFR 0.152.
 */
package android.nearby.aidl;

import android.nearby.OffloadCapability;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IOffloadCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.nearby.aidl.IOffloadCallback";

    public void onQueryComplete(OffloadCapability var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOffloadCallback {
        static final int TRANSACTION_onQueryComplete = 1;

        public Stub() {
            this.attachInterface(this, IOffloadCallback.DESCRIPTOR);
        }

        public static IOffloadCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOffloadCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOffloadCallback) {
                return (IOffloadCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onQueryComplete";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOffloadCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    OffloadCapability _arg0 = data.readTypedObject(OffloadCapability.CREATOR);
                    data.enforceNoDataAvail();
                    this.onQueryComplete(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IOffloadCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOffloadCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQueryComplete(OffloadCapability capability) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOffloadCallback.DESCRIPTOR);
                    _data.writeTypedObject(capability, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOffloadCallback {
        @Override
        public void onQueryComplete(OffloadCapability capability) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

