/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.nearby.BroadcastRequest;
import android.nearby.DataElement;
import android.nearby.PrivateCredential;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PresenceBroadcastRequest
extends BroadcastRequest
implements Parcelable {
    private final byte[] mSalt;
    private final List<Integer> mActions;
    private final PrivateCredential mCredential;
    private final List<DataElement> mExtendedProperties;
    @NonNull
    public static final Parcelable.Creator<PresenceBroadcastRequest> CREATOR = new Parcelable.Creator<PresenceBroadcastRequest>(){

        @Override
        public PresenceBroadcastRequest createFromParcel(Parcel in) {
            in.readInt();
            return PresenceBroadcastRequest.createFromParcelBody(in);
        }

        public PresenceBroadcastRequest[] newArray(int size) {
            return new PresenceBroadcastRequest[size];
        }
    };

    private PresenceBroadcastRequest(int version, int txPower, List<Integer> mediums, byte[] salt, List<Integer> actions, PrivateCredential credential, List<DataElement> extendedProperties) {
        super(3, version, txPower, mediums);
        this.mSalt = salt;
        this.mActions = actions;
        this.mCredential = credential;
        this.mExtendedProperties = extendedProperties;
    }

    private PresenceBroadcastRequest(Parcel in) {
        super(3, in);
        this.mSalt = new byte[in.readInt()];
        in.readByteArray(this.mSalt);
        this.mActions = new ArrayList<Integer>();
        in.readList(this.mActions, Integer.class.getClassLoader(), Integer.class);
        this.mCredential = in.readParcelable(PrivateCredential.class.getClassLoader(), PrivateCredential.class);
        this.mExtendedProperties = new ArrayList<DataElement>();
        in.readList(this.mExtendedProperties, DataElement.class.getClassLoader(), DataElement.class);
    }

    static PresenceBroadcastRequest createFromParcelBody(Parcel in) {
        return new PresenceBroadcastRequest(in);
    }

    @NonNull
    public byte[] getSalt() {
        return this.mSalt;
    }

    @NonNull
    public List<Integer> getActions() {
        return this.mActions;
    }

    @NonNull
    public PrivateCredential getCredential() {
        return this.mCredential;
    }

    @NonNull
    public List<DataElement> getExtendedProperties() {
        return this.mExtendedProperties;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mSalt.length);
        dest.writeByteArray(this.mSalt);
        dest.writeList(this.mActions);
        dest.writeParcelable(this.mCredential, 0);
        dest.writeList(this.mExtendedProperties);
    }

    public static class Builder {
        private final List<Integer> mMediums;
        private final List<Integer> mActions;
        private final List<DataElement> mExtendedProperties;
        private final byte[] mSalt;
        private final PrivateCredential mCredential;
        private int mVersion;
        private int mTxPower;

        public Builder(@NonNull List<Integer> mediums, @NonNull byte[] salt, @NonNull PrivateCredential credential) {
            Preconditions.checkState(!mediums.isEmpty(), "mediums cannot be empty");
            Preconditions.checkState(salt != null && salt.length > 0, "salt cannot be empty");
            this.mVersion = 0;
            this.mTxPower = -127;
            this.mCredential = credential;
            this.mActions = new ArrayList<Integer>();
            this.mExtendedProperties = new ArrayList<DataElement>();
            this.mSalt = salt;
            this.mMediums = mediums;
        }

        @NonNull
        public Builder setVersion(int version) {
            this.mVersion = version;
            return this;
        }

        @NonNull
        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        @NonNull
        public Builder addAction(int action) {
            this.mActions.add(action);
            return this;
        }

        @NonNull
        public Builder addExtendedProperty(@NonNull DataElement dataElement) {
            Objects.requireNonNull(dataElement);
            this.mExtendedProperties.add(dataElement);
            return this;
        }

        @NonNull
        public PresenceBroadcastRequest build() {
            return new PresenceBroadcastRequest(this.mVersion, this.mTxPower, this.mMediums, this.mSalt, this.mActions, this.mCredential, this.mExtendedProperties);
        }
    }
}

