/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.nearby.PresenceBroadcastRequest;
import android.os.Parcel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public abstract class BroadcastRequest {
    public static final int BROADCAST_TYPE_UNKNOWN = -1;
    public static final int BROADCAST_TYPE_NEARBY_PRESENCE = 3;
    public static final int UNKNOWN_TX_POWER = -127;
    public static final int PRESENCE_VERSION_UNKNOWN = -1;
    public static final int PRESENCE_VERSION_V0 = 0;
    public static final int PRESENCE_VERSION_V1 = 1;
    public static final int MEDIUM_BLE = 1;
    private final int mType;
    private final int mVersion;
    private final int mTxPower;
    private final List<Integer> mMediums;

    @NonNull
    public static BroadcastRequest createFromParcel(Parcel in) {
        int type = in.readInt();
        switch (type) {
            case 3: {
                return PresenceBroadcastRequest.createFromParcelBody(in);
            }
        }
        throw new IllegalStateException("Unexpected broadcast type (value " + type + ") in parcel.");
    }

    BroadcastRequest(int type, int version, int txPower, List<Integer> mediums) {
        this.mType = type;
        this.mVersion = version;
        this.mTxPower = txPower;
        this.mMediums = mediums;
    }

    BroadcastRequest(int type, Parcel in) {
        this.mType = type;
        this.mVersion = in.readInt();
        this.mTxPower = in.readInt();
        this.mMediums = new ArrayList<Integer>();
        in.readList(this.mMediums, Integer.class.getClassLoader(), Integer.class);
    }

    public int getType() {
        return this.mType;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    @NonNull
    public List<Integer> getMediums() {
        return this.mMediums;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mVersion);
        dest.writeInt(this.mTxPower);
        dest.writeList(this.mMediums);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Medium {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BroadcastVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BroadcastType {
    }
}

