/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.tunerresourcemanager;

import android.media.tv.tunerresourcemanager.CasSessionRequest;
import android.media.tv.tunerresourcemanager.IResourcesReclaimListener;
import android.media.tv.tunerresourcemanager.ResourceClientProfile;
import android.media.tv.tunerresourcemanager.TunerCiCamRequest;
import android.media.tv.tunerresourcemanager.TunerDemuxInfo;
import android.media.tv.tunerresourcemanager.TunerDemuxRequest;
import android.media.tv.tunerresourcemanager.TunerDescramblerRequest;
import android.media.tv.tunerresourcemanager.TunerFrontendInfo;
import android.media.tv.tunerresourcemanager.TunerFrontendRequest;
import android.media.tv.tunerresourcemanager.TunerLnbRequest;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITunerResourceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.tunerresourcemanager.ITunerResourceManager";

    public void registerClientProfile(ResourceClientProfile var1, IResourcesReclaimListener var2, int[] var3) throws RemoteException;

    public void unregisterClientProfile(int var1) throws RemoteException;

    public boolean updateClientPriority(int var1, int var2, int var3) throws RemoteException;

    public boolean hasUnusedFrontend(int var1) throws RemoteException;

    public boolean isLowestPriority(int var1, int var2) throws RemoteException;

    public void setFrontendInfoList(TunerFrontendInfo[] var1) throws RemoteException;

    public void updateCasInfo(int var1, int var2) throws RemoteException;

    public void setDemuxInfoList(TunerDemuxInfo[] var1) throws RemoteException;

    public void setLnbInfoList(long[] var1) throws RemoteException;

    public void setResourceOwnershipRetention(int var1, boolean var2) throws RemoteException;

    public boolean requestFrontend(TunerFrontendRequest var1, long[] var2) throws RemoteException;

    public boolean setMaxNumberOfFrontends(int var1, int var2) throws RemoteException;

    public int getMaxNumberOfFrontends(int var1) throws RemoteException;

    public void shareFrontend(int var1, int var2) throws RemoteException;

    public boolean transferOwner(int var1, int var2, int var3) throws RemoteException;

    public boolean requestDemux(TunerDemuxRequest var1, long[] var2) throws RemoteException;

    public boolean requestDescrambler(TunerDescramblerRequest var1, long[] var2) throws RemoteException;

    public boolean requestCasSession(CasSessionRequest var1, long[] var2) throws RemoteException;

    public boolean requestCiCam(TunerCiCamRequest var1, long[] var2) throws RemoteException;

    public boolean requestLnb(TunerLnbRequest var1, long[] var2) throws RemoteException;

    public void releaseFrontend(long var1, int var3) throws RemoteException;

    public void releaseDemux(long var1, int var3) throws RemoteException;

    public void releaseDescrambler(long var1, int var3) throws RemoteException;

    public void releaseCasSession(long var1, int var3) throws RemoteException;

    public void releaseCiCam(long var1, int var3) throws RemoteException;

    public void releaseLnb(long var1, int var3) throws RemoteException;

    public boolean isHigherPriority(ResourceClientProfile var1, ResourceClientProfile var2) throws RemoteException;

    public void storeResourceMap(int var1) throws RemoteException;

    public void clearResourceMap(int var1) throws RemoteException;

    public void restoreResourceMap(int var1) throws RemoteException;

    public boolean acquireLock(int var1, long var2) throws RemoteException;

    public boolean releaseLock(int var1) throws RemoteException;

    public int getClientPriority(int var1, int var2) throws RemoteException;

    public int getConfigPriority(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITunerResourceManager {
        static final int TRANSACTION_registerClientProfile = 1;
        static final int TRANSACTION_unregisterClientProfile = 2;
        static final int TRANSACTION_updateClientPriority = 3;
        static final int TRANSACTION_hasUnusedFrontend = 4;
        static final int TRANSACTION_isLowestPriority = 5;
        static final int TRANSACTION_setFrontendInfoList = 6;
        static final int TRANSACTION_updateCasInfo = 7;
        static final int TRANSACTION_setDemuxInfoList = 8;
        static final int TRANSACTION_setLnbInfoList = 9;
        static final int TRANSACTION_setResourceOwnershipRetention = 10;
        static final int TRANSACTION_requestFrontend = 11;
        static final int TRANSACTION_setMaxNumberOfFrontends = 12;
        static final int TRANSACTION_getMaxNumberOfFrontends = 13;
        static final int TRANSACTION_shareFrontend = 14;
        static final int TRANSACTION_transferOwner = 15;
        static final int TRANSACTION_requestDemux = 16;
        static final int TRANSACTION_requestDescrambler = 17;
        static final int TRANSACTION_requestCasSession = 18;
        static final int TRANSACTION_requestCiCam = 19;
        static final int TRANSACTION_requestLnb = 20;
        static final int TRANSACTION_releaseFrontend = 21;
        static final int TRANSACTION_releaseDemux = 22;
        static final int TRANSACTION_releaseDescrambler = 23;
        static final int TRANSACTION_releaseCasSession = 24;
        static final int TRANSACTION_releaseCiCam = 25;
        static final int TRANSACTION_releaseLnb = 26;
        static final int TRANSACTION_isHigherPriority = 27;
        static final int TRANSACTION_storeResourceMap = 28;
        static final int TRANSACTION_clearResourceMap = 29;
        static final int TRANSACTION_restoreResourceMap = 30;
        static final int TRANSACTION_acquireLock = 31;
        static final int TRANSACTION_releaseLock = 32;
        static final int TRANSACTION_getClientPriority = 33;
        static final int TRANSACTION_getConfigPriority = 34;

        public Stub() {
            this.attachInterface(this, ITunerResourceManager.DESCRIPTOR);
        }

        public static ITunerResourceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITunerResourceManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITunerResourceManager) {
                return (ITunerResourceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITunerResourceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ResourceClientProfile _arg0 = data.readTypedObject(ResourceClientProfile.CREATOR);
                    IResourcesReclaimListener _arg1 = IResourcesReclaimListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2_length = data.readInt();
                    if (_arg2_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg2_length);
                    }
                    int[] _arg2 = _arg2_length < 0 ? null : new int[_arg2_length];
                    data.enforceNoDataAvail();
                    this.registerClientProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeIntArray(_arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterClientProfile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.updateClientPriority(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasUnusedFrontend(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isLowestPriority(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    TunerFrontendInfo[] _arg0 = data.createTypedArray(TunerFrontendInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setFrontendInfoList(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateCasInfo(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    TunerDemuxInfo[] _arg0 = data.createTypedArray(TunerDemuxInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDemuxInfoList(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    long[] _arg0 = data.createLongArray();
                    data.enforceNoDataAvail();
                    this.setLnbInfoList(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setResourceOwnershipRetention(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    TunerFrontendRequest _arg0 = data.readTypedObject(TunerFrontendRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setMaxNumberOfFrontends(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getMaxNumberOfFrontends(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.shareFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.transferOwner(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    TunerDemuxRequest _arg0 = data.readTypedObject(TunerDemuxRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestDemux(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 17: {
                    TunerDescramblerRequest _arg0 = data.readTypedObject(TunerDescramblerRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestDescrambler(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 18: {
                    CasSessionRequest _arg0 = data.readTypedObject(CasSessionRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestCasSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 19: {
                    TunerCiCamRequest _arg0 = data.readTypedObject(TunerCiCamRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestCiCam(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 20: {
                    TunerLnbRequest _arg0 = data.readTypedObject(TunerLnbRequest.CREATOR);
                    int _arg1_length = data.readInt();
                    if (_arg1_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg1_length);
                    }
                    long[] _arg1 = _arg1_length < 0 ? null : new long[_arg1_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.requestLnb(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeLongArray(_arg1);
                    break;
                }
                case 21: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseFrontend(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseDemux(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseDescrambler(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseCasSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseCiCam(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseLnb(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    ResourceClientProfile _arg0 = data.readTypedObject(ResourceClientProfile.CREATOR);
                    ResourceClientProfile _arg1 = data.readTypedObject(ResourceClientProfile.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isHigherPriority(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.storeResourceMap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearResourceMap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restoreResourceMap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.acquireLock(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.releaseLock(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getClientPriority(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.getConfigPriority(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ITunerResourceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITunerResourceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientProfile(ResourceClientProfile profile, IResourcesReclaimListener listener, int[] clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(clientId.length);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _reply.readIntArray(clientId);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClientProfile(int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateClientPriority(int clientId, int priority, int niceValue) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(priority);
                    _data.writeInt(niceValue);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasUnusedFrontend(int frontendType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(frontendType);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLowestPriority(int clientId, int frontendType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(frontendType);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFrontendInfoList(TunerFrontendInfo[] infos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedArray(infos, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCasInfo(int casSystemId, int maxSessionNum) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(casSystemId);
                    _data.writeInt(maxSessionNum);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDemuxInfoList(TunerDemuxInfo[] infos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedArray(infos, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLnbInfoList(long[] lnbIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLongArray(lnbIds);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setResourceOwnershipRetention(int clientId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestFrontend(TunerFrontendRequest request, long[] frontendHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(frontendHandle.length);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(frontendHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMaxNumberOfFrontends(int frontendType, int maxNum) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(frontendType);
                    _data.writeInt(maxNum);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxNumberOfFrontends(int frontendType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(frontendType);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shareFrontend(int selfClientId, int targetClientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(selfClientId);
                    _data.writeInt(targetClientId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean transferOwner(int resourceType, int currentOwnerId, int newOwnerId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(resourceType);
                    _data.writeInt(currentOwnerId);
                    _data.writeInt(newOwnerId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestDemux(TunerDemuxRequest request, long[] demuxHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(demuxHandle.length);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(demuxHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestDescrambler(TunerDescramblerRequest request, long[] descramblerHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(descramblerHandle.length);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(descramblerHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestCasSession(CasSessionRequest request, long[] casSessionHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(casSessionHandle.length);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(casSessionHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestCiCam(TunerCiCamRequest request, long[] ciCamHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(ciCamHandle.length);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(ciCamHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestLnb(TunerLnbRequest request, long[] lnbHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(lnbHandle.length);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readLongArray(lnbHandle);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseFrontend(long frontendHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(frontendHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseDemux(long demuxHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(demuxHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseDescrambler(long descramblerHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(descramblerHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseCasSession(long casSessionHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(casSessionHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseCiCam(long ciCamHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(ciCamHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseLnb(long lnbHandle, int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeLong(lnbHandle);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHigherPriority(ResourceClientProfile challengerProfile, ResourceClientProfile holderProfile) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeTypedObject(challengerProfile, 0);
                    _data.writeTypedObject(holderProfile, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void storeResourceMap(int resourceType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(resourceType);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearResourceMap(int resourceType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(resourceType);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreResourceMap(int resourceType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(resourceType);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acquireLock(int clientId, long clientThreadId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeLong(clientThreadId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseLock(int clientId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(clientId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getClientPriority(int useCase, int pid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(useCase);
                    _data.writeInt(pid);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConfigPriority(int useCase, boolean isForeground) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITunerResourceManager.DESCRIPTOR);
                    _data.writeInt(useCase);
                    _data.writeBoolean(isForeground);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITunerResourceManager {
        @Override
        public void registerClientProfile(ResourceClientProfile profile, IResourcesReclaimListener listener, int[] clientId) throws RemoteException {
        }

        @Override
        public void unregisterClientProfile(int clientId) throws RemoteException {
        }

        @Override
        public boolean updateClientPriority(int clientId, int priority, int niceValue) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasUnusedFrontend(int frontendType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isLowestPriority(int clientId, int frontendType) throws RemoteException {
            return false;
        }

        @Override
        public void setFrontendInfoList(TunerFrontendInfo[] infos) throws RemoteException {
        }

        @Override
        public void updateCasInfo(int casSystemId, int maxSessionNum) throws RemoteException {
        }

        @Override
        public void setDemuxInfoList(TunerDemuxInfo[] infos) throws RemoteException {
        }

        @Override
        public void setLnbInfoList(long[] lnbIds) throws RemoteException {
        }

        @Override
        public void setResourceOwnershipRetention(int clientId, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean requestFrontend(TunerFrontendRequest request, long[] frontendHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean setMaxNumberOfFrontends(int frontendType, int maxNum) throws RemoteException {
            return false;
        }

        @Override
        public int getMaxNumberOfFrontends(int frontendType) throws RemoteException {
            return 0;
        }

        @Override
        public void shareFrontend(int selfClientId, int targetClientId) throws RemoteException {
        }

        @Override
        public boolean transferOwner(int resourceType, int currentOwnerId, int newOwnerId) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestDemux(TunerDemuxRequest request, long[] demuxHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestDescrambler(TunerDescramblerRequest request, long[] descramblerHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestCasSession(CasSessionRequest request, long[] casSessionHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestCiCam(TunerCiCamRequest request, long[] ciCamHandle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestLnb(TunerLnbRequest request, long[] lnbHandle) throws RemoteException {
            return false;
        }

        @Override
        public void releaseFrontend(long frontendHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseDemux(long demuxHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseDescrambler(long descramblerHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseCasSession(long casSessionHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseCiCam(long ciCamHandle, int clientId) throws RemoteException {
        }

        @Override
        public void releaseLnb(long lnbHandle, int clientId) throws RemoteException {
        }

        @Override
        public boolean isHigherPriority(ResourceClientProfile challengerProfile, ResourceClientProfile holderProfile) throws RemoteException {
            return false;
        }

        @Override
        public void storeResourceMap(int resourceType) throws RemoteException {
        }

        @Override
        public void clearResourceMap(int resourceType) throws RemoteException {
        }

        @Override
        public void restoreResourceMap(int resourceType) throws RemoteException {
        }

        @Override
        public boolean acquireLock(int clientId, long clientThreadId) throws RemoteException {
            return false;
        }

        @Override
        public boolean releaseLock(int clientId) throws RemoteException {
            return false;
        }

        @Override
        public int getClientPriority(int useCase, int pid) throws RemoteException {
            return 0;
        }

        @Override
        public int getConfigPriority(int useCase, boolean isForeground) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

