/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.media.tv.TvView;
import android.media.tv.ad.TvAdManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.util.AnnotationValidations;
import java.util.List;
import java.util.concurrent.Executor;

@FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
public class TvAdView
extends ViewGroup {
    private static final String TAG = "TvAdView";
    private static final boolean DEBUG = false;
    public static final String ERROR_KEY_METHOD_NAME = "method_name";
    public static final String ERROR_KEY_ERROR_CODE = "error_code";
    private final TvAdManager mTvAdManager;
    private final Handler mHandler = new Handler();
    private final Object mCallbackLock = new Object();
    private TvAdManager.Session mSession;
    private MySessionCallback mSessionCallback;
    private TvAdCallback mCallback;
    private Executor mCallbackExecutor;
    private final AttributeSet mAttrs;
    private final int mDefStyleAttr;
    private final XmlResourceParser mParser;
    private SurfaceView mSurfaceView;
    private Surface mSurface;
    private boolean mSurfaceChanged;
    private int mSurfaceFormat;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private boolean mUseRequestedSurfaceLayout;
    private int mSurfaceViewLeft;
    private int mSurfaceViewRight;
    private int mSurfaceViewTop;
    private int mSurfaceViewBottom;
    private boolean mMediaViewCreated;
    private Rect mMediaViewFrame;
    private OnUnhandledInputEventListener mOnUnhandledInputEventListener;
    private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

        @Override
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            TvAdView.this.mSurfaceFormat = format;
            TvAdView.this.mSurfaceWidth = width;
            TvAdView.this.mSurfaceHeight = height;
            TvAdView.this.mSurfaceChanged = true;
            TvAdView.this.dispatchSurfaceChanged(TvAdView.this.mSurfaceFormat, TvAdView.this.mSurfaceWidth, TvAdView.this.mSurfaceHeight);
        }

        @Override
        public void surfaceCreated(SurfaceHolder holder) {
            TvAdView.this.mSurface = holder.getSurface();
            TvAdView.this.setSessionSurface(TvAdView.this.mSurface);
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder holder) {
            TvAdView.this.mSurface = null;
            TvAdView.this.mSurfaceChanged = false;
            TvAdView.this.setSessionSurface(null);
        }
    };
    private final TvAdManager.Session.FinishedInputEventCallback mFinishedInputEventCallback = new TvAdManager.Session.FinishedInputEventCallback(){

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            if (handled) {
                return;
            }
            InputEvent event = (InputEvent)token;
            if (TvAdView.this.dispatchUnhandledInputEvent(event)) {
                return;
            }
            ViewRootImpl viewRootImpl = TvAdView.this.getViewRootImpl();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchUnhandledInputEvent(event);
            }
        }
    };

    public TvAdView(@NonNull Context context) {
        this(context, null, 0);
    }

    public TvAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TvAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int sourceResId = Resources.getAttributeSetSourceResId(attrs);
        if (sourceResId != 0) {
            Log.d(TAG, "Build local AttributeSet");
            this.mParser = context.getResources().getXml(sourceResId);
            this.mAttrs = Xml.asAttributeSet(this.mParser);
        } else {
            Log.d(TAG, "Use passed in AttributeSet");
            this.mParser = null;
            this.mAttrs = attrs;
        }
        this.mDefStyleAttr = defStyleAttr;
        this.resetSurfaceView();
        this.mTvAdManager = (TvAdManager)this.getContext().getSystemService("tv_ad");
    }

    public boolean setTvView(@Nullable TvView tvView) {
        if (tvView == null) {
            return this.unsetTvView();
        }
        TvInputManager.Session inputSession = tvView.getInputSession();
        if (inputSession == null || this.mSession == null) {
            return false;
        }
        this.mSession.setInputSession(inputSession);
        inputSession.setAdSession(this.mSession);
        return true;
    }

    private boolean unsetTvView() {
        if (this.mSession == null || this.mSession.getInputSession() == null) {
            return false;
        }
        this.mSession.getInputSession().setAdSession(null);
        this.mSession.setInputSession(null);
        return true;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.createSessionMediaView();
    }

    @Override
    public void onDetachedFromWindow() {
        this.removeSessionMediaView();
        super.onDetachedFromWindow();
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mUseRequestedSurfaceLayout) {
            this.mSurfaceView.layout(this.mSurfaceViewLeft, this.mSurfaceViewTop, this.mSurfaceViewRight, this.mSurfaceViewBottom);
        } else {
            this.mSurfaceView.layout(0, 0, right - left, bottom - top);
        }
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mSurfaceView.measure(widthMeasureSpec, heightMeasureSpec);
        int width = this.mSurfaceView.getMeasuredWidth();
        int height = this.mSurfaceView.getMeasuredHeight();
        int childState = this.mSurfaceView.getMeasuredState();
        this.setMeasuredDimension(TvAdView.resolveSizeAndState(width, widthMeasureSpec, childState), TvAdView.resolveSizeAndState(height, heightMeasureSpec, childState << 16));
    }

    @Override
    public void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mSurfaceView.setVisibility(visibility);
        if (visibility == 0) {
            this.createSessionMediaView();
        } else {
            this.removeSessionMediaView();
        }
    }

    @FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderOnTop(false);
            this.mSurfaceView.setZOrderMediaOverlay(isMediaOverlay);
        }
    }

    @FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
    public void setZOrderOnTop(boolean onTop) {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderMediaOverlay(false);
            this.mSurfaceView.setZOrderOnTop(onTop);
        }
    }

    private void resetSurfaceView() {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
            this.removeView(this.mSurfaceView);
        }
        this.mSurface = null;
        this.mSurfaceView = new SurfaceView(this.getContext(), this.mAttrs, this.mDefStyleAttr){

            protected void updateSurface() {
                super.updateSurface();
                TvAdView.this.relayoutSessionMediaView();
            }
        };
        this.mSurfaceView.setSecure(true);
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceHolderCallback);
        this.mSurfaceView.getHolder().setFormat(-3);
        this.mSurfaceView.setZOrderOnTop(false);
        this.mSurfaceView.setZOrderMediaOverlay(true);
        this.addView(this.mSurfaceView);
    }

    public void reset() {
        this.resetInternal();
    }

    private void resetInternal() {
        this.mSessionCallback = null;
        if (this.mSession != null) {
            this.setSessionSurface(null);
            this.removeSessionMediaView();
            this.mUseRequestedSurfaceLayout = false;
            this.mSession.release();
            this.mSession = null;
            this.resetSurfaceView();
        }
    }

    private void createSessionMediaView() {
        if (this.mSession == null || !this.isAttachedToWindow() || this.mMediaViewCreated) {
            return;
        }
        this.mMediaViewFrame = this.getViewFrameOnScreen();
        this.mSession.createMediaView(this, this.mMediaViewFrame);
        this.mMediaViewCreated = true;
    }

    private void removeSessionMediaView() {
        if (this.mSession == null || !this.mMediaViewCreated) {
            return;
        }
        this.mSession.removeMediaView();
        this.mMediaViewCreated = false;
        this.mMediaViewFrame = null;
    }

    private void relayoutSessionMediaView() {
        if (this.mSession == null || !this.isAttachedToWindow() || !this.mMediaViewCreated) {
            return;
        }
        Rect viewFrame = this.getViewFrameOnScreen();
        if (viewFrame.equals(this.mMediaViewFrame)) {
            return;
        }
        this.mSession.relayoutMediaView(viewFrame);
        this.mMediaViewFrame = viewFrame;
    }

    private Rect getViewFrameOnScreen() {
        Rect frame = new Rect();
        this.getGlobalVisibleRect(frame);
        RectF frameF = new RectF(frame);
        this.getMatrix().mapRect(frameF);
        frameF.round(frame);
        return frame;
    }

    private void setSessionSurface(Surface surface) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.setSurface(surface);
    }

    private void dispatchSurfaceChanged(int format, int width, int height) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.dispatchSurfaceChanged(format, width, height);
    }

    public boolean dispatchUnhandledInputEvent(@NonNull InputEvent event) {
        if (this.mOnUnhandledInputEventListener != null && this.mOnUnhandledInputEventListener.onUnhandledInputEvent(event)) {
            return true;
        }
        return this.onUnhandledInputEvent(event);
    }

    public boolean onUnhandledInputEvent(@NonNull InputEvent event) {
        return false;
    }

    public void setOnUnhandledInputEventListener(@NonNull OnUnhandledInputEventListener listener) {
        this.mOnUnhandledInputEventListener = listener;
    }

    @Nullable
    public OnUnhandledInputEventListener getOnUnhandledInputEventListener() {
        return this.mOnUnhandledInputEventListener;
    }

    public void clearOnUnhandledInputEventListener() {
        this.mOnUnhandledInputEventListener = null;
    }

    @Override
    public boolean dispatchKeyEvent(@Nullable KeyEvent event) {
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        KeyEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    public void prepareAdService(@NonNull String serviceId, @NonNull String type) {
        this.mSessionCallback = new MySessionCallback(serviceId);
        if (this.mTvAdManager != null) {
            this.mTvAdManager.createSession(serviceId, type, this.mSessionCallback, this.mHandler);
        }
    }

    public void startAdService() {
        if (this.mSession != null) {
            this.mSession.startAdService();
        }
    }

    public void stopAdService() {
        if (this.mSession != null) {
            this.mSession.stopAdService();
        }
    }

    public void resetAdService() {
        if (this.mSession != null) {
            this.mSession.resetAdService();
        }
    }

    public void sendCurrentVideoBounds(@NonNull Rect bounds) {
        if (this.mSession != null) {
            this.mSession.sendCurrentVideoBounds(bounds);
        }
    }

    public void sendCurrentChannelUri(@Nullable Uri channelUri) {
        if (this.mSession != null) {
            this.mSession.sendCurrentChannelUri(channelUri);
        }
    }

    public void sendTrackInfoList(@Nullable List<TvTrackInfo> tracks) {
        if (this.mSession != null) {
            this.mSession.sendTrackInfoList(tracks);
        }
    }

    public void sendCurrentTvInputId(@Nullable String inputId) {
        if (this.mSession != null) {
            this.mSession.sendCurrentTvInputId(inputId);
        }
    }

    public void sendSigningResult(@NonNull String signingId, @NonNull byte[] result) {
        if (this.mSession != null) {
            this.mSession.sendSigningResult(signingId, result);
        }
    }

    public void notifyError(@NonNull String errMsg, @NonNull Bundle params) {
        if (this.mSession != null) {
            this.mSession.notifyError(errMsg, params);
        }
    }

    public void notifyTvMessage(@NonNull int type, @NonNull Bundle data) {
        if (this.mSession != null) {
            this.mSession.notifyTvMessage(type, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(@NonNull Executor executor, @NonNull TvAdCallback callback) {
        AnnotationValidations.validate(NonNull.class, null, (Object)callback);
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallbackExecutor = executor;
            this.mCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCallback() {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = null;
            this.mCallbackExecutor = null;
        }
    }

    public TvAdManager.Session getAdSession() {
        return this.mSession;
    }

    private class MySessionCallback
    extends TvAdManager.SessionCallback {
        final String mServiceId;

        MySessionCallback(String serviceId) {
            this.mServiceId = serviceId;
        }

        @Override
        public void onSessionCreated(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onSessionCreated - session already created");
                if (session != null) {
                    session.release();
                }
                return;
            }
            TvAdView.this.mSession = session;
            if (session != null) {
                if (TvAdView.this.mSurface != null) {
                    TvAdView.this.setSessionSurface(TvAdView.this.mSurface);
                    if (TvAdView.this.mSurfaceChanged) {
                        TvAdView.this.dispatchSurfaceChanged(TvAdView.this.mSurfaceFormat, TvAdView.this.mSurfaceWidth, TvAdView.this.mSurfaceHeight);
                    }
                }
                TvAdView.this.createSessionMediaView();
            } else {
                TvAdView.this.mSessionCallback = null;
            }
        }

        @Override
        public void onSessionReleased(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onSessionReleased - session not created");
                return;
            }
            TvAdView.this.mMediaViewCreated = false;
            TvAdView.this.mMediaViewFrame = null;
            TvAdView.this.mSessionCallback = null;
            TvAdView.this.mSession = null;
        }

        @Override
        public void onLayoutSurface(TvAdManager.Session session, int left, int top, int right, int bottom) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onLayoutSurface - session not created");
                return;
            }
            TvAdView.this.mSurfaceViewLeft = left;
            TvAdView.this.mSurfaceViewTop = top;
            TvAdView.this.mSurfaceViewRight = right;
            TvAdView.this.mSurfaceViewBottom = bottom;
            TvAdView.this.mUseRequestedSurfaceLayout = true;
            TvAdView.this.requestLayout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestCurrentVideoBounds(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onRequestCurrentVideoBounds - session not created");
                return;
            }
            Object object = TvAdView.this.mCallbackLock;
            synchronized (object) {
                if (TvAdView.this.mCallbackExecutor != null) {
                    TvAdView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvAdView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvAdView.this.mCallback != null) {
                                TvAdView.this.mCallback.onRequestCurrentVideoBounds(this.mServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestCurrentChannelUri(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onRequestCurrentChannelUri - session not created");
                return;
            }
            Object object = TvAdView.this.mCallbackLock;
            synchronized (object) {
                if (TvAdView.this.mCallbackExecutor != null) {
                    TvAdView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvAdView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvAdView.this.mCallback != null) {
                                TvAdView.this.mCallback.onRequestCurrentChannelUri(this.mServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestTrackInfoList(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onRequestTrackInfoList - session not created");
                return;
            }
            Object object = TvAdView.this.mCallbackLock;
            synchronized (object) {
                if (TvAdView.this.mCallbackExecutor != null) {
                    TvAdView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvAdView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvAdView.this.mCallback != null) {
                                TvAdView.this.mCallback.onRequestTrackInfoList(this.mServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestCurrentTvInputId(TvAdManager.Session session) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onRequestCurrentTvInputId - session not created");
                return;
            }
            Object object = TvAdView.this.mCallbackLock;
            synchronized (object) {
                if (TvAdView.this.mCallbackExecutor != null) {
                    TvAdView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvAdView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvAdView.this.mCallback != null) {
                                TvAdView.this.mCallback.onRequestCurrentTvInputId(this.mServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestSigning(TvAdManager.Session session, String id2, String algorithm, String alias, byte[] data) {
            if (this != TvAdView.this.mSessionCallback) {
                Log.w(TvAdView.TAG, "onRequestSigning - session not created");
                return;
            }
            Object object = TvAdView.this.mCallbackLock;
            synchronized (object) {
                if (TvAdView.this.mCallbackExecutor != null) {
                    TvAdView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvAdView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvAdView.this.mCallback != null) {
                                TvAdView.this.mCallback.onRequestSigning(this.mServiceId, id2, algorithm, alias, data);
                            }
                        }
                    });
                }
            }
        }
    }

    public static interface OnUnhandledInputEventListener {
        public boolean onUnhandledInputEvent(@NonNull InputEvent var1);
    }

    public static abstract class TvAdCallback {
        public void onRequestCurrentVideoBounds(@NonNull String serviceId) {
        }

        public void onRequestCurrentChannelUri(@NonNull String serviceId) {
        }

        public void onRequestTrackInfoList(@NonNull String serviceId) {
        }

        public void onRequestCurrentTvInputId(@NonNull String serviceId) {
        }

        public void onRequestSigning(@NonNull String serviceId, @NonNull String signingId, @NonNull String algorithm, @NonNull String alias, @NonNull byte[] data) {
        }

        public void onStateChanged(@NonNull String serviceId, int state, int err) {
        }
    }
}

