/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITvAdManagerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.ad.ITvAdManagerCallback";

    public void onAdServiceAdded(String var1) throws RemoteException;

    public void onAdServiceRemoved(String var1) throws RemoteException;

    public void onAdServiceUpdated(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvAdManagerCallback {
        static final int TRANSACTION_onAdServiceAdded = 1;
        static final int TRANSACTION_onAdServiceRemoved = 2;
        static final int TRANSACTION_onAdServiceUpdated = 3;

        public Stub() {
            this.attachInterface(this, ITvAdManagerCallback.DESCRIPTOR);
        }

        public static ITvAdManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvAdManagerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITvAdManagerCallback) {
                return (ITvAdManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAdServiceAdded";
                }
                case 2: {
                    return "onAdServiceRemoved";
                }
                case 3: {
                    return "onAdServiceUpdated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvAdManagerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAdServiceAdded(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAdServiceRemoved(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAdServiceUpdated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ITvAdManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvAdManagerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceAdded(String serviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdManagerCallback.DESCRIPTOR);
                    _data.writeString(serviceId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceRemoved(String serviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdManagerCallback.DESCRIPTOR);
                    _data.writeString(serviceId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdServiceUpdated(String serviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvAdManagerCallback.DESCRIPTOR);
                    _data.writeString(serviceId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvAdManagerCallback {
        @Override
        public void onAdServiceAdded(String serviceId) throws RemoteException {
        }

        @Override
        public void onAdServiceRemoved(String serviceId) throws RemoteException {
        }

        @Override
        public void onAdServiceUpdated(String serviceId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

