/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.media.tv.flags.tiaf_v_apis")
public class SignalingDataInfo
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<SignalingDataInfo> CREATOR = new Parcelable.Creator<SignalingDataInfo>(){

        public SignalingDataInfo[] newArray(int size) {
            return new SignalingDataInfo[size];
        }

        @Override
        public SignalingDataInfo createFromParcel(@NonNull Parcel in) {
            return new SignalingDataInfo(in);
        }
    };
    @NonNull
    private final String mTable;
    @NonNull
    private final String mSignalingDataType;
    private final int mVersion;
    private final int mGroup;
    @NonNull
    private final String mEncoding;
    public static final int LLS_NO_GROUP_ID = -1;
    public static final String CONTENT_ENCODING_UTF_8 = "UTF-8";
    public static final String CONTENT_ENCODING_BASE64 = "Base64";

    public SignalingDataInfo(@NonNull String table, @NonNull String signalingDataType, int version, int group) {
        this.mTable = table;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTable);
        this.mSignalingDataType = signalingDataType;
        this.mVersion = version;
        this.mGroup = group;
        this.mEncoding = CONTENT_ENCODING_UTF_8;
    }

    public SignalingDataInfo(@NonNull String table, @NonNull String signalingDataType, int version, int group, @NonNull String encoding) {
        this.mTable = table;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTable);
        this.mSignalingDataType = signalingDataType;
        this.mVersion = version;
        this.mGroup = group;
        this.mEncoding = encoding;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mEncoding);
    }

    @NonNull
    public String getTable() {
        return this.mTable;
    }

    @NonNull
    public String getSignalingDataType() {
        return this.mSignalingDataType;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public int getGroup() {
        return this.mGroup;
    }

    @NonNull
    public String getEncoding() {
        return this.mEncoding;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mTable);
        dest.writeString(this.mSignalingDataType);
        dest.writeInt(this.mVersion);
        dest.writeInt(this.mGroup);
        dest.writeString(this.mEncoding);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SignalingDataInfo(@NonNull Parcel in) {
        String table = in.readString();
        String metadataType = in.readString();
        int version = in.readInt();
        int group = in.readInt();
        String encoding = in.readString();
        this.mTable = table;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTable);
        this.mSignalingDataType = metadataType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSignalingDataType);
        this.mVersion = version;
        this.mGroup = group;
        this.mEncoding = encoding;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mEncoding);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentEncoding {
    }
}

