/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.TvStreamConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface ITvInputHardware
extends IInterface {
    public boolean setSurface(Surface var1, TvStreamConfig var2) throws RemoteException;

    public void setStreamVolume(float var1) throws RemoteException;

    public void overrideAudioSink(int var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputHardware {
        public static final String DESCRIPTOR = "android.media.tv.ITvInputHardware";
        static final int TRANSACTION_setSurface = 1;
        static final int TRANSACTION_setStreamVolume = 2;
        static final int TRANSACTION_overrideAudioSink = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputHardware asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputHardware) {
                return (ITvInputHardware)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setSurface";
                }
                case 2: {
                    return "setStreamVolume";
                }
                case 3: {
                    return "overrideAudioSink";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    TvStreamConfig _arg1 = data.readTypedObject(TvStreamConfig.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setSurface(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setStreamVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overrideAudioSink(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ITvInputHardware {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSurface(Surface surface, TvStreamConfig config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(surface, 0);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolume(float volume) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(volume);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioType);
                    _data.writeString(audioAddress);
                    _data.writeInt(samplingRate);
                    _data.writeInt(channelMask);
                    _data.writeInt(format);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInputHardware {
        @Override
        public boolean setSurface(Surface surface, TvStreamConfig config) throws RemoteException {
            return false;
        }

        @Override
        public void setStreamVolume(float volume) throws RemoteException {
        }

        @Override
        public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

